/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AbstractIvmlVariable;

public abstract class OperationDescriptor
implements IMetaOperation {
    public static final String CONSTRUCTOR_NAME = "create";
    public static final List<TypeDescriptor<?>> EMPTY_PARAMETER = Collections.unmodifiableList(new ArrayList(0));
    private String name;
    private boolean isConstructor = false;
    private OperationType opType = OperationType.NORMAL;
    private TypeDescriptor<?> declaringType;
    private TypeDescriptor<?> returnType;
    private AliasType aliasType = AliasType.NONE;
    private List<TypeDescriptor<?>> parameter;
    private boolean acceptsNamedParameters = false;
    private boolean acceptsImplicitParameters = false;
    private boolean isConversion;

    protected OperationDescriptor(TypeDescriptor<?> declaringType, String name, boolean isConstructor) {
        this.declaringType = declaringType;
        this.name = name;
        this.isConstructor = isConstructor;
    }

    protected void setCharacteristics(OperationType opType, AliasType aliasType, boolean isConversion, String name) {
        this.opType = opType;
        this.aliasType = aliasType;
        this.isConversion = isConversion;
        this.name = name;
    }

    private void initialize() {
        if (null == this.parameter) {
            this.initializeParameters();
        }
        if (null == this.returnType) {
            this.initializeReturnType();
        }
    }

    protected abstract void initializeParameters();

    protected abstract void initializeReturnType();

    protected void setParameters(List<TypeDescriptor<?>> parameters, boolean acceptsNamedParameters, boolean acceptsImplicitParameters) {
        this.parameter = parameters;
        this.acceptsNamedParameters = acceptsNamedParameters;
        this.acceptsImplicitParameters = acceptsImplicitParameters;
    }

    protected void setReturnType(TypeDescriptor<?> returnType) {
        this.returnType = returnType;
    }

    @Override
    public boolean acceptsNamedParameters() {
        return this.acceptsNamedParameters;
    }

    public boolean acceptsImplicitParameters() {
        return this.acceptsImplicitParameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected final String getStoredName() {
        return this.name;
    }

    public OperationType getOperationType() {
        return this.opType;
    }

    protected AliasType getAliasType() {
        return this.aliasType;
    }

    public String getDeclaringTypeName() {
        String result = null != this.declaringType ? this.declaringType.getName() : this.getDeclaringTypeNameFallback();
        return result;
    }

    protected abstract String getDeclaringTypeNameFallback();

    @Override
    public String getSignature() {
        StringBuilder tmp = new StringBuilder();
        if (this.isConstructor()) {
            tmp.append("new ");
            tmp.append(this.getDeclaringTypeName());
            tmp.append(" ");
        } else {
            tmp.append(this.getName());
        }
        tmp.append("(");
        int pCount = this.getParameterCount();
        for (int p = 0; p < pCount; ++p) {
            tmp.append(((TypeDescriptor)this.getParameterType(p)).getVilName());
            if (p >= pCount - 1) continue;
            tmp.append(",");
        }
        tmp.append(")");
        return tmp.toString();
    }

    @Override
    public abstract String getJavaSignature();

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    public TypeDescriptor<?> getDeclaringType() {
        return this.declaringType;
    }

    public AliasType isAlias() {
        return this.aliasType;
    }

    protected void throwIncompatibleParameter(Object[] args) throws VilException {
        StringBuilder tmp = new StringBuilder("(");
        int start = 0;
        if (!this.isStatic()) {
            start = 1;
        }
        for (int i = start; i < args.length; ++i) {
            if (i > start) {
                tmp.append(", ");
            }
            if (null == args[i]) {
                tmp.append("null");
                continue;
            }
            tmp.append(args[i].getClass().getSimpleName());
        }
        tmp.append(")");
        throw new VilException("incompatible parameter " + tmp + " cannot be applied to " + this.getJavaSignature(), 40002);
    }

    public static boolean isSameSignature(Method method1, Method method2) {
        Class<?>[] param2;
        Class<?>[] param1;
        boolean same = false;
        if (method1.getName().equals(method2.getName()) && method1.getReturnType().equals(method2.getReturnType()) && (param1 = method1.getParameterTypes()).length == (param2 = method2.getParameterTypes()).length) {
            same = true;
            for (int p = 0; same && p < param1.length; ++p) {
                same = param1[p].equals(param2[p]);
            }
        }
        return same;
    }

    public static boolean isConstructor(Method method) {
        int modifier = method.getModifiers();
        boolean modOk = Modifier.isPublic(modifier) && !Modifier.isAbstract(modifier) && Modifier.isStatic(modifier);
        return modOk && method.getName().equals(CONSTRUCTOR_NAME) && method.getReturnType().equals(method.getDeclaringClass());
    }

    public static boolean isOperation(Method method) {
        int modifier = method.getModifiers();
        return Modifier.isPublic(modifier) && !OperationDescriptor.isConstructor(method);
    }

    static boolean isOperationOrConstructor(Method method) {
        return OperationDescriptor.isOperation(method) || OperationDescriptor.isConstructor(method);
    }

    @Override
    public TypeDescriptor<?> getReturnType() {
        this.initialize();
        return this.returnType;
    }

    @Override
    public int getParameterCount() {
        this.initialize();
        return this.parameter.size();
    }

    @Override
    public int getRequiredParameterCount() {
        return this.getParameterCount();
    }

    @Override
    public TypeDescriptor<?> getParameterType(int index) {
        this.initialize();
        return this.parameter.get(index);
    }

    @Override
    public IMetaParameterDeclaration getParameter(String name) {
        return null;
    }

    public IMetaParameterDeclaration getParameter(int index) {
        return null;
    }

    public String toString() {
        return this.getJavaSignature();
    }

    public boolean isTypeSelect() {
        boolean ok = false;
        if (!this.isStatic()) {
            this.initialize();
            ok = this.returnType.isCollection() && 2 == this.getParameterCount() && TypeRegistry.typeType() == this.getParameterType(1);
        }
        return ok;
    }

    public boolean isGenericCollectionOperation() {
        boolean ok = false;
        if (!this.isStatic()) {
            this.initialize();
            if (this.returnType.isCollection() && this.getParameterCount() > 0) {
                ok = ((TypeDescriptor)this.getParameterType(0)).isCollection() || ((TypeDescriptor)this.getParameterType(0)).isMap();
            }
        }
        return ok;
    }

    public boolean isIteratingCollectionOperation() {
        boolean ok = false;
        this.initialize();
        if (!this.isStatic() && this.getParameterCount() > 1 && ((TypeDescriptor)this.getParameterType(0)).isCollection()) {
            int count = 0;
            for (int p = 1; p < this.getParameterCount(); ++p) {
                if (ExpressionEvaluator.class != ((TypeDescriptor)this.getParameterType(0)).getTypeClass()) continue;
                ++count;
            }
            ok = count == 1;
        }
        return ok;
    }

    public boolean isConversion() {
        return this.isConversion;
    }

    public abstract int useGenericParameterAsReturn();

    public abstract int useParameterAsReturn();

    public abstract boolean storeArtifactsBeforeExecution();

    public boolean requiresDynamicExpressionProcessing() {
        return false;
    }

    public boolean trace() {
        return !this.isConversion() && this.getOperationType().trace();
    }

    public OperationDescriptor specializeFor(TypeDescriptor<?> declaringType) {
        return this;
    }

    public boolean allowsAggregation() {
        return false;
    }

    protected String composeExceptionMessage(Throwable ex, Object[] args) {
        return ex.getMessage() + " calling " + this.getSignature() + " with " + Arrays.toString(args);
    }

    protected void convertVariables(Object[] params) {
        TypeDescriptor<?> any = TypeRegistry.anyType();
        int n = Math.min(this.getParameterCount(), params.length);
        for (int p = 0; p < n; ++p) {
            if (any != this.getParameterType(p) || !(params[p] instanceof AbstractIvmlVariable)) continue;
            params[p] = ((AbstractIvmlVariable)params[p]).getValue();
        }
    }

    public boolean isOclCompliant() {
        return true;
    }

    public boolean useAny() {
        return false;
    }

    public boolean flatten() {
        return false;
    }

    public boolean useOperandTypeAsParameter() {
        return false;
    }

    public static enum AliasType {
        NONE,
        EXPLICIT,
        IMPLICIT;

    }
}

