/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FolderArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.ProjectSettings;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;

public class Project
implements IVilType,
IStringValueProvider {
    private static final Map<String, Project> CACHE = new HashMap<String, Project>();
    private ArtifactModel artifactModel;
    private File base;
    private IProjectDescriptor descriptor;
    private boolean empty;
    private String name;

    public Project() {
        this.base = new File(".");
        this.empty = true;
        this.artifactModel = ArtifactFactory.createArtifactModel(this.base);
    }

    public Project(File base, ProgressObserver observer) throws VilException {
        this.base = base.getAbsoluteFile();
        this.name = base.getName();
        this.empty = false;
        this.artifactModel = ArtifactFactory.createArtifactModel(base);
        this.artifactModel.scanAll(observer);
    }

    public Project(Project project, ProgressObserver observer) throws VilException {
        this.base = project.base;
        this.empty = project.empty;
        this.name = project.name;
        this.artifactModel = ArtifactFactory.createArtifactModel(this.base);
        if (!this.empty) {
            this.artifactModel.scanAll(observer);
        }
    }

    private Project(IProjectDescriptor descriptor, ProgressObserver observer) throws VilException {
        this(descriptor.getBase().getAbsoluteFile(), observer);
        this.descriptor = descriptor;
        if (null != descriptor.getMainVilScript()) {
            this.name = descriptor.getMainVilScript().getName();
        }
    }

    public String getName() {
        return this.name;
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public Set<FileArtifact> selectAllFiles() {
        return this.artifactModel.selectByType(FileArtifact.class, false);
    }

    @OperationMeta(returnGenerics={FolderArtifact.class})
    public Set<FolderArtifact> selectAllFolders() {
        return this.artifactModel.selectAllFolders();
    }

    public Path getPath() {
        return Path.createInstance(".", this.artifactModel);
    }

    public Path localize(Project source, Path path) {
        return Path.createInstance(path, this.artifactModel);
    }

    public Path localize(Project source, IFileSystemArtifact artifact) throws VilException {
        return Path.createInstance(artifact.getPath(), this.artifactModel);
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public Set<FileArtifact> getLocalProjectArtifacts() {
        return this.getPath().selectAll();
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public Set<FileArtifact> selectByType(Class<?> type) {
        return this.artifactModel.selectByType(type, false);
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public Set<FileArtifact> selectByKind(Class<?> type) {
        return this.artifactModel.selectByKind(type, false);
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public Set<FileArtifact> typeReject(Class<?> type) {
        return this.artifactModel.selectByKind(type, true);
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public Set<FileArtifact> selectByName(String name) {
        return this.artifactModel.selectByName(name);
    }

    public static Project getProjectFor(IProjectDescriptor descriptor) throws VilException {
        String key = descriptor.getBase().getAbsoluteFile().toString();
        Project result = CACHE.get(key);
        if (null == result) {
            result = new Project(descriptor, descriptor.createObserver());
            CACHE.put(key, result);
        }
        return result;
    }

    public static void clearProjectDescriptorCache() {
        CACHE.clear();
    }

    @OperationMeta(returnGenerics={Project.class})
    public Set<Project> predecessors() throws VilException {
        Project[] tmp;
        if (null != this.descriptor) {
            int count = this.descriptor.getPredecessorCount();
            tmp = new Project[count];
            for (int p = 0; p < count; ++p) {
                tmp[p] = Project.getProjectFor(this.descriptor.getPredecessor(p));
            }
        } else {
            tmp = new Project[]{};
        }
        return new ArraySet<Project>(tmp, Project.class);
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        String result = null != comparator && comparator.inTracer() ? "<project>" : this.artifactModel.getBasePath();
        return result;
    }

    public Path getEasyFolder() {
        return this.createPathWithFallback(IProjectDescriptor.ModelKind.IVML);
    }

    public Path getIvmlFolder() {
        return this.createPathWithFallback(IProjectDescriptor.ModelKind.IVML);
    }

    public Path getVilFolder() {
        return this.createPathWithFallback(IProjectDescriptor.ModelKind.VIL);
    }

    public Path getVtlFolder() {
        return this.createPathWithFallback(IProjectDescriptor.ModelKind.VTL);
    }

    private Path createPathWithFallback(IProjectDescriptor.ModelKind kind) {
        String path = null;
        if (null != this.descriptor) {
            path = this.descriptor.getModelFolder(kind);
        }
        if (null == path) {
            path = "EASy";
        }
        return Path.createInstance(path, this.artifactModel);
    }

    @Invisible
    public void release() {
        if (null != this.artifactModel) {
            ArtifactFactory.release(this.artifactModel);
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @Invisible
    public ArtifactModel getArtifactModel() {
        return this.artifactModel;
    }

    @Conversion
    public static Path convert(Project project) {
        return project.getPath();
    }

    public Script getMainVilScript() {
        Script result = null != this.descriptor ? this.descriptor.getMainVilScript() : null;
        return result;
    }

    public void setSettings(ProjectSettings key, Object object) {
        this.artifactModel.setSettings(key, object);
    }

    public Object getSettings(ProjectSettings key) {
        return this.artifactModel.getSettings(key);
    }
}

