/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.ssehub.easy.instantiation.core.model.common.ExecutionLocal;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ClassMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.UnmodifiableSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;

@ClassMeta(name="String", equiv={String.class})
public class PseudoString
implements IVilType {
    @DefaultValue
    public static final String DEFAULT = "";

    protected PseudoString() {
    }

    @OperationMeta(name={"+"}, opType=OperationType.INFIX)
    public static String plus(String s1, Object s2) {
        String s2Tmp;
        String string = s2Tmp = null == s2 ? null : s2.toString();
        String result = null == s1 ? s2Tmp : (null == s2 ? s1 : s1 + s2Tmp);
        return result;
    }

    public static String concat(String s1, Object s2) {
        return PseudoString.plus(s1, s2);
    }

    @OperationMeta(name={"=="}, opType=OperationType.INFIX)
    public static boolean equals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    @OperationMeta(name={"!=", "<>"}, opType=OperationType.INFIX)
    public static boolean unequals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && !s1.equals(s2);
    }

    @OperationMeta(name={"length", "size"})
    public static int length(String string) {
        return null == string ? 0 : string.length();
    }

    public static boolean matches(String string, String regEx) {
        boolean result = null != string && null != regEx ? string.matches(regEx) : false;
        return result;
    }

    @OperationMeta(returnGenerics={String.class})
    public static Sequence<String> split(String string, String regEx) {
        ArraySequence<String> result;
        if (null == string || null == regEx) {
            result = null;
        } else {
            String[] tmp = string.split(regEx);
            if (null == tmp) {
                tmp = new String[]{};
            }
            TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
            param[0] = TypeRegistry.stringType();
            result = new ArraySequence<String>(tmp, param);
        }
        return result;
    }

    public static String substitute(String string, String regEx, String replacement) {
        return string.replaceAll(regEx, replacement);
    }

    public static String replace(String string, String search, String replacement) {
        return string.replace(search, replacement);
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static Integer toInteger(String string) {
        Integer result;
        try {
            result = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            result = null;
        }
        return result;
    }

    public static boolean matchInteger(String string) {
        boolean result;
        try {
            Integer.parseInt(string);
            result = true;
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static Double toReal(String string) {
        Double result;
        if (null == string) {
            result = null;
        } else {
            try {
                result = Double.parseDouble(string);
            }
            catch (NumberFormatException e) {
                result = null;
            }
        }
        return result;
    }

    public static boolean matchReal(String string) {
        boolean result;
        try {
            Double.parseDouble(string);
            result = true;
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static Boolean toBoolean(String string) {
        Boolean result = null != string ? Boolean.valueOf("true".equalsIgnoreCase(string)) : null;
        return result;
    }

    public static boolean matchBoolean(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false");
    }

    public static String substring(String in, int start, int end) {
        int s = OclKeyWords.toJavaIndex(start);
        int e = OclKeyWords.toJavaIndex(end);
        String result = null != in && s >= 0 && s < e && e <= in.length() ? in.substring(s, e) : in;
        return result;
    }

    public static String substring(String in, int start) {
        int s = OclKeyWords.toJavaIndex(start);
        String result = null != in && s >= 0 && s < in.length() ? in.substring(s) : in;
        return result;
    }

    public static boolean startsWith(String string, String prefix) {
        boolean result = null != string ? string.startsWith(prefix) : false;
        return result;
    }

    public static boolean endsWith(String string, String postfix) {
        boolean result = null != string ? string.endsWith(postfix) : false;
        return result;
    }

    public static String trim(String string) {
        return string.trim();
    }

    public static String normalizeSpace(String string) {
        String result = string.trim();
        while ((result = result.replace("  ", " ")).indexOf("  ") >= 0) {
        }
        return result;
    }

    public static String substringBefore(String string, String match) {
        int pos = string.indexOf(match);
        String result = pos >= 0 ? string.substring(0, pos) : DEFAULT;
        return result;
    }

    public static String substringAfter(String string, String match) {
        int pos = string.indexOf(match);
        String result = pos >= 0 ? string.substring(pos + match.length()) : DEFAULT;
        return result;
    }

    @OperationMeta(name={"toUpperCase", "toUpper"})
    public static String toUpperCase(String string) {
        return string.toUpperCase(ExecutionLocal.getCurrentLocale());
    }

    @OperationMeta(name={"toLowerCase", "toLower"})
    public static String toLowerCase(String string) {
        return string.toLowerCase(ExecutionLocal.getCurrentLocale());
    }

    @OperationMeta(name={"firstToUpper", "firstToUpperCase"})
    public static String firstToUpperCase(String string) {
        return StringValueHelper.firstToUpperCase(string, ExecutionLocal.getCurrentLocale());
    }

    @OperationMeta(name={"firstToLower", "firstToLowerCase"})
    public static String firstToLowerCase(String string) {
        return StringValueHelper.firstToLowerCase(string, ExecutionLocal.getCurrentLocale());
    }

    @OperationMeta(name={"lastToUpper", "lastToUpperCase"})
    public static String lastToUpperCase(String string) {
        return StringValueHelper.lastToUpperCase(string, ExecutionLocal.getCurrentLocale());
    }

    @OperationMeta(name={"lastToLower", "lastToLowerCase"})
    public static String lastToLowerCase(String string) {
        return StringValueHelper.lastToLowerCase(string, ExecutionLocal.getCurrentLocale());
    }

    public static String toIdentifier(String string) {
        StringBuilder tmp = new StringBuilder(string);
        PseudoString.deleteNonJavaIdentifierParts(tmp);
        return tmp.toString();
    }

    public static String toIdentifier(String string, String prefix) {
        String tmp = PseudoString.toIdentifier(string);
        if (tmp.length() > 0) {
            if (!Character.isJavaIdentifierStart(tmp.charAt(0))) {
                tmp = prefix + tmp;
            }
        } else {
            tmp = prefix;
        }
        return tmp;
    }

    private static void deleteNonJavaIdentifierParts(StringBuilder name) {
        for (int i = name.length() - 1; i >= 0; --i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            name.deleteCharAt(i);
        }
    }

    public static String toCamelCaseIdentifier(String string) {
        StringBuilder tmp = new StringBuilder(string);
        for (int i = tmp.length() - 1; i >= 0; --i) {
            char cNext;
            char c = tmp.charAt(i);
            if (!Character.isWhitespace(c) || i + 1 >= tmp.length() || !Character.isLowerCase(cNext = tmp.charAt(i + 1))) continue;
            tmp.setCharAt(i + 1, Character.toUpperCase(cNext));
        }
        PseudoString.deleteNonJavaIdentifierParts(tmp);
        return tmp.toString();
    }

    public static boolean matchIdentifier(String string) {
        boolean isIdentifier = true;
        for (int i = string.length() - 1; isIdentifier && i >= 0; --i) {
            isIdentifier = Character.isJavaIdentifierPart(string.charAt(i));
        }
        return isIdentifier;
    }

    @Conversion
    public static String convertAny(Object any) {
        return StringValueHelper.getStringValue(any, null);
    }

    @OperationMeta(returnGenerics={String.class})
    public static Sequence<String> tokenize(String string, String delimiters) {
        ArraySequence<String> result;
        if (null != string) {
            StringTokenizer tokenizer = new StringTokenizer(string, delimiters);
            String[] tmp = new String[tokenizer.countTokens()];
            int count = 0;
            while (tokenizer.hasMoreTokens()) {
                tmp[count++] = tokenizer.nextToken();
            }
            result = new ArraySequence<String>(tmp, String.class);
        } else {
            result = null;
        }
        return result;
    }

    @OperationMeta(opType=OperationType.FUNCTION)
    public static String toString(String string) {
        return string;
    }

    @OperationMeta(name={"indexOf", "find"})
    public static Integer indexOf(String string, String part) {
        Integer result = null;
        if (null != string && null != part) {
            result = OclKeyWords.toIvmlIndex(string.indexOf(part));
        }
        return result;
    }

    public static Integer rfind(String string, String part) {
        Integer result = null;
        if (null != string && null != part) {
            result = OclKeyWords.toIvmlIndex(string.lastIndexOf(part));
        }
        return result;
    }

    public static boolean isQuoted(String string, String quote) {
        return string.startsWith(quote) && string.endsWith(quote);
    }

    public static String quotify(String string, String quote) {
        return quote + string + quote;
    }

    public static String unquotify(String string, String quote) {
        String result = string;
        if (PseudoString.isQuoted(result, quote)) {
            int qLen = quote.length();
            result = result.substring(qLen, result.length() - qLen);
        }
        return result;
    }

    public static String at(String string, int index) {
        String result = null;
        int i = OclKeyWords.toJavaIndex(index);
        if (null != string && 0 <= i && i <= string.length()) {
            result = String.valueOf(string.charAt(i));
        }
        return result;
    }

    public static String osName() {
        return System.getProperty("os.name");
    }

    public static String getProperty(String key, String dflt) {
        return System.getProperty(key, dflt);
    }

    public static boolean equalsIgnoreCase(String string1, String string2) {
        Locale locale = ExecutionLocal.getCurrentLocale();
        return string1.toLowerCase(locale).equals(string2.toLowerCase(locale));
    }

    @OperationMeta(name={"<"}, opType=OperationType.INFIX)
    public static boolean lessThan(String string1, String string2) {
        return ExecutionLocal.getCurrentCollator().compare(string1, string2) < 0;
    }

    @OperationMeta(name={"<="}, opType=OperationType.INFIX)
    public static boolean lessThanEqual(String string1, String string2) {
        return ExecutionLocal.getCurrentCollator().compare(string1, string2) <= 0;
    }

    @OperationMeta(name={">"}, opType=OperationType.INFIX)
    public static boolean greaterThan(String string1, String string2) {
        return ExecutionLocal.getCurrentCollator().compare(string1, string2) > 0;
    }

    @OperationMeta(name={">="}, opType=OperationType.INFIX)
    public static boolean greaterThanEqual(String string1, String string2) {
        return ExecutionLocal.getCurrentCollator().compare(string1, string2) >= 0;
    }

    @OperationMeta(returnGenerics={String.class}, opType=OperationType.FUNCTION)
    public static Sequence<String> characters(String string) {
        String[] res = new String[string.length()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = String.valueOf(string.charAt(i));
        }
        ArraySequence<String> tmp = new ArraySequence<String>(res, String.class);
        return new UnmodifiableSequence<String>(tmp);
    }

    public static TypeDescriptor<?> getType(String value) {
        return TypeRegistry.stringType();
    }

    @OperationMeta(name={"=="}, opType=OperationType.INFIX)
    public static boolean equals(String string, TypeDescriptor<?> type) {
        return type.getName().equals(string) || type.getQualifiedName().equals(string);
    }

    @OperationMeta(name={"!=", "<>"}, opType=OperationType.INFIX)
    public static boolean notEquals(String string, TypeDescriptor<?> type) {
        return !PseudoString.equals(string, type);
    }

    public static String format(String format, Object value) {
        String result = null;
        result = value instanceof Map ? PseudoString.format(format, ((Map)value).toMappedMap()) : (value instanceof java.util.Map ? PseudoString.formatImpl(format, (java.util.Map)value) : (value instanceof Sequence ? PseudoString.formatImpl(format, ((Sequence)value).toMappedList()) : (value instanceof List ? PseudoString.formatImpl(format, (List)value) : (value instanceof DecisionVariable ? PseudoString.formatImpl(format, ((DecisionVariable)value).getValue()) : PseudoString.formatImpl(format, value)))));
        return result;
    }

    private static String formatImpl(String format, java.util.Map<?, ?> value) {
        String result = format;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            result = result.replace("%(" + StringValueHelper.getStringValue(entry.getKey(), null) + ")", StringValueHelper.getStringValue(entry.getValue(), null));
        }
        return result;
    }

    private static String formatImpl(String format, List<?> values) {
        return PseudoString.formatImpl(format, values.toArray());
    }

    private static String formatImpl(String format, Object ... values) {
        String result;
        try {
            result = String.format(format, values);
        }
        catch (IllegalFormatException e) {
            result = null;
        }
        return result;
    }
}

