/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.ClassMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoAny;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoString;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

@ClassMeta(name="Type", equiv={Class.class, TypeDescriptor.class})
public final class PseudoType
implements IVilType {
    private PseudoType() {
    }

    public static TypeDescriptor<?> getType(TypeDescriptor<?> value) {
        return TypeRegistry.typeType();
    }

    @OperationMeta(name={"=="}, opType=OperationType.INFIX)
    public static boolean equals(TypeDescriptor<?> type, String string) {
        return PseudoString.equals(string, type);
    }

    @OperationMeta(name={"!=", "<>"}, opType=OperationType.INFIX)
    public static boolean notEquals(TypeDescriptor<?> type, String string) {
        return !PseudoString.equals(string, type);
    }

    @OperationMeta(name={"=="}, opType=OperationType.INFIX)
    public static boolean equals(TypeDescriptor<?> type1, TypeDescriptor<?> type2) {
        return type1.isSame(type2);
    }

    @OperationMeta(name={"!=", "<>"}, opType=OperationType.INFIX)
    public static boolean notEquals(TypeDescriptor<?> type1, TypeDescriptor<?> type2) {
        return !type1.isSame(type2);
    }

    @Conversion
    public static String toString(TypeDescriptor<?> type) {
        return type.getName();
    }

    public static String getName(TypeDescriptor<?> type) {
        return type.getName();
    }

    public static String getQualifiedName(TypeDescriptor<?> type) {
        return type.getQualifiedName();
    }

    public static boolean isTypeOf(Object ob, TypeDescriptor<?> type) {
        return type.isSame(PseudoAny.getType(ob));
    }

    public static boolean isKindOf(Object ob, TypeDescriptor<?> type) {
        boolean result;
        TypeDescriptor<?> realType = TypeRegistry.realType();
        TypeDescriptor<?> obType = PseudoAny.getType(ob);
        if (type == realType) {
            TypeDescriptor<?> intType = TypeRegistry.integerType();
            result = obType == realType || obType == intType;
        } else {
            result = type.isAssignableFrom(obType);
        }
        return result;
    }

    @OperationMeta(returnGenerics={IVilType.class}, useOperandTypeAsParameter=true, opType=OperationType.FUNCTION)
    public static Set<?> allInstances(TypeDescriptor<?> type) {
        Set<?> result = type.allInstances();
        if (null == result) {
            result = new ArraySet<Object>(new Object[0], type);
        }
        return result;
    }
}

