/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ILazyDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.SignatureUtils;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class ReflectionConstructorDescriptor
extends OperationDescriptor
implements ILazyDescriptor {
    private Constructor<?> constructor;

    public ReflectionConstructorDescriptor(TypeDescriptor<?> declaringType, Constructor<?> constructor) {
        super(declaringType, "create", true);
        this.constructor = constructor;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isFirstParameterOperand() {
        return false;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    protected void initializeParameters() {
        Class<?>[] params = this.constructor.getParameterTypes();
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < params.length; ++i) {
            parameters.add(ReflectionResolver.resolveType(params[i], this.getParameterGenerics(i)));
        }
        this.setParameters(parameters, false, false);
    }

    protected Class<?>[] getParameterGenerics(int index) {
        return null;
    }

    @Override
    protected void initializeReturnType() {
        this.setReturnType((TypeDescriptor<?>)this.getDeclaringType());
    }

    @Override
    protected String getDeclaringTypeNameFallback() {
        return this.constructor.getDeclaringClass().getName();
    }

    @Override
    public String getJavaSignature() {
        return SignatureUtils.getJavaSignature("<init>", this.constructor.getParameterTypes(), null, false);
    }

    @Override
    public IMetaOperation.CompatibilityResult isCompatible(Class<?> retType, Object ... params) {
        boolean compatible;
        Class<?>[] par = this.constructor.getParameterTypes();
        boolean cannotEvaluate = true;
        boolean bl = compatible = (null == params ? 0 : params.length) == par.length;
        if (null != retType) {
            compatible &= this.constructor.getDeclaringClass().isAssignableFrom(retType);
        }
        for (int p = 0; p < par.length; ++p) {
            boolean parCompatible;
            Class<?> cls = null != params[p] ? (params[p] instanceof Class ? (Class<?>)params[p] : params[p].getClass()) : Void.TYPE;
            boolean bl2 = parCompatible = par[p].isAssignableFrom(cls) || par[p] == Class.class && params[p] instanceof Class;
            if (!parCompatible) {
                cannotEvaluate &= params[p] == null;
            }
            compatible &= parCompatible;
        }
        IMetaOperation.CompatibilityResult result = compatible ? IMetaOperation.CompatibilityResult.COMPATIBLE : (cannotEvaluate ? IMetaOperation.CompatibilityResult.ARG_EVALUATION_FAILED : IMetaOperation.CompatibilityResult.INCOMPATIBLE);
        return result;
    }

    @Override
    public Object invoke(Object ... args) throws VilException {
        try {
            this.convertVariables(args);
            return this.constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new VilException(this.composeExceptionMessage(e, args), 50502);
        }
        catch (IllegalAccessException e) {
            throw new VilException(this.composeExceptionMessage(e, args), 50502);
        }
        catch (IllegalArgumentException e) {
            throw new VilException(this.composeExceptionMessage(e, args), 50502);
        }
        catch (InvocationTargetException e) {
            throw new VilException(this.composeExceptionMessage(e, args), 50502);
        }
    }

    @Override
    public int useGenericParameterAsReturn() {
        return -1;
    }

    @Override
    public int useParameterAsReturn() {
        return -1;
    }

    @Override
    public boolean storeArtifactsBeforeExecution() {
        return false;
    }

    @Override
    public void forceInitialization() {
        this.initializeParameters();
    }

    protected Constructor<?> getConstructor() {
        return this.constructor;
    }
}

