/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualTypeProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.ILazyDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.ParameterMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionConstructorDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionOperationParameter;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.SignatureUtils;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeHelper;
import net.ssehub.easy.varModel.model.values.NullValue;

public class ReflectionOperationDescriptor
extends OperationDescriptor
implements ILazyDescriptor {
    private static final Map<Class<?>, Class<?>> REFLECTION_EQUALITIES = new HashMap();
    private Method method;
    private int returnGenericParameterIndex = -1;
    private int returnParameterIndex = -1;
    private boolean storeArtifactsBeforeExecution = false;
    private boolean trace = true;
    private Map<String, ReflectionOperationParameter> namedParams;
    private ReflectionOperationParameter[] namedParamsSeq;

    public ReflectionOperationDescriptor(TypeDescriptor<?> declaringType, Method method, boolean isConstructor) {
        this(declaringType, method, null, isConstructor);
    }

    public ReflectionOperationDescriptor(TypeDescriptor<?> declaringType, Method method, String name, boolean isConstructor) {
        super(declaringType, name, isConstructor);
        OperationMeta meta;
        this.method = method;
        OperationDescriptor.AliasType aliasType = this.getAliasType();
        OperationType opType = this.getOperationType();
        String opName = null;
        if (null != name && !name.equals(method.getName()) && name.length() > 0) {
            opName = name;
            aliasType = OperationDescriptor.AliasType.IMPLICIT;
        }
        if (null != (meta = method.getAnnotation(OperationMeta.class))) {
            opType = meta.opType();
            this.trace = meta.trace();
            if (null != meta.name() && meta.name().length > 0) {
                aliasType = OperationDescriptor.AliasType.EXPLICIT;
            }
            this.returnGenericParameterIndex = meta.useGenericParameter();
            this.returnParameterIndex = meta.useParameter();
            this.storeArtifactsBeforeExecution = meta.storeArtifactsBefore();
        }
        boolean isConversion = null != method.getAnnotation(Conversion.class);
        this.setCharacteristics(opType, aliasType, isConversion, opName);
    }

    private static final void addReflectionEquality(Class<?> cls1, Class<?> cls2) {
        REFLECTION_EQUALITIES.put(cls1, cls2);
        REFLECTION_EQUALITIES.put(cls2, cls1);
    }

    @Override
    public void forceInitialization() {
        this.initializeParameters();
        this.initializeReturnType();
    }

    protected boolean considerNamedParameters() {
        return true;
    }

    @Override
    protected void initializeParameters() {
        Instantiator inst;
        boolean acceptsNamedParameters = false;
        boolean acceptsImplicitParameters = false;
        ArrayList parameter = new ArrayList();
        IMetaType declaringType = this.getDeclaringType();
        if (!Modifier.isStatic(this.method.getModifiers()) && null != declaringType) {
            parameter.add((TypeDescriptor<?>)declaringType);
        }
        boolean considerNamed = this.considerNamedParameters();
        Class<?>[] params = this.method.getParameterTypes();
        OperationMeta meta = this.method.getAnnotation(OperationMeta.class);
        int[] argGenericIndex = null == meta ? null : meta.genericArgument();
        IMetaType declaring = this.getDeclaringType();
        Annotation[][] paramsAnnotations = this.method.getParameterAnnotations();
        Map<String, Object> defltValues = null;
        for (int i = 0; i < params.length; ++i) {
            int genIndex;
            if (considerNamed && i == params.length - 1 && Map.class.isAssignableFrom(params[i])) {
                acceptsNamedParameters = true;
                continue;
            }
            TypeDescriptor<?> type = ReflectionResolver.resolveType(params[i], this.getParameterGenerics(i));
            if (null != argGenericIndex && i < argGenericIndex.length && (genIndex = argGenericIndex[i]) >= 0 && genIndex < ((TypeDescriptor)declaring).getGenericParameterCount()) {
                type = ((TypeDescriptor)declaring).getGenericParameterType(genIndex);
            }
            parameter.add(type);
            defltValues = this.checkForNamedParameter(type, i, paramsAnnotations, defltValues, params.length);
        }
        if (acceptsNamedParameters && (inst = this.method.getDeclaringClass().getAnnotation(Instantiator.class)) != null) {
            acceptsImplicitParameters = inst.acceptsImplicitParameters();
        }
        this.setParameters(parameter, acceptsNamedParameters, acceptsImplicitParameters);
    }

    private Map<String, Object> getDefaultValues() {
        HashMap<String, Object> result = null;
        Object tmp = null;
        Field[] fields = this.method.getDeclaringClass().getDeclaredFields();
        for (int f = 0; f < fields.length; ++f) {
            Field field = fields[f];
            DefaultValue defaultValue = field.getAnnotation(DefaultValue.class);
            if (defaultValue == null || !Modifier.isStatic(field.getModifiers()) || !defaultValue.name().equals(this.method.getName()) && (null != tmp || 0 != defaultValue.name().length())) continue;
            field.setAccessible(true);
            try {
                tmp = field.get(null);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (tmp instanceof Map) {
            Map tmpMap = (Map)tmp;
            result = new HashMap<String, Object>();
            for (Map.Entry entry : tmpMap.entrySet()) {
                result.put(entry.getKey().toString(), entry.getValue());
            }
        }
        if (null != tmp && tmp.getClass().isArray()) {
            result = new HashMap();
            int e = 0;
            int size = Array.getLength(tmp);
            while (e < size) {
                Object object = Array.get(tmp, e++);
                if (e >= size) continue;
                Object value = Array.get(tmp, e++);
                result.put(object.toString(), value);
            }
        }
        return result;
    }

    private Map<String, Object> checkForNamedParameter(TypeDescriptor<?> type, int index, Annotation[][] annotations, Map<String, Object> defltValues, int paramCount) {
        String name;
        ParameterMeta pMeta = TypeHelper.getParameterAnnotation(annotations, index, ParameterMeta.class);
        if (null != pMeta && null != (name = pMeta.name()) && name.length() > 0) {
            Object dfltValue;
            if (null == this.namedParams) {
                this.namedParams = new HashMap<String, ReflectionOperationParameter>();
                this.namedParamsSeq = new ReflectionOperationParameter[paramCount];
            }
            ConstantExpression dflt = null;
            if (null == defltValues) {
                defltValues = this.getDefaultValues();
            }
            if (null != (dfltValue = null != defltValues ? defltValues.get(name) : type.getDefaultValue())) {
                try {
                    dflt = new ConstantExpression(type, dfltValue, this.getDeclaringType().getTypeRegistry());
                }
                catch (VilException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(ReflectionConstructorDescriptor.class, "net.ssehub.easy.instantiation.core").error("Default value for parameter " + name + " of " + this.method.getDeclaringClass().getName() + "/" + this.method + " does not match type " + type.getVilName() + ". Ignoring default value.");
                }
            }
            ReflectionOperationParameter param = new ReflectionOperationParameter(name, type, dflt);
            this.namedParams.put(name, param);
            this.namedParamsSeq[index] = param;
        }
        return defltValues;
    }

    @Override
    public int getRequiredParameterCount() {
        int result = this.getParameterCount();
        if (null != this.namedParams) {
            result -= this.namedParams.size();
        }
        return result;
    }

    @Override
    public IMetaParameterDeclaration getParameter(String name) {
        return null == this.namedParams ? null : (IMetaParameterDeclaration)this.namedParams.get(name);
    }

    @Override
    public IMetaParameterDeclaration getParameter(int index) {
        return null == this.namedParamsSeq ? null : this.namedParamsSeq[index];
    }

    @Override
    public OperationDescriptor specializeFor(TypeDescriptor<?> declaringType) {
        OperationMeta meta;
        ReflectionOperationDescriptor result = this;
        if (declaringType.getGenericParameterCount() > 0 && null != (meta = this.method.getAnnotation(OperationMeta.class)) && null != meta.genericArgument() && meta.genericArgument().length > 0) {
            result = new ReflectionOperationDescriptor(declaringType, this.method, this.isConstructor());
        }
        return result;
    }

    @Override
    protected void initializeReturnType() {
        Class<?> returnType = this.method.getReturnType();
        OperationMeta meta = this.method.getAnnotation(OperationMeta.class);
        if (null != meta && meta.returnType() != Void.TYPE && returnType.isAssignableFrom(meta.returnType())) {
            returnType = meta.returnType();
        }
        this.setReturnType(ReflectionResolver.resolveType(returnType, this.getReturnGenerics()));
    }

    @Override
    public Object invoke(Object ... args) throws VilException {
        Object[] callArgs;
        Object object;
        boolean exec = true;
        if (this.isStatic()) {
            object = null;
            callArgs = args;
        } else {
            if (0 == args.length) {
                throw new VilException("object missing (first implicit parameter)", 40005);
            }
            object = args[0];
            callArgs = new Object[args.length - 1];
            Class<?>[] paramTypes = this.method.getParameterTypes();
            for (int i = 0; i < callArgs.length; ++i) {
                Object arg = args[i + 1];
                callArgs[i] = arg instanceof TypeDescriptor && paramTypes[i] == Class.class ? ((TypeDescriptor)arg).getTypeClass() : (arg instanceof IActualTypeProvider && paramTypes[i] == TypeDescriptor.class ? ((IActualTypeProvider)arg).getType() : args[i + 1]);
            }
            exec = null != object;
        }
        Object result = null;
        if (!exec) {
            result = null;
        } else {
            IMetaOperation.CompatibilityResult comp = this.isCompatible(null, callArgs);
            if (IMetaOperation.CompatibilityResult.INCOMPATIBLE == comp) {
                result = this.tryEvaluateEquality(args, callArgs);
            } else if (IMetaOperation.CompatibilityResult.ARG_EVALUATION_FAILED == comp) {
                result = null;
            } else {
                try {
                    result = this.method.invoke(object, callArgs);
                    if (null == result && Void.TYPE == this.method.getReturnType()) {
                        result = NullValue.VALUE;
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new VilException(this.composeExceptionMessage(e, args), 40002);
                }
                catch (IllegalAccessException e) {
                    throw new VilException(this.composeExceptionMessage(e, args), 40006);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof NullPointerException) {
                        result = null;
                    }
                    throw new VilException(this.composeExceptionMessage(e.getCause(), args), e.getCause(), 40005);
                }
            }
        }
        return result;
    }

    private static Object nullify(Object value) {
        Object result = value instanceof NullValue.NullValueType ? null : value;
        return result;
    }

    private Object tryEvaluateEquality(Object[] args, Object[] callArgs) throws VilException {
        Boolean result = null;
        if (callArgs.length == 2 && OperationType.INFIX == this.getOperationType()) {
            Object arg0 = ReflectionOperationDescriptor.nullify(callArgs[0]);
            Object arg1 = ReflectionOperationDescriptor.nullify(callArgs[1]);
            String name = this.getName();
            if ("!=".equals(name) || "<>".equals(name)) {
                result = null == arg0 ? Boolean.valueOf(arg1 != null) : Boolean.valueOf(!arg0.equals(arg1));
            } else if ("==".equals(name)) {
                result = null == arg0 ? Boolean.valueOf(arg1 == null) : Boolean.valueOf(arg0.equals(arg1));
            } else {
                this.throwIncompatibleParameter(args);
            }
        }
        return result;
    }

    @Override
    public IMetaOperation.CompatibilityResult isCompatible(Class<?> retType, Object ... params) {
        boolean compatible;
        Class<?>[] par = this.method.getParameterTypes();
        boolean cannotEvaluate = true;
        boolean bl = compatible = (null == params ? 0 : params.length) == par.length;
        if (null != retType) {
            compatible &= this.method.getReturnType().isAssignableFrom(retType);
        }
        for (int p = 0; p < par.length; ++p) {
            boolean parCompatible;
            Class<?> cls = null != params[p] ? (params[p] instanceof Class ? (Class<?>)params[p] : params[p].getClass()) : Void.TYPE;
            boolean bl2 = parCompatible = par[p].isAssignableFrom(cls) || REFLECTION_EQUALITIES.get(par[p]) == cls || par[p] == Class.class && params[p] instanceof Class;
            if (!parCompatible) {
                cannotEvaluate &= params[p] == null;
            }
            compatible &= parCompatible;
        }
        IMetaOperation.CompatibilityResult result = compatible ? IMetaOperation.CompatibilityResult.COMPATIBLE : (cannotEvaluate ? IMetaOperation.CompatibilityResult.ARG_EVALUATION_FAILED : IMetaOperation.CompatibilityResult.INCOMPATIBLE);
        return result;
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public boolean isFirstParameterOperand() {
        return !this.isStatic();
    }

    @Override
    public String getJavaSignature() {
        return SignatureUtils.getJavaSignature(this.method, this.getStoredName(), this.acceptsNamedParameters());
    }

    @Override
    public String getSignature() {
        StringBuilder tmp = new StringBuilder();
        if (this.isConstructor()) {
            tmp.append("new ");
            tmp.append(this.getDeclaringTypeName());
            tmp.append(" ");
        } else {
            tmp.append(this.getName());
        }
        tmp.append("(");
        int pCount = this.getParameterCount();
        for (int p = 0; p < pCount; ++p) {
            IMetaType pType = this.getParameterType(p);
            tmp.append(((TypeDescriptor)pType).getVilName());
            if (p >= pCount - 1) continue;
            tmp.append(",");
        }
        tmp.append(")");
        return tmp.toString();
    }

    @Override
    protected String getDeclaringTypeNameFallback() {
        return this.method.getDeclaringClass().getSimpleName();
    }

    protected Method getMethod() {
        return this.method;
    }

    @Override
    public String getName() {
        String tmp = this.getStoredName();
        return null != tmp ? tmp : this.method.getName();
    }

    protected Class<?>[] getParameterGenerics(int index) {
        Class<?>[] result = null;
        ParameterMeta pMeta = TypeHelper.getParameterAnnotation(this.method.getParameterAnnotations(), index, ParameterMeta.class);
        if (null != pMeta) {
            result = pMeta.generics();
        }
        return result;
    }

    protected Class<?>[] getReturnGenerics() {
        Class<?>[] result = null;
        OperationMeta opMeta = this.method.getAnnotation(OperationMeta.class);
        if (null != opMeta) {
            result = opMeta.returnGenerics();
        }
        return result;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public int useGenericParameterAsReturn() {
        return this.returnGenericParameterIndex;
    }

    @Override
    public int useParameterAsReturn() {
        return this.returnParameterIndex;
    }

    @Override
    public boolean storeArtifactsBeforeExecution() {
        return this.storeArtifactsBeforeExecution;
    }

    @Override
    public boolean requiresDynamicExpressionProcessing() {
        OperationMeta annotation = this.method.getAnnotation(OperationMeta.class);
        boolean result = null != annotation ? annotation.requiresDynamicExpressionProcessing() : false;
        return result;
    }

    @Override
    public boolean trace() {
        return this.trace && super.trace();
    }

    @Override
    public boolean allowsAggregation() {
        boolean result = false;
        OperationMeta opMeta = this.method.getAnnotation(OperationMeta.class);
        if (null != opMeta) {
            result = opMeta.allowsAggregation();
        }
        return result;
    }

    @Override
    public boolean isOclCompliant() {
        boolean compliant = true;
        OperationMeta meta = this.method.getAnnotation(OperationMeta.class);
        if (null != meta) {
            String name = this.getName();
            String[] not = meta.notOclCompliant();
            for (int i = 0; compliant && i < not.length; ++i) {
                compliant = !name.equals(not[i]);
            }
        }
        return compliant;
    }

    @Override
    public boolean useAny() {
        boolean result = false;
        OperationMeta meta = this.method.getAnnotation(OperationMeta.class);
        if (null != meta) {
            result = meta.useAny();
        }
        return result;
    }

    @Override
    public boolean flatten() {
        boolean result = false;
        OperationMeta meta = this.method.getAnnotation(OperationMeta.class);
        if (null != meta) {
            result = meta.flatten();
        }
        return result;
    }

    @Override
    public boolean useOperandTypeAsParameter() {
        boolean result = false;
        OperationMeta meta = this.method.getAnnotation(OperationMeta.class);
        if (null != meta) {
            result = meta.useOperandTypeAsParameter();
        }
        return result;
    }

    static {
        ReflectionOperationDescriptor.addReflectionEquality(Integer.TYPE, Integer.class);
        ReflectionOperationDescriptor.addReflectionEquality(Long.TYPE, Long.class);
        ReflectionOperationDescriptor.addReflectionEquality(Float.TYPE, Float.class);
        ReflectionOperationDescriptor.addReflectionEquality(Double.TYPE, Double.class);
        ReflectionOperationDescriptor.addReflectionEquality(Boolean.TYPE, Boolean.class);
        ReflectionOperationDescriptor.addReflectionEquality(Character.TYPE, Character.class);
        ReflectionOperationDescriptor.addReflectionEquality(Byte.TYPE, Byte.class);
        ReflectionOperationDescriptor.addReflectionEquality(Short.TYPE, Short.class);
    }
}

