/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.AliasTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ClassMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualTypeAssignmentProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoAny;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoIterator;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoType;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoVersion;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoVoid;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionFieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ResolvableOperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SignatureUtils;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ReflectionTypeDescriptor<T>
extends TypeDescriptor<T> {
    public static final TypeDescriptor<PseudoVoid> VOID;
    public static final String NAME_VOID = "VOID";
    public static final TypeDescriptor<PseudoType> TYPE;
    public static final String NAME_TYPE = "Type";
    public static final TypeDescriptor<PseudoAny> ANY;
    public static final String NAME_ANY = "ANY";
    public static final TypeDescriptor<PseudoVersion> VERSION;
    public static final String NAME_VERSION = "Version";
    private static final EASyLoggerFactory.EASyLogger LOGGER;
    public static final TypeDescriptor<?>[] PSEUDO_TYPES;
    private Class<T> cls;
    private boolean canBeInstantiated = false;
    private IMetaType superType;
    private Object defltValue;
    private Class<?>[] nAssign;

    protected ReflectionTypeDescriptor(Class<T> cls) throws VilException {
        this(cls, (TypeDescriptor[])null);
    }

    ReflectionTypeDescriptor(Class<T> cls, TypeDescriptor<?> ... parameter) throws VilException {
        super(parameter);
        this.cls = cls;
    }

    protected ReflectionTypeDescriptor<T> resolve() throws VilException {
        if (!this.isInitialized()) {
            this.resolveFields();
            this.processInner(this.cls);
            ClassMeta meta = this.cls.getAnnotation(ClassMeta.class);
            Instantiator inst = this.cls.getAnnotation(Instantiator.class);
            this.setName(ReflectionTypeDescriptor.getAlias(meta));
            Class<?> further = null;
            if (null != meta) {
                this.nAssign = meta.nAssign();
                further = meta.furtherOperations();
            }
            HashMap<String, OperationDescriptor> tmp = new HashMap<String, OperationDescriptor>();
            ArrayList<OperationDescriptor> convs = new ArrayList<OperationDescriptor>();
            this.addMethods(tmp, this.cls, this.cls, null != inst ? inst.value() : null);
            this.addConversions(this.cls, convs);
            if (null != further && Object.class != further) {
                this.addMethods(tmp, further, further, null != inst ? inst.value() : null);
                this.addConversions(further, convs);
            }
            this.setOperations(tmp.values());
            this.setConversions(convs);
            this.superType = this.getTypeRegistry().findType(this.cls.getSuperclass());
            if (this.superType == this) {
                LOGGER.error("TypeDescriptor " + this.getName() + " has same type as super descriptor. This leads to a direct inheritance cycle. Please fix the names!");
            }
        }
        return this;
    }

    protected void resolveFields() {
        Class<T> cls = this.getTypeClass();
        Field[] fields = cls.getFields();
        ArrayList<ReflectionFieldDescriptor> fd = null;
        for (int f = 0; f < fields.length; ++f) {
            Field field = fields[f];
            if (cls.isEnum()) {
                String name = field.getName();
                if (null == fd) {
                    fd = new ArrayList<ReflectionFieldDescriptor>();
                }
                fd.add(new ReflectionFieldDescriptor(this, fields[f], name, null));
            }
            if (null == field.getAnnotation(DefaultValue.class) || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                this.defltValue = field.get(null);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (null != fd) {
            this.setFields(fd);
        }
    }

    protected void processInner(Class<?> cls) throws VilException {
    }

    private void addConversions(Class<?> cls, List<OperationDescriptor> convs) {
        Method[] methods = cls.getDeclaredMethods();
        if (null != methods) {
            for (int m = 0; m < methods.length; ++m) {
                Method method = methods[m];
                int mod = method.getModifiers();
                Conversion conv = method.getAnnotation(Conversion.class);
                if (null == conv || Modifier.isAbstract(mod) || !Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
                if (Void.TYPE == method.getReturnType()) {
                    LOGGER.warn("conversion operations must return a value (" + method + "). Ignored.");
                    continue;
                }
                Class<?>[] param = method.getParameterTypes();
                if (1 == param.length) {
                    convs.add(new ReflectionOperationDescriptor(this, method, this.considerAsConstructor(method)));
                    continue;
                }
                LOGGER.warn("conversion operations must have exactly one parameter (" + method + "). Ignored.");
            }
        }
    }

    private void addOperation(java.util.Map<String, OperationDescriptor> operations, String sig, OperationDescriptor desc) {
        operations.put(sig, desc);
        this.canBeInstantiated |= desc.isConstructor();
    }

    private void addMethods(java.util.Map<String, OperationDescriptor> operations, Class<?> cls, Class<?> start, String instantiatorName) {
        if (Object.class != cls) {
            Class<?>[] ifaces;
            Class<?> superCls;
            TypeDescriptor<?> tDesc = this.getTypeRegistry().getType(ReflectionTypeDescriptor.getRegName(cls));
            if (null != tDesc && tDesc != this) {
                int count = tDesc.getOperationsCount();
                for (int o = 0; o < count; ++o) {
                    String sig;
                    OperationDescriptor op = tDesc.getOperation(o);
                    if (op.isConstructor() && (!op.isConstructor() || cls != start) || operations.containsKey(sig = op.getJavaSignature())) continue;
                    this.addOperation(operations, sig, tDesc.getOperation(o).specializeFor(this));
                }
            } else {
                Method[] methods = cls.getDeclaredMethods();
                for (int m = 0; m < methods.length; ++m) {
                    Method method = methods[m];
                    if (!this.enableMethod(method)) continue;
                    this.addMethod(operations, method, instantiatorName);
                }
            }
            if (null != (superCls = cls.getSuperclass())) {
                this.addMethods(operations, superCls, start, instantiatorName);
            }
            if (null != (ifaces = cls.getInterfaces())) {
                for (int i = 0; i < ifaces.length; ++i) {
                    this.addMethods(operations, ifaces[i], start, instantiatorName);
                }
            }
        }
    }

    protected boolean enableMethod(Method method) {
        return true;
    }

    protected boolean considerAsConstructor(Method method) {
        return OperationDescriptor.isConstructor(method);
    }

    private void addMethod(java.util.Map<String, OperationDescriptor> operations, Method method, String instantiatorName) {
        if (Modifier.isPublic(method.getModifiers())) {
            Invisible invAnnotation = method.getAnnotation(Invisible.class);
            String sig = SignatureUtils.getJavaSignature(method);
            if (null == invAnnotation && !TypeRegistry.hasInheritedInvisibleAnnotation(sig, method.getDeclaringClass()) && ReflectionTypeDescriptor.filterMethodByName(method, instantiatorName) && !operations.containsKey(sig) && OperationDescriptor.isOperationOrConstructor(method) && this.registerAliasOperation(operations, method)) {
                this.addOperation(operations, sig, this.createDescriptor(method, null, this.considerAsConstructor(method)));
            }
        }
    }

    protected ReflectionOperationDescriptor createDescriptor(Method method, String name, boolean constructor) {
        String tmp = name;
        if (null == tmp) {
            tmp = method.getName();
        }
        return new ReflectionOperationDescriptor(this, method, tmp, this.considerAsConstructor(method));
    }

    private static boolean filterMethodByName(Method method, String instantiatorName) {
        boolean result = false;
        result = null == instantiatorName ? true : instantiatorName.equals(method.getName()) || OperationDescriptor.isConstructor(method);
        return result;
    }

    private boolean registerAliasOperation(java.util.Map<String, OperationDescriptor> operations, Method method) {
        boolean regOriginal = true;
        OperationMeta meta = method.getAnnotation(OperationMeta.class);
        if (null != meta) {
            String[] names = meta.name();
            if (null != names) {
                for (int n = 0; n < names.length; ++n) {
                    ReflectionOperationDescriptor desc = this.createDescriptor(method, names[n], this.considerAsConstructor(method));
                    this.addOperation(operations, ((OperationDescriptor)desc).getJavaSignature(), desc);
                }
                regOriginal = names.length == 0;
            }
        } else {
            String name = ReflectionTypeDescriptor.stripGetterPrefix(method.getName());
            if (null != name) {
                ReflectionOperationDescriptor desc = this.createDescriptor(method, name, this.considerAsConstructor(method));
                this.addOperation(operations, ((OperationDescriptor)desc).getJavaSignature(), desc);
            }
        }
        return regOriginal;
    }

    public static String stripGetterPrefix(String name) {
        if (name.startsWith("get") && name.length() > 3) {
            if (Character.isUpperCase((name = name.substring(3)).charAt(0))) {
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
        } else {
            name = null;
        }
        return name;
    }

    public static String getRegName(Class<?> cls) {
        String name = ReflectionTypeDescriptor.getAlias(cls);
        if (null == name) {
            name = cls.getSimpleName();
        }
        return name;
    }

    public static String getAlias(Class<?> cls) {
        return ReflectionTypeDescriptor.getAlias(cls.getAnnotation(ClassMeta.class));
    }

    private static String getAlias(ClassMeta meta) {
        String name = null;
        if (null != meta && null != meta.name() && meta.name().length() > 0) {
            name = meta.name();
        }
        return name;
    }

    @Override
    public String getName() {
        String tmp = super.getName();
        return null == tmp ? this.cls.getSimpleName() : tmp;
    }

    @Override
    public String getQualifiedName() {
        String tmp = super.getQualifiedName();
        return null == tmp ? this.getName() : tmp;
    }

    @Override
    public boolean canBeInstantiated() {
        return this.canBeInstantiated;
    }

    @Override
    public T create(Object ... params) throws VilException {
        boolean found = false;
        T result = null;
        int oCount = this.getOperationsCount();
        for (int o = 0; !found && o < oCount; ++o) {
            OperationDescriptor op = this.getOperation(o);
            if (!op.isConstructor() || IMetaOperation.CompatibilityResult.COMPATIBLE != op.isCompatible(this.getTypeClass(), params)) continue;
            found = true;
            Object res = op.invoke(params);
            if (null == res) {
                throw new VilException("VIL constructor does not return a result", 40004);
            }
            try {
                result = this.getTypeClass().cast(res);
                continue;
            }
            catch (ClassCastException e) {
                throw new VilException("VIL constructor returns wrong result type", 40002);
            }
        }
        if (!found) {
            throw new VilException("VIL constructor not found", 40003);
        }
        return result;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.cls;
    }

    private boolean isNAssign(Class<?> cls) {
        boolean found = false;
        if (null != this.nAssign) {
            for (int n = 0; !found && n < this.nAssign.length; ++n) {
                found = cls == this.nAssign[n];
            }
        }
        return found;
    }

    @Override
    public boolean isAssignableFrom(IMetaType type) {
        boolean assignable = false;
        if (ReflectionTypeDescriptor.class.isInstance(type = AliasTypeDescriptor.unalias(type))) {
            assignable = this.isAssignableFrom((TypeDescriptor)ReflectionTypeDescriptor.class.cast(type));
        } else if (type instanceof IActualTypeAssignmentProvider) {
            assignable = ((IActualTypeAssignmentProvider)((Object)type)).isAssignableFrom(this, type);
        }
        return assignable;
    }

    @Override
    public boolean isAssignableFrom(TypeDescriptor<?> desc) {
        boolean assignable;
        if ((desc = AliasTypeDescriptor.unalias(desc)) instanceof ReflectionTypeDescriptor) {
            ReflectionTypeDescriptor rDesc = (ReflectionTypeDescriptor)desc;
            Class<T> descC = rDesc.getTypeClass();
            boolean bl = assignable = !this.isNAssign(descC) && !rDesc.isNAssign(this.cls);
            if (assignable) {
                boolean bl2 = assignable = this.cls.isAssignableFrom(descC) || desc == ANY;
                if (assignable && this.getGenericParameterCount() > 0) {
                    assignable = this.getGenericParameterCount() == desc.getGenericParameterCount();
                    for (int p = 0; assignable && p < this.getGenericParameterCount(); ++p) {
                        if (null == this.getGenericParameterType(p)) continue;
                        assignable = this.getGenericParameterType(p).isAssignableFrom(desc.getGenericParameterType(p));
                    }
                }
            }
        } else {
            assignable = false;
        }
        return assignable;
    }

    @Override
    public String toString() {
        return this.getName() + " representing " + this.cls.getName();
    }

    @Override
    public String getVilName() {
        String result;
        if (Set.class.isAssignableFrom(this.cls)) {
            result = this.appendParameter("setOf", 0);
        } else if (Sequence.class.isAssignableFrom(this.cls)) {
            result = this.appendParameter("sequenceOf", 0);
        } else if (Map.class.isAssignableFrom(this.cls)) {
            result = this.appendParameter("mapOf", 0);
        } else if (ResolvableOperationType.class.isAssignableFrom(this.cls)) {
            result = "callOf";
            TypeDescriptor<?> ret = this.getGenericParameterType(this.getGenericParameterCount() - 1);
            if (VOID != ret) {
                result = result + " " + ret.getVilName() + " ";
            }
            result = result + this.appendParameter("", 1);
        } else {
            result = this.getGenericParameterCount() > 0 ? this.appendParameter(this.getName(), 0) : this.getName();
        }
        return result;
    }

    static boolean isCollection(Class<?> cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    static boolean isSet(Class<?> cls) {
        return Set.class.isAssignableFrom(cls);
    }

    static boolean isIterator(Class<?> cls) {
        return Iterator.class.isAssignableFrom(cls);
    }

    static boolean isSequence(Class<?> cls) {
        return Sequence.class.isAssignableFrom(cls);
    }

    static boolean isMap(Class<?> cls) {
        return Map.class.isAssignableFrom(cls);
    }

    @Override
    public boolean isCollection() {
        return this.isSet() || this.isSequence() || ReflectionTypeDescriptor.isCollection(this.cls);
    }

    @Override
    public boolean isIterator() {
        return ReflectionTypeDescriptor.isIterator(this.cls) || PseudoIterator.class.isAssignableFrom(this.cls);
    }

    @Override
    public boolean isMap() {
        return ReflectionTypeDescriptor.isMap(this.cls);
    }

    @Override
    public boolean isSet() {
        return ReflectionTypeDescriptor.isSet(this.cls);
    }

    @Override
    public boolean isSequence() {
        return ReflectionTypeDescriptor.isSequence(this.cls);
    }

    @Override
    public boolean isInstance(Object object) {
        ClassMeta meta;
        boolean ok = this.cls.isInstance(object);
        if (!ok && null != (meta = this.cls.getAnnotation(ClassMeta.class)) && null != meta.equiv()) {
            Class<?>[] equiv = meta.equiv();
            for (int e = 0; !ok && e < equiv.length; ++e) {
                ok = equiv[e].isInstance(object);
            }
        }
        return ok;
    }

    @Override
    public boolean isSameType(Object object) {
        boolean ok;
        if (null == object) {
            ok = false;
        } else {
            ClassMeta meta;
            Class<?> resClass = object.getClass();
            boolean bl = ok = resClass == this.cls;
            if (!ok && null != (meta = this.cls.getAnnotation(ClassMeta.class)) && null != meta.equiv()) {
                Class<?>[] equiv = meta.equiv();
                for (int e = 0; !ok && e < equiv.length; ++e) {
                    ok = resClass == equiv[e];
                }
            }
        }
        return ok;
    }

    @Override
    public boolean isBasicType() {
        return TypeHelper.isBasicType(this.cls);
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return TypeRegistry.DEFAULT;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public OperationDescriptor addPlaceholderOperation(String name, int parameterCount, boolean acceptsNamedParameters) {
        return null;
    }

    @Override
    public boolean isActualTypeOf(IMetaType type) {
        return false;
    }

    @Override
    public IMetaType getBaseType() {
        return null;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isInstantiator() {
        return null != this.cls.getAnnotation(Instantiator.class);
    }

    @Override
    public IMetaType getSuperType() {
        return this.superType;
    }

    @Override
    public boolean checkConversion(IMetaType param, IMetaOperation conversion) {
        return true;
    }

    @Override
    public Object getDefaultValue() {
        return this.defltValue;
    }

    static {
        LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ReflectionOperationDescriptor.class, "net.ssehub.easy.instantiation.core");
        ReflectionTypeDescriptor<PseudoVoid> v = null;
        ReflectionTypeDescriptor<PseudoType> t = null;
        ReflectionTypeDescriptor<PseudoAny> a = null;
        ReflectionTypeDescriptor<PseudoVersion> r = null;
        try {
            v = new ReflectionTypeDescriptor<PseudoVoid>(PseudoVoid.class){
                {
                    this.setName(ReflectionTypeDescriptor.NAME_VOID);
                }

                @Override
                public boolean canBeInstantiated() {
                    return false;
                }
            };
            v.resolve();
        }
        catch (VilException e) {
            LOGGER.exception(e);
        }
        try {
            t = new ReflectionTypeDescriptor<PseudoType>(PseudoType.class){
                {
                    this.setName(ReflectionTypeDescriptor.NAME_TYPE);
                }

                @Override
                public boolean isAssignableFrom(IMetaType type) {
                    return ReflectionTypeDescriptor.class.isAssignableFrom(type.getClass());
                }

                @Override
                public boolean isAssignableFrom(TypeDescriptor<?> desc) {
                    return this.equals(desc);
                }

                @Override
                public boolean canBeInstantiated() {
                    return false;
                }
            };
            t.resolve();
        }
        catch (VilException e) {
            LOGGER.exception(e);
        }
        try {
            a = new ReflectionTypeDescriptor<PseudoAny>(PseudoAny.class){
                {
                    this.setName(ReflectionTypeDescriptor.NAME_ANY);
                }

                @Override
                public boolean isAssignableFrom(IMetaType type) {
                    return ReflectionTypeDescriptor.class.isAssignableFrom(type.getClass());
                }

                @Override
                public boolean isAssignableFrom(TypeDescriptor<?> desc) {
                    return true;
                }

                @Override
                public boolean isInstance(Object object) {
                    return true;
                }

                @Override
                public boolean canBeInstantiated() {
                    return false;
                }
            };
            a.resolve();
        }
        catch (VilException e) {
            LOGGER.exception(e);
        }
        try {
            r = new ReflectionTypeDescriptor<PseudoVersion>(PseudoVersion.class){
                {
                    this.setName(ReflectionTypeDescriptor.NAME_VERSION);
                }

                @Override
                public boolean canBeInstantiated() {
                    return false;
                }
            };
            r.resolve();
        }
        catch (VilException e) {
            LOGGER.exception(e);
        }
        VOID = v;
        TYPE = t;
        ANY = a;
        VERSION = r;
        TypeRegistry.addTypeMapping(TypeDescriptor.class.getSimpleName(), TYPE);
        TypeRegistry.addTypeMapping(NAME_VERSION, VERSION);
        PSEUDO_TYPES = new TypeDescriptor[]{VOID, TYPE, ANY, VERSION};
    }
}

