/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public interface Sequence<T>
extends Collection<T> {
    @DefaultValue
    public static final List<?> DEFAULT = new ArrayList();

    @OperationMeta(name={"[]"})
    public T at(int var1);

    public T get(int var1);

    @Override
    @OperationMeta(returnGenerics={IVilType.class}, returnType=Sequence.class)
    public Sequence<T> selectByType(TypeDescriptor<?> var1);

    @Override
    @OperationMeta(name={"selectByKind", "typeSelect"}, returnGenerics={IVilType.class}, returnType=Sequence.class)
    public Sequence<T> selectByKind(TypeDescriptor<?> var1);

    @Override
    @OperationMeta(returnGenerics={IVilType.class}, returnType=Sequence.class)
    public Sequence<T> typeReject(TypeDescriptor<?> var1);

    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> excluding(Collection<T> var1);

    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> append(Collection<T> var1);

    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> union(Sequence<T> var1);

    @OperationMeta(genericArgument={0})
    public T add(T var1);

    public boolean remove(T var1);

    @Override
    @OperationMeta(useGenericParameter=0, returnType=Sequence.class)
    public Sequence<T> select(ExpressionEvaluator var1) throws VilException;

    @Override
    @OperationMeta(useGenericParameter=0, returnType=Sequence.class)
    public Sequence<T> reject(ExpressionEvaluator var1) throws VilException;

    @Override
    @OperationMeta(useParameter=0, flatten=true, returnType=Set.class)
    public Set<?> closure(ExpressionEvaluator var1) throws VilException;

    @Override
    @OperationMeta(useParameter=0, flatten=true, returnType=Sequence.class)
    public Sequence<?> collect(ExpressionEvaluator var1) throws VilException;

    @Override
    @OperationMeta(useParameter=0x7FFFFFFF, returnType=Sequence.class)
    public Sequence<?> collectNested(ExpressionEvaluator var1) throws VilException;

    public Set<T> toSet();

    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> sortAlpha();

    @Override
    @OperationMeta(name={"sortedBy", "sort"}, notOclCompliant={"sort"}, returnGenerics={IVilType.class})
    public Sequence<T> sortedBy(ExpressionEvaluator var1) throws VilException;

    @OperationMeta(name={"reverse", "revert"}, notOclCompliant={"revert"}, returnGenerics={IVilType.class})
    public Sequence<T> revert();

    public T first();

    public T last();

    public int indexOf(T var1);

    @OperationMeta(returnGenerics={IVilType.class, IVilType.class})
    public Map<T, T> mapSequence(Sequence<T> var1);

    @OperationMeta(returnGenerics={IVilType.class, IVilType.class})
    public Map<T, T> mapAny(Sequence<T> var1);

    @Invisible
    public List<T> toMappedList();

    @Override
    @OperationMeta(useGenericParameter=0, flatten=true, returnType=Sequence.class)
    public Sequence<?> flatten() throws VilException;

    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> append(T var1);

    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> prepend(T var1);

    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> insertAt(int var1, T var2);

    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> subSequence(int var1, int var2);

    public boolean hasDuplicates();

    public boolean overlaps(Sequence<T> var1);

    public boolean isSubsequenceOf(Sequence<T> var1);

    public String joinfields(String var1, String var2, String var3);

    public void removeAll(T var1);

    public T removeAt(int var1);

    public T removeFirst();

    public T removeLast();

    @Override
    @OperationMeta(name={"clone"}, returnType=Sequence.class)
    public Sequence<T> cloneCollection();
}

