/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;
import net.ssehub.easy.varModel.model.values.Value;

public class SequenceOperations {
    public static <T> Map<T, T> mapSequence(Sequence<T> seq1, Sequence<T> seq2) {
        Map result;
        if (null != seq1 && null != seq2 && 1 == seq1.getGenericParameterCount() && 1 == seq2.getGenericParameterCount()) {
            int s1 = 0;
            int s2 = 0;
            boolean reverse = false;
            if (seq1.size() < seq2.size()) {
                Sequence<T> tmp = seq1;
                seq1 = seq2;
                seq2 = tmp;
                reverse = true;
            }
            int count1 = seq1.size();
            int count2 = seq2.size();
            TypeDescriptor<?>[] params = TypeDescriptor.createArray(2);
            params[0] = seq1.getGenericParameterType(0);
            params[1] = seq2.getGenericParameterType(0);
            result = new Map(params, Math.max(count1, count2));
            while (s1 < count1 && s2 < count2) {
                T elt1 = seq1.get(s1);
                T elt2 = seq2.get(s2);
                if (elt1 == null) {
                    if (elt2 == null) {
                        ++s2;
                    }
                    ++s1;
                    continue;
                }
                if (null == elt2) {
                    ++s2;
                    continue;
                }
                if (SequenceOperations.equals(elt1, elt2)) {
                    if (reverse) {
                        result.add(elt1, elt2);
                    } else {
                        result.add(elt2, elt1);
                    }
                    ++s1;
                    ++s2;
                    continue;
                }
                ++s1;
            }
        } else {
            result = null;
        }
        return result;
    }

    private static <T> boolean equals(T elt1, T elt2) {
        boolean equals;
        if (elt1 instanceof DecisionVariable && elt2 instanceof DecisionVariable) {
            Value val1 = ((DecisionVariable)elt1).getDecisionVariable().getValue();
            Value val2 = ((DecisionVariable)elt2).getDecisionVariable().getValue();
            equals = val1.equals(val2);
        } else {
            equals = elt1.equals(elt2);
        }
        return equals;
    }

    public static <T> Map<T, T> mapAny(Sequence<T> seq1, Sequence<T> seq2) {
        Map result;
        if (null != seq1 && null != seq2 && 1 == seq1.getGenericParameterCount() && 1 == seq2.getGenericParameterCount()) {
            TypeDescriptor<?>[] params = TypeDescriptor.createArray(2);
            params[0] = seq1.getGenericParameterType(0);
            params[1] = seq2.getGenericParameterType(0);
            result = new Map(params, Math.max(seq1.size(), seq2.size()));
            for (int s1 = 0; s1 < seq1.size(); ++s1) {
                T elt1 = seq1.get(s1);
                if (elt1 == null) continue;
                for (int s2 = 0; s2 < seq2.size(); ++s2) {
                    T elt2 = seq2.get(s2);
                    if (elt2 == null || !SequenceOperations.equals(elt1, elt2)) continue;
                    result.add(elt1, elt2);
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    private static <T> void addAll(List<T> list, Sequence<T> seq, int lower, int upper) {
        for (int i = lower; i <= upper; ++i) {
            list.add(seq.get(i));
        }
    }

    private static <T> void addAll(List<T> list, Sequence<T> seq) {
        SequenceOperations.addAll(list, seq, 0, seq.size() - 1);
    }

    public static <T> List<T> union(Sequence<T> seq1, Sequence<T> seq2) {
        ArrayList result = new ArrayList(seq1.size() + seq2.size());
        SequenceOperations.addAll(result, seq1);
        SequenceOperations.addAll(result, seq2);
        return result;
    }

    public static <T> List<T> append(Sequence<T> seq, T object) {
        ArrayList<T> result = new ArrayList<T>(seq.size() + 1);
        SequenceOperations.addAll(result, seq);
        result.add(object);
        return result;
    }

    public static <T> List<T> prepend(Sequence<T> seq, T object) {
        ArrayList<T> result = new ArrayList<T>(seq.size() + 1);
        result.add(object);
        SequenceOperations.addAll(result, seq);
        return result;
    }

    public static <T> List<T> insertAt(Sequence<T> seq, int index, T object) {
        ArrayList<T> result = null;
        int i = OclKeyWords.toJavaIndex(index);
        if (0 <= i && i <= seq.size()) {
            result = new ArrayList<T>(seq.size());
            SequenceOperations.addAll(result, seq);
            result.add(i, object);
        }
        return result;
    }

    public static <T> List<T> subSequence(Sequence<T> seq, int lower, int upper) {
        int l = Math.max(0, OclKeyWords.toJavaIndex(lower));
        int u = Math.min(OclKeyWords.toJavaIndex(upper), seq.size() - 1);
        ArrayList result = new ArrayList(u - l + 1);
        SequenceOperations.addAll(result, seq, l, u);
        return result;
    }

    public static <T> boolean hasDuplicates(Sequence<T> seq) {
        boolean hasDuplicates = false;
        int size = seq.size();
        if (size > 0) {
            HashSet known = new HashSet(size);
            Iterator iter = seq.iterator();
            while (!hasDuplicates && iter.hasNext()) {
                hasDuplicates = !known.add(iter.next());
            }
        }
        return hasDuplicates;
    }

    public static <T> boolean overlaps(Sequence<T> s1, Sequence<T> s2) {
        HashSet tmp = new HashSet();
        boolean found = false;
        if (s1.size() > 0 && s2.size() > 0) {
            Iterator iter = s1.iterator();
            while (iter.hasNext()) {
                tmp.add(iter.next());
            }
            iter = s2.iterator();
            while (!found && iter.hasNext()) {
                found = tmp.contains(iter.next());
            }
        }
        return found;
    }

    public static <T> boolean isSubsequenceOf(Sequence<T> s1, Sequence<T> s2) {
        int size1 = s1.size();
        int i1 = 0;
        Iterator iter1 = s1.iterator();
        Iterator iter2 = s2.iterator();
        if (iter1.hasNext() && iter2.hasNext()) {
            Object elt1 = iter1.next();
            Object elt2 = iter2.next();
            while (iter1.hasNext() && iter2.hasNext()) {
                if (elt1.equals(elt2)) {
                    ++i1;
                    elt1 = iter1.next();
                    elt2 = iter2.next();
                    continue;
                }
                elt2 = iter2.next();
            }
            if (elt1.equals(elt2)) {
                ++i1;
            }
        }
        return size1 > 0 && i1 == size1;
    }

    public static <T> String joinfields(Sequence<T> sequence, String separator, String begin, String end) {
        StringBuilder result = new StringBuilder();
        result.append(begin);
        Iterator iter = sequence.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String tmp = StringValueHelper.getStringValue(iter.next(), null);
            if (!first) {
                result.append(separator);
            }
            result.append(tmp);
            first = false;
        }
        result.append(end);
        return result.toString();
    }
}

