/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractCollectionWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SetOperations;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class SetSet<T>
extends AbstractCollectionWrapper<T>
implements Set<T> {
    private java.util.Set<T> set;
    private TypeDescriptor<?>[] params;
    private TypeDescriptor<?> type;

    public SetSet(java.util.Set<T> set, Class<?> param) {
        this(set, param, TypeRegistry.DEFAULT);
    }

    public SetSet(java.util.Set<T> set, Class<?> param, TypeRegistry registry) {
        this(set, registry.convert(param));
    }

    public SetSet(java.util.Set<T> set, TypeDescriptor<?> ... params) {
        this.set = set;
        this.params = params;
        this.type = SetSet.constructType(this.params, true);
    }

    @Override
    public int getGenericParameterCount() {
        return null == this.params ? 0 : this.params.length;
    }

    @Override
    public TypeDescriptor<?> getGenericParameterType(int index) {
        if (null == this.params) {
            throw new IndexOutOfBoundsException();
        }
        return this.params[index];
    }

    @Override
    public int size() {
        return null == this.set ? 0 : this.set.size();
    }

    @Override
    public boolean allowSequenceAdjustment() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return null == this.set ? new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException("empty");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        } : this.set.iterator();
    }

    @Override
    public boolean isEquals(Collection<?> elements) {
        return null == this.set ? null == elements : this.set.equals(elements);
    }

    @Override
    public TypeDescriptor<?> getType() {
        return this.type;
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return StringValueHelper.getStringValue(this, comparator);
    }

    @Override
    public Set<T> excluding(Collection<T> set) {
        HashSet<T> tmp = new HashSet<T>();
        if (null != this.set) {
            tmp.addAll(this.set);
        }
        if (null != set) {
            for (T t : set) {
                tmp.remove(t);
            }
        }
        return new SetSet(tmp, this.params);
    }

    @Override
    public Set<T> including(Collection<T> set) {
        HashSet<T> tmp = new HashSet<T>();
        if (null != this.set) {
            tmp.addAll(this.set);
        }
        if (null != set) {
            for (T t : set) {
                tmp.add(t);
            }
        }
        return new SetSet(tmp, this.params);
    }

    @Override
    public Set<T> union(Set<T> set) {
        return this.including(set);
    }

    @Override
    public Set<T> intersection(Set<T> set) {
        return this.excluding(set);
    }

    @Override
    public T add(T element) {
        T result;
        if (null == this.set) {
            result = null;
        } else {
            this.set.add(element);
            result = element;
        }
        return result;
    }

    @Override
    public boolean remove(T element) {
        return null == this.set ? false : this.set.remove(element);
    }

    @Override
    public Set<T> selectByType(TypeDescriptor<?> type) {
        HashSet tmp = new HashSet();
        if (null != this.set) {
            SetSet.selectByType(this, type, tmp, false, false);
        }
        return new SetSet(tmp, this.params);
    }

    @Override
    public Set<T> selectByKind(TypeDescriptor<?> type) {
        HashSet tmp = new HashSet();
        if (null != this.set) {
            SetSet.selectByType(this, type, tmp, true, false);
        }
        return new SetSet(tmp, this.params);
    }

    @Override
    public Set<T> typeReject(TypeDescriptor<?> type) {
        HashSet tmp = new HashSet();
        if (null != this.set) {
            SetSet.selectByType(this, type, tmp, true, true);
        }
        return new SetSet(tmp, this.params);
    }

    @Override
    public Set<?> flatten() throws VilException {
        HashSet result = new HashSet();
        SetSet.flatten(this, result);
        return new SetSet(result, this.getFlattenedParams(this));
    }

    @Override
    public Set<T> select(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.getIteratorVariable().getType();
        HashSet tmp = new HashSet();
        if (null != this.set) {
            SetSet.select(this, evaluator, tmp, true);
        }
        return new SetSet(tmp, param);
    }

    @Override
    public Set<T> reject(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.getIteratorVariable().getType();
        HashSet tmp = new HashSet();
        if (null != this.set) {
            SetSet.select(this, evaluator, tmp, false);
        }
        return new SetSet(tmp, param);
    }

    @Override
    public Set<?> collect(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        HashSet<Object> tmp = new HashSet<Object>();
        if (null != this.set) {
            SetSet.collect(this, evaluator, tmp, true);
        }
        return new SetSet<Object>(tmp, param);
    }

    @Override
    public Set<?> collectNested(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        HashSet<Object> tmp = new HashSet<Object>();
        if (null != this.set) {
            SetSet.collect(this, evaluator, tmp, false);
        }
        return new SetSet<Object>(tmp, param);
    }

    @Override
    public Set<?> closure(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new SetSet<Object>(SetSet.closure(this, evaluator), param);
    }

    @Override
    public Object apply(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.apply(this, evaluator);
    }

    @Override
    public Sequence<T> toSequence() {
        return this.asSequence();
    }

    @Override
    public Sequence<T> asSequence() {
        ArrayList<T> tmp = new ArrayList<T>(this.set.size());
        tmp.addAll(this.set);
        return new ListSequence(tmp, this.params);
    }

    @Override
    public Set<T> asSet() {
        return this;
    }

    @Override
    public T projectSingle() {
        return 1 == this.size() ? (T)this.set.iterator().next() : null;
    }

    @Override
    @Invisible
    public java.util.Set<T> toMappedSet() {
        HashSet<T> result;
        if (null == this.set) {
            result = null;
        } else {
            result = new HashSet<T>(this.set.size());
            result.addAll(this.set);
        }
        return result;
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    @OperationMeta(name={"sortedBy", "sort"}, notOclCompliant={"sort"}, returnGenerics={IVilType.class})
    public Collection<T> sortedBy(ExpressionEvaluator evaluator) throws VilException {
        AbstractCollectionWrapper result = null == this.set ? this : new ListSequence(this.sortImpl(evaluator), this.params);
        return result;
    }

    @Override
    public Set<T> difference(Set<T> set) {
        return new SetSet<T>(SetOperations.difference(this, set), this.params);
    }

    @Override
    public Set<T> symmetricDifference(Set<T> set) {
        return new SetSet<T>(SetOperations.symmetricDifference(this, set), this.params);
    }

    @Override
    public Set<T> cloneCollection() {
        return new SetSet<T>(new HashSet<T>(this.set), this.params);
    }
}

