/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArrayIterable;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public abstract class TypeDescriptor<T>
implements IMetaType {
    public static final TypeDescriptor<?>[] EMPTY = null;
    private String name;
    private String qualifiedName;
    private OperationDescriptor[] operations;
    private FieldDescriptor[] fields;
    private OperationDescriptor[] conversions;
    private TypeDescriptor<?>[] parameter;

    protected TypeDescriptor(TypeDescriptor<?> ... parameter) throws VilException {
        this.parameter = parameter;
    }

    protected boolean isInitialized() {
        return null != this.operations;
    }

    protected void setName(String name) {
        if (null == name) {
            this.name = null;
            this.qualifiedName = null;
        } else {
            int pos = name.lastIndexOf("::");
            if (pos > 0 && pos < name.length() - 2) {
                this.name = name.substring(pos + 2);
                this.qualifiedName = name;
            } else {
                this.name = name;
                this.qualifiedName = name;
            }
        }
    }

    protected boolean isNameSet() {
        return null != this.qualifiedName || null != this.name;
    }

    protected void setOperations(java.util.Collection<OperationDescriptor> operations) {
        if (null == operations) {
            this.operations = new OperationDescriptor[0];
        } else {
            this.operations = new OperationDescriptor[operations.size()];
            operations.toArray(this.operations);
        }
    }

    protected void setFields(java.util.Collection<FieldDescriptor> fields) {
        if (null == fields) {
            this.fields = new FieldDescriptor[0];
        } else {
            this.fields = new FieldDescriptor[fields.size()];
            fields.toArray(this.fields);
        }
    }

    protected void setFields(FieldDescriptor[] fields) {
        this.fields = fields;
    }

    protected boolean isFieldsNull() {
        return this.fields == null;
    }

    protected void addOperation(OperationDescriptor operation) {
        int opLen = null == this.operations ? 0 : this.operations.length;
        OperationDescriptor[] tmp = new OperationDescriptor[opLen + 1];
        if (null != this.operations) {
            System.arraycopy(this.operations, 0, tmp, 0, this.operations.length);
        }
        tmp[opLen] = operation;
        this.operations = tmp;
    }

    protected void setConversions(java.util.Collection<OperationDescriptor> conversions) {
        if (null == conversions) {
            this.conversions = new OperationDescriptor[0];
        } else {
            this.conversions = new OperationDescriptor[conversions.size()];
            conversions.toArray(this.conversions);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public boolean enableDynamicDispatch() {
        return true;
    }

    public abstract Class<T> getTypeClass();

    public abstract boolean canBeInstantiated();

    public abstract T create(Object ... var1) throws VilException;

    public Iterable<FieldDescriptor> getFields() {
        return new ArrayIterable<FieldDescriptor>(this.fields);
    }

    public Iterable<OperationDescriptor> getOperations() {
        return new ArrayIterable<OperationDescriptor>(this.operations);
    }

    public Iterable<OperationDescriptor> getConversions() {
        return new ArrayIterable<OperationDescriptor>(this.conversions);
    }

    @Override
    public int getOperationsCount() {
        return this.operations.length;
    }

    @Override
    public OperationDescriptor getOperation(int index) {
        return this.operations[index];
    }

    @Override
    public FieldDescriptor getField(int index) {
        if (null == this.fields) {
            throw new IndexOutOfBoundsException();
        }
        return this.fields[index];
    }

    public FieldDescriptor getField(String name) {
        FieldDescriptor result = null;
        if (null != name) {
            int count = this.getFieldCount();
            for (int i = count - 1; null == result && i >= 0; --i) {
                FieldDescriptor tmp = this.getField(i);
                if (!name.equals(tmp.getName())) continue;
                result = tmp;
            }
        }
        return result;
    }

    @Override
    public int getFieldCount() {
        return null == this.fields ? 0 : this.fields.length;
    }

    public int getConversionsCount() {
        return this.conversions.length;
    }

    public OperationDescriptor getConversion(int index) {
        return this.conversions[index];
    }

    public abstract boolean isAssignableFrom(TypeDescriptor<?> var1);

    @Override
    public IMetaOperation findConversion(IMetaType sourceType, IMetaType targetType) {
        Object result = null;
        for (int c = 0; null == result && c < this.conversions.length; ++c) {
            OperationDescriptor desc = this.conversions[c];
            if (!desc.getParameterType(0).isAssignableFrom(sourceType) || !desc.getReturnType().isAssignableFrom(targetType) && !targetType.isAssignableFrom(desc.getReturnType())) continue;
            result = TypeHelper.getMoreSpecificParam1(desc, result);
        }
        return result;
    }

    public static final OperationDescriptor findConversionOnBoth(TypeDescriptor<?> sourceType, TypeDescriptor<?> targetType) {
        OperationDescriptor c1 = targetType.findConversion(sourceType, targetType);
        OperationDescriptor c2 = sourceType.findConversion(sourceType, targetType);
        return TypeHelper.getMoreSpecificParam1(c1, c2);
    }

    public OperationDescriptor findConversion(TypeDescriptor<?> sourceType, TypeDescriptor<?> targetType) {
        return (OperationDescriptor)this.findConversion((IMetaType)sourceType, (IMetaType)targetType);
    }

    public OperationDescriptor getConversionToSequence() {
        OperationDescriptor result = null;
        for (int c = 0; null == result && c < this.conversions.length; ++c) {
            OperationDescriptor desc = this.conversions[c];
            if (!((TypeDescriptor)desc.getReturnType()).isSequence() || !this.isAssignableFrom((TypeDescriptor<?>)desc.getParameterType(0))) continue;
            result = desc;
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public TypeDescriptor<?>[] getGenericParameter() {
        TypeDescriptor[] result;
        if (null == this.parameter) {
            result = null;
        } else {
            result = new TypeDescriptor[this.parameter.length];
            System.arraycopy(this.parameter, 0, result, 0, this.parameter.length);
        }
        return result;
    }

    @Override
    public int getGenericParameterCount() {
        return null == this.parameter ? 0 : this.parameter.length;
    }

    @Override
    public TypeDescriptor<?> getGenericParameterType(int index) {
        return this.parameter[index];
    }

    public static TypeDescriptor<?>[] createArray(int length) {
        return new TypeDescriptor[length];
    }

    protected String appendParameter(String name, int exclude) {
        StringBuilder tmp = new StringBuilder(name);
        int count = this.getGenericParameterCount();
        if (count > 0) {
            tmp.append('(');
            for (int p = 0; p < count - exclude; ++p) {
                TypeDescriptor<?> param;
                if (p > 0) {
                    tmp.append(", ");
                }
                if (null == (param = this.getGenericParameterType(p))) {
                    tmp.append("<null>");
                    continue;
                }
                tmp.append(param.getVilName());
            }
            tmp.append(')');
        }
        return tmp.toString();
    }

    public String getVilName() {
        return this.getName();
    }

    public abstract boolean isMap();

    public abstract boolean isIterator();

    public abstract boolean isCollection();

    public abstract boolean isSet();

    public abstract boolean isSequence();

    public abstract boolean isInstance(Object var1);

    public abstract boolean isSameType(Object var1);

    @Override
    public abstract OperationDescriptor addPlaceholderOperation(String var1, int var2, boolean var3);

    public abstract boolean isInstantiator();

    public boolean isSame(TypeDescriptor<?> typeDescriptor) {
        return this.isAssignableFrom(typeDescriptor) && typeDescriptor.isAssignableFrom(this);
    }

    public TypeDescriptor<?> flatten() throws VilException {
        TypeDescriptor<Collection<Object>> result = this.isSet() ? TypeRegistry.getSetType(this.flattenParam(this)) : (this.isSequence() ? TypeRegistry.getSequenceType(super.flattenParam(this)) : (this.isCollection() ? TypeRegistry.getCollectionType(super.flattenParam(this)) : this));
        return result;
    }

    public TypeDescriptor<?> flattenParam() {
        return this.flattenParam(this);
    }

    private TypeDescriptor<?> flattenParam(TypeDescriptor<?> type) {
        TypeDescriptor<?> result;
        if (type.getGenericParameterCount() > 0) {
            result = type.getGenericParameterType(0);
            if (result.isCollection()) {
                result = this.flattenParam(result);
            }
        } else {
            result = TypeRegistry.anyType();
        }
        return result;
    }

    public OperationDescriptor findCollectionIteratorOperation(String name) {
        OperationDescriptor result = null;
        for (int o = 0; null == result && o < this.getOperationsCount(); ++o) {
            OperationDescriptor tmp = this.getOperation(o);
            if (!tmp.isIteratingCollectionOperation() || !name.equals(tmp.getName())) continue;
            result = tmp;
        }
        return result;
    }

    public Set<?> allInstances() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    @Override
    public List<IMetaOperation> getCandidates(String name, int unnamedArgsCount) {
        return TypeDescriptor.getCandidates(this, name, unnamedArgsCount);
    }

    public static List<IMetaOperation> getCandidates(IMetaType type, String name, int argCount) {
        IMetaType iterAtLoopStart;
        ArrayList<IMetaOperation> result = new ArrayList<IMetaOperation>(5);
        HashSet<String> known = type.getSuperType() != null ? new HashSet<String>() : null;
        IMetaType iter = type;
        do {
            iterAtLoopStart = iter;
            for (int o = 0; o < iter.getOperationsCount(); ++o) {
                boolean ok;
                IMetaOperation op = iter.getOperation(o);
                if (null != op && op.getName().equals(name)) {
                    int reqParam = op.getRequiredParameterCount();
                    if (argCount > 0) {
                        ok = reqParam > 0 && reqParam <= argCount && argCount <= op.getParameterCount();
                    } else {
                        boolean bl = ok = reqParam == 0;
                    }
                    if (ok && op.isConstructor()) {
                        ok = op.getDeclaringType() == type;
                    }
                } else {
                    ok = false;
                }
                if (!ok) continue;
                if (null == known) {
                    result.add(op);
                    continue;
                }
                String sig = op.getSignature();
                if (known.contains(sig)) continue;
                result.add(op);
                known.add(sig);
            }
        } while ((iter = iter.getSuperType()) != null && iter != iterAtLoopStart);
        return result;
    }
}

