/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.ArrayList;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualTypeProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.UnmodifiableSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.UnmodifiableSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Attribute;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IVariableFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.ValueVisitor;
import net.ssehub.easy.reasoning.core.frontend.ReasonerAdapter;
import net.ssehub.easy.reasoning.core.impl.ReasonerHelper;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ValueCreationResult;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IConfigurationVisitor;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.confModel.IFreezeSelector;
import net.ssehub.easy.varModel.confModel.paths.IResolutionPathElement;
import net.ssehub.easy.varModel.confModel.paths.StartPathElement;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public abstract class AbstractIvmlVariable
extends IvmlElement
implements IActualTypeProvider {
    private static final ValueVisitor VALUE_VISITOR = new ValueVisitor();
    protected IDecisionVariable origVariable;
    protected IDecisionVariable variable;
    protected IVariableFilter filter;
    private DecisionVariable[] nested;
    private Configuration config;

    protected AbstractIvmlVariable(Configuration cfg, IDecisionVariable variable, IVariableFilter filter) {
        AbstractVariable referenced;
        this.origVariable = variable;
        this.variable = variable;
        this.config = cfg;
        this.filter = filter;
        Value val = variable.getValue();
        if (val instanceof ReferenceValue && null != (referenced = ((ReferenceValue)val).getValue())) {
            net.ssehub.easy.varModel.confModel.Configuration config = variable.getConfiguration();
            this.variable = config.getDecision(referenced);
            if (null == this.variable) {
                this.variable = this.origVariable;
            }
        }
    }

    @Invisible
    public Configuration getConfiguration() {
        return this.config;
    }

    @Invisible
    public boolean isVariable(IDecisionVariable var) {
        return this.origVariable == var || this.variable == var;
    }

    public IvmlElement getParent() {
        IvmlElement result = this.config;
        IConfigurationElement elt = this.variable.getParent();
        if (elt instanceof IDecisionVariable) {
            result = this.config.findVariable((IDecisionVariable)elt);
        }
        return result;
    }

    @Override
    protected void initializeNested() {
        if (null == this.nested) {
            if (this.variable.getNestedElementsCount() > 0) {
                ArrayList<DecisionVariable> tmp = new ArrayList<DecisionVariable>();
                this.nested = new DecisionVariable[this.variable.getNestedElementsCount()];
                for (int n = 0; n < this.variable.getNestedElementsCount(); ++n) {
                    IDecisionVariable var = this.variable.getNestedElement(n);
                    if (!this.filter.isEnabled(var)) continue;
                    tmp.add(new DecisionVariable(this.config, var, this.filter));
                }
                this.nested = tmp.toArray(new DecisionVariable[tmp.size()]);
            } else {
                Value val = this.variable.getValue();
                if (val instanceof ContainerValue) {
                    ContainerValue cont = (ContainerValue)val;
                    this.nested = new DecisionVariable[cont.getElementSize()];
                    for (int n = 0; n < this.nested.length; ++n) {
                        this.nested[n] = new DecisionVariable(this.config, new DecVar(this.variable, cont.getElement(n), null), this.filter);
                    }
                }
            }
        }
    }

    @Invisible
    public IDecisionVariable getVariable() {
        return this.origVariable;
    }

    @Invisible
    public IDatatype getActualType() {
        IDatatype dType = null;
        Value val = this.origVariable.getValue();
        dType = null != val && NullValue.INSTANCE != val ? val.getType() : this.origVariable.getDeclaration().getType();
        return dType;
    }

    @Override
    public String getName() {
        return this.origVariable.getDeclaration().getName();
    }

    @Override
    public String getQualifiedName() {
        return this.origVariable.getDeclaration().getQualifiedName();
    }

    public String getVarName() {
        return this.variable.getDeclaration().getName();
    }

    public String getQualifiedVarName() {
        return this.variable.getDeclaration().getName();
    }

    @Override
    public TypeDescriptor<?> getType() {
        Value value = this.getDecisionVariable().getValue();
        IDatatype type = null != value ? value.getType() : this.getIvmlType();
        return AbstractIvmlVariable.getTypeDescriptor(type);
    }

    @Override
    public String getTypeName() {
        return this.getIvmlType().getName();
    }

    @Invisible
    public IDatatype getIvmlType() {
        return this.variable.getDeclaration().getType();
    }

    @Override
    public String getQualifiedType() {
        return this.origVariable.getDeclaration().getType().getQualifiedName();
    }

    @OperationMeta(name={"isConfigured", "isDefined"})
    public boolean isConfigured() {
        return AssignmentState.UNDEFINED != this.origVariable.getState() && null != this.origVariable.getValue();
    }

    public boolean isFrozen() {
        return AssignmentState.FROZEN == this.origVariable.getState();
    }

    public void clearValue() {
        try {
            this.origVariable.setValue(null, AssignmentState.UNDEFINED);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void setValue(Object value) {
        if (!this.isFrozen()) {
            IDecisionVariable toChange = this.variable;
            boolean refVar = Reference.TYPE.isAssignableFrom(this.origVariable.getDeclaration().getType());
            if (value instanceof AbstractIvmlVariable && refVar) {
                IDecisionVariable newVar = ((AbstractIvmlVariable)value).variable;
                toChange = null;
                this.changeValue(this.origVariable, newVar.getDeclaration());
                this.nested = null;
                this.variable = newVar;
            } else if (null == value && refVar) {
                toChange = null;
                this.changeValue(this.origVariable, null);
                this.nested = null;
                this.variable = this.origVariable;
            } else if (value instanceof IvmlElement) {
                value = ((IvmlElement)value).getValue();
            }
            if (null != toChange) {
                this.changeValue(toChange, value);
            }
        } else {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").error("setting " + value + " as new value is not possible as variable " + net.ssehub.easy.varModel.confModel.Configuration.getInstanceName(this.variable) + " is frozen");
        }
    }

    private void changeValue(IDecisionVariable toChange, Object value) {
        IDatatype varType;
        if (null == value) {
            value = NullValue.INSTANCE;
        }
        if (TypeQueries.sameTypes(IntegerType.TYPE, varType = toChange.getDeclaration().getType()) && value instanceof Double) {
            value = ((Double)value).intValue();
        }
        try {
            Value oldValue = toChange.getValue();
            if (null != oldValue) {
                oldValue = oldValue.clone();
            }
            Value val = value instanceof Value ? (Value)value : ValueFactory.createValue(varType, value);
            IAssignmentState varState = toChange.getState();
            if (AssignmentState.UNDEFINED == varState) {
                varState = AssignmentState.USER_ASSIGNED;
            } else if (AssignmentState.ASSIGNED == varState) {
                varState = AssignmentState.USER_ASSIGNED;
            }
            toChange.setValue(val, varState);
            this.config.notifyValueChanged(this, oldValue);
        }
        catch (ConfigurationException e) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").error("while changing " + this.getName() + " with value " + value + ": " + e.getMessage());
        }
        catch (ValueDoesNotMatchTypeException e) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").error("while changing " + this.getName() + " with value " + value + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOriginalValue() {
        Object result = null;
        Value val = this.config.getChangeHistory().getOriginalValue(this);
        if (null != val) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                val.accept(VALUE_VISITOR);
                result = VALUE_VISITOR.getValue();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Invisible
    public static Object toObject(Value value) {
        Object result = null;
        if (null != value) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                value.accept(VALUE_VISITOR);
                result = VALUE_VISITOR.getValue();
            }
        }
        return result;
    }

    @Override
    public Object getValue() {
        return AbstractIvmlVariable.toObject(this.variable.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStringValue() {
        String result = null;
        if (null != this.variable.getValue()) {
            Object o;
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                this.variable.getValue().accept(VALUE_VISITOR);
                result = VALUE_VISITOR.getStringValue();
            }
            if (null == result && null != (o = this.variable.getValue().getValue())) {
                result = o.toString();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getIntegerValue() {
        Integer result = null;
        if (null != this.variable.getValue()) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                this.variable.getValue().accept(VALUE_VISITOR);
                result = VALUE_VISITOR.getIntegerValue();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getRealValue() {
        Double result = null;
        if (null != this.variable.getValue()) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                this.variable.getValue().accept(VALUE_VISITOR);
                result = VALUE_VISITOR.getDoubleValue();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getBooleanValue() {
        Boolean result = null;
        if (null != this.variable.getValue()) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                this.variable.getValue().accept(VALUE_VISITOR);
                result = VALUE_VISITOR.getBooleanValue();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumValue getEnumValue() {
        EnumValue result = null;
        if (null != this.variable.getValue()) {
            ValueVisitor valueVisitor = VALUE_VISITOR;
            synchronized (valueVisitor) {
                VALUE_VISITOR.clear();
                this.variable.getValue().accept(VALUE_VISITOR);
                result = VALUE_VISITOR.getEnumValue();
            }
        }
        return result;
    }

    @OperationMeta(returnGenerics={DecisionVariable.class})
    public Sequence<DecisionVariable> variables() {
        this.initializeNested();
        return new UnmodifiableSequence<DecisionVariable>(new ArraySequence<DecisionVariable>(this.nested, DecisionVariable.class));
    }

    @Invisible
    @OperationMeta(returnGenerics={DecisionVariable.class})
    public Set<DecisionVariable> variablesSet() {
        this.initializeNested();
        return new UnmodifiableSet<DecisionVariable>(new ArraySet<DecisionVariable>(this.nested, DecisionVariable.class));
    }

    public Configuration selectAll() {
        this.initializeNested();
        return new Configuration(this.variable.getConfiguration(), this.nested, this.filter);
    }

    @OperationMeta(returnGenerics={Attribute.class})
    public abstract Set<Attribute> attributes();

    @OperationMeta(returnGenerics={Attribute.class})
    public abstract Set<Attribute> annotations();

    public int hashCode() {
        return this.variable.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof AbstractIvmlVariable && this.variable.equals(((AbstractIvmlVariable)object).variable);
    }

    @Override
    public IvmlElement getElement(String name) {
        this.initializeNested();
        this.initializeAttributes();
        IvmlElement result = this.search(name, this.nested);
        if (null == result) {
            for (int a = 0; null == result && a < this.getAttributeCount(); ++a) {
                result = this.checkElement(name, this.getAttribute(a));
            }
        }
        return result;
    }

    public DecisionVariable getByName(String name) {
        IvmlElement elt = this.getElement(name);
        DecisionVariable result = elt instanceof DecisionVariable ? (DecisionVariable)elt : null;
        return result;
    }

    @Invisible
    public IDecisionVariable getDecisionVariable() {
        return this.variable;
    }

    public IvmlDeclaration getDeclaration() {
        return new IvmlDeclaration(this.variable.getDeclaration());
    }

    @Override
    @Invisible
    public String getInstanceName() {
        return net.ssehub.easy.varModel.confModel.Configuration.getInstanceName(this.getVariable());
    }

    private EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(AbstractIvmlVariable.class, "net.ssehub.easy.instantiation.core");
    }

    public void createValue(boolean override) {
        this.createValue(this.getType(), override);
    }

    public void createValue(TypeDescriptor<?> type, boolean override) {
        if (null != this.variable && (override || !override && !this.isConfigured()) && type instanceof IvmlTypeDescriptor) {
            IDatatype t = ((IvmlTypeDescriptor)type).getIvmlType();
            if (this.variable.getDeclaration().getType().isAssignableFrom(t)) {
                this.createValue(this.variable, t);
            } else {
                this.getLogger().warn("given type is not compatible to variable type");
            }
        }
    }

    private void createValue(IDecisionVariable var, IDatatype type) {
        ValueCreationResult vRes = ReasonerAdapter.getInstanceSafe().createValue(var.getConfiguration().getConfiguration(), var.getDeclaration(), type, null, ProgressObserver.NO_OBSERVER);
        for (int m = 0; m < vRes.getMessageCount(); ++m) {
            Message msg = vRes.getMessage(m);
            this.getLogger().warn(msg.getDescription());
        }
        if (vRes.getVariable() != null) {
            AbstractIvmlVariable.transferState(vRes.getVariable(), var);
            try {
                var.setValue(vRes.getVariable().getValue(), AssignmentState.ASSIGNED);
            }
            catch (ConfigurationException e) {
                this.getLogger().warn(e.getMessage());
            }
        }
    }

    private static void transferState(IDecisionVariable source, IDecisionVariable target) {
        if (source.getState() != target.getState()) {
            if (AssignmentState.FROZEN == target.getState()) {
                if (source.getConfiguration().getConfiguration().isApproximatelyFrozen()) {
                    target.unfreeze(source.getState());
                }
            } else {
                try {
                    target.setValue(source.getValue(), source.getState());
                }
                catch (ConfigurationException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(ReasonerHelper.class, "net.ssehub.easy.instantiation.core").warn("transferState: " + e.getMessage());
                }
            }
        }
        for (int a = 0; a < source.getAttributesCount(); ++a) {
            IDecisionVariable sAttr = source.getAttribute(a);
            IDecisionVariable tAttr = target.getAttribute(a);
            AbstractIvmlVariable.transferState(sAttr, tAttr);
        }
        for (int n = 0; n < source.getNestedElementsCount(); ++n) {
            IDecisionVariable sNested = source.getNestedElement(n);
            IDecisionVariable tNested = target.getNestedElement(sNested.getDeclaration().getName());
            if (null == tNested) {
                tNested = target.getNestedElement(n);
            }
            if (null == tNested) continue;
            AbstractIvmlVariable.transferState(sNested, tNested);
        }
    }

    public DecisionVariable addValue() {
        DecisionVariable result = null;
        if (null != this.variable) {
            IDatatype vType = DerivedDatatype.resolveToBasis(this.variable.getDeclaration().getType());
            if (Container.TYPE.isAssignableFrom(vType) && vType.getGenericTypeCount() > 0) {
                result = this.addValue(vType.getGenericType(0));
            } else {
                this.getLogger().warn("given type is not a container");
            }
        }
        return result;
    }

    public DecisionVariable addValue(TypeDescriptor<?> type) {
        DecisionVariable result = null;
        if (null != this.variable && type instanceof IvmlTypeDescriptor) {
            IDatatype vType = DerivedDatatype.resolveToBasis(this.variable.getDeclaration().getType());
            if (Container.TYPE.isAssignableFrom(vType) && vType.getGenericTypeCount() > 0) {
                IDatatype iType = ((IvmlTypeDescriptor)type).getIvmlType();
                if (vType.getGenericType(0).isAssignableFrom(iType)) {
                    result = this.addValue(iType);
                } else {
                    this.getLogger().warn("given type is not compatible to container element type");
                }
            } else {
                this.getLogger().warn("given type is not a container");
            }
        }
        return result;
    }

    private DecisionVariable addValue(IDatatype type) {
        DecisionVariable result = null;
        if (this.variable instanceof ContainerVariable) {
            ContainerVariable cVariable = (ContainerVariable)this.variable;
            IDecisionVariable var = cVariable.addNestedElement(type);
            this.createValue(var, type);
            if (this.filter.isEnabled(var)) {
                result = new DecisionVariable(this.config, var, this.filter);
                int nestedLength = null == this.nested ? 0 : this.nested.length;
                DecisionVariable[] tmp = new DecisionVariable[nestedLength + 1];
                if (null != this.nested) {
                    System.arraycopy(this.nested, 0, tmp, 0, nestedLength);
                }
                tmp[nestedLength] = result;
                this.nested = tmp;
            }
        }
        return result;
    }

    public String toString() {
        AbstractVariable decl = this.variable.getDeclaration();
        return decl.getType().toString() + " " + decl.getName() + " = " + this.variable.getValue().toString();
    }

    @Override
    @Invisible
    public IDatatype determineActualTypeName() {
        IDatatype type;
        IDatatype declType = this.getDecisionVariable().getDeclaration().getType();
        IDatatype actType = this.getActualType();
        if (TypeQueries.isCompound(declType) && !TypeQueries.isReference(actType)) {
            type = actType;
        } else if (TypeQueries.isCompound(declType) && TypeQueries.isReference(actType)) {
            type = declType;
            if (null != this.variable && null != this.variable.getValue() && type.isAssignableFrom(this.variable.getValue().getType())) {
                type = this.variable.getValue().getType();
            }
        } else {
            type = declType;
        }
        return type;
    }

    private static class DecVar
    implements IDecisionVariable {
        private IDecisionVariable parent;
        private Value value;
        private DecisionVariableDeclaration decl;
        private IDecisionVariable[] nested;

        private DecVar(IDecisionVariable parent, Value value, DecisionVariableDeclaration decl) {
            this.parent = parent;
            this.value = value;
            this.decl = null == decl ? new DecisionVariableDeclaration("", value.getType(), parent.getDeclaration().getParent()) : decl;
        }

        private void initializeNested() {
            block2: {
                block3: {
                    if (null != this.nested) break block2;
                    if (!(this.value instanceof CompoundValue)) break block3;
                    CompoundValue comp = (CompoundValue)this.value;
                    Compound type = (Compound)comp.getType();
                    this.nested = new IDecisionVariable[type.getElementCount()];
                    for (int i = 0; i < this.nested.length; ++i) {
                        DecisionVariableDeclaration d = type.getElement(i);
                        this.nested[i] = new DecVar(this, comp.getNestedValue(d.getName()), d);
                    }
                    break block2;
                }
                if (!(this.value instanceof ContainerValue)) break block2;
                ContainerValue cont = (ContainerValue)this.value;
                this.nested = new IDecisionVariable[cont.getElementSize()];
                for (int i = 0; i < this.nested.length; ++i) {
                    this.nested[i] = new DecVar(this, cont.getElement(i), null);
                }
            }
        }

        @Override
        public IConfigurationElement getParent() {
            return this.parent;
        }

        @Override
        public net.ssehub.easy.varModel.confModel.Configuration getConfiguration() {
            return this.parent.getConfiguration();
        }

        @Override
        public boolean isNested() {
            return true;
        }

        @Override
        public IAssignmentState getState() {
            return this.parent.getState();
        }

        @Override
        public void setValue(Value value, IAssignmentState state, IConfigurationElement nested) throws ConfigurationException {
        }

        @Override
        public void freeze(IFreezeSelector selector) {
        }

        @Override
        public void unfreeze(IAssignmentState state) {
        }

        @Override
        public void freeze(String nestedElement) {
        }

        @Override
        public AbstractVariable getDeclaration() {
            return this.decl;
        }

        @Override
        public void accept(IConfigurationVisitor visitor) {
            visitor.visitDecisionVariable(this);
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @Override
        public void setValue(Value value, IAssignmentState state) throws ConfigurationException {
        }

        @Override
        public void setValue(Value value, IAssignmentState state, boolean asAssignment) throws ConfigurationException {
        }

        @Override
        public void setHistoryValue(Value value, IAssignmentState state) throws ConfigurationException {
        }

        @Override
        public int getNestedElementsCount() {
            this.initializeNested();
            return null == this.nested ? 0 : this.nested.length;
        }

        @Override
        public IDecisionVariable getNestedElement(int index) {
            this.initializeNested();
            if (null == this.nested) {
                throw new IndexOutOfBoundsException();
            }
            return this.nested[index];
        }

        @Override
        public IDecisionVariable getNestedElement(String name) {
            return net.ssehub.easy.varModel.confModel.Configuration.getNestedElement(this, name);
        }

        @Override
        public int getAttributesCount() {
            return this.parent.getAttributesCount();
        }

        @Override
        public IDecisionVariable getAttribute(int index) {
            return this.parent.getAttribute(index);
        }

        @Override
        public int getNestedDepth() {
            return 0;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public boolean hasValue() {
            return this.value != null;
        }

        @Override
        public boolean hasNullValue() {
            return this.value == null || NullValue.INSTANCE == this.value;
        }

        @Override
        public boolean removeDerivedValues() {
            return false;
        }

        @Override
        public String getQualifiedName() {
            return this.getDeclaration().getQualifiedName();
        }

        @Override
        public IResolutionPathElement getResolutionPath() {
            return new StartPathElement(this.getDeclaration());
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        @Override
        public boolean wasCreated() {
            return true;
        }

        @Override
        public void notifyCreated() {
        }

        @Override
        public boolean notifyWasAssigned(Value value) {
            return false;
        }

        @Override
        public boolean wasAssigned() {
            return true;
        }

        @Override
        public boolean enableWasAssignedForIsDefined() {
            return false;
        }
    }
}

