/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AbstractIvmlVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IChangeHistoryTracer;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IChangeHistoryVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IVariableFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.SetVariablesFilter;
import net.ssehub.easy.varModel.confModel.IConfigurationChangeListener;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;

public class ChangeHistory
implements IVilType,
IStringValueProvider {
    private Configuration configuration;
    private IChangeHistoryTracer tracer;
    private Map<IDecisionVariable, Value> originalValues = new HashMap<IDecisionVariable, Value>();
    private CSet committed = new CSet();
    private Stack<CSet> changeSetStack = new Stack();
    private IConfigurationChangeListener changeListener = new ChangeListener();

    ChangeHistory(Configuration configuration) {
        this.configuration = configuration;
        this.configuration.getConfiguration().register(this.changeListener);
    }

    protected void finalize() throws Throwable {
        this.configuration.getConfiguration().unregister(this.changeListener);
        super.finalize();
    }

    public boolean hasChanges() {
        boolean result = false;
        if (!this.changeSetStack.isEmpty()) {
            result = this.changeSetStack.peek().hasChanges();
        }
        return result;
    }

    public void start() {
        this.changeSetStack.push(new CSet());
        if (null != this.tracer) {
            this.tracer.started(this.configuration);
        }
    }

    public void rollback() {
        if (!this.changeSetStack.isEmpty()) {
            if (null != this.tracer) {
                this.tracer.rollingBack(this.configuration);
            }
            CSet top = this.changeSetStack.pop();
            for (Map.Entry entry : top.entrySet()) {
                ((AbstractIvmlVariable)entry.getKey()).setValue(entry.getValue());
            }
            if (null != this.tracer) {
                this.tracer.rolledBack(this.configuration);
            }
        }
    }

    public void changes(IChangeHistoryVisitor visitor) {
        if (!this.changeSetStack.isEmpty()) {
            CSet top = this.changeSetStack.peek();
            for (Map.Entry e : top.entrySet()) {
                visitor.changed((AbstractIvmlVariable)e.getKey(), (Value)e.getValue());
            }
        }
    }

    public void allChanges(IChangeHistoryVisitor visitor) {
        for (CSet changes : this.changeSetStack) {
            for (Map.Entry e : changes.entrySet()) {
                visitor.changed((AbstractIvmlVariable)e.getKey(), (Value)e.getValue());
            }
        }
    }

    public void commit() {
        if (!this.changeSetStack.isEmpty()) {
            if (null != this.tracer) {
                this.tracer.committing(this.configuration);
            }
            CSet top = this.changeSetStack.pop();
            CSet target = this.changeSetStack.isEmpty() ? this.committed : this.changeSetStack.peek();
            for (Map.Entry entry : top.entrySet()) {
                if (target.containsKey(entry.getKey())) continue;
                target.put((AbstractIvmlVariable)entry.getKey(), (Value)entry.getValue());
            }
            if (null != this.tracer) {
                this.tracer.committed(this.configuration);
            }
        }
    }

    @Invisible
    public void commitAll() {
        while (!this.changeSetStack.isEmpty()) {
            this.commit();
        }
    }

    @Invisible
    public void rollbackAll() {
        while (!this.changeSetStack.isEmpty()) {
            this.rollback();
        }
    }

    @Invisible
    public Value getOriginalValue(AbstractIvmlVariable variable) {
        Value value = this.originalValues.get(variable.origVariable);
        if (null == value) {
            value = variable.getVariable().getValue();
        }
        Value result = net.ssehub.easy.varModel.confModel.Configuration.dereference(this.configuration.getConfiguration(), value);
        return result;
    }

    @Invisible
    public void rollbackSimulation() {
        this.rollbackAll();
        for (Map.Entry entry : this.committed.entrySet()) {
            ((AbstractIvmlVariable)entry.getKey()).setValue(entry.getValue());
        }
        this.clear(true);
    }

    private static boolean isSameValue(Value value1, Value value2) {
        boolean isSame = null == value1 ? null == value2 : value1.equals(value2);
        return isSame;
    }

    @Invisible
    void notifyChanged(AbstractIvmlVariable variable, Value value) {
        if (!ChangeHistory.isSameValue(variable.getVariable().getValue(), value)) {
            CSet changeSet;
            if (!this.originalValues.containsKey(variable.origVariable)) {
                Value oValue = value == null ? NullValue.INSTANCE : value;
                this.originalValues.put(variable.origVariable, oValue);
                if (null != this.tracer) {
                    this.tracer.recordedOriginalVariable(variable, oValue);
                }
            }
            if (!(changeSet = !this.changeSetStack.isEmpty() ? this.changeSetStack.peek() : this.committed).containsKey(variable)) {
                if (null == value) {
                    value = NullValue.INSTANCE;
                }
                changeSet.notifyChanged(variable, value);
                if (null != this.tracer) {
                    this.tracer.recordedChangedVariable(variable, value);
                }
            }
        }
    }

    @Invisible
    Set<AbstractIvmlVariable> changed() {
        HashSet<AbstractIvmlVariable> enabled = new HashSet<AbstractIvmlVariable>();
        this.committed.addAllIvmlElements(enabled);
        for (int i = 0; i < this.changeSetStack.size(); ++i) {
            ((CSet)this.changeSetStack.get(i)).addAllIvmlElements(enabled);
        }
        return enabled;
    }

    @Invisible
    IVariableFilter changedFilter() {
        HashSet<IDecisionVariable> enabled = new HashSet<IDecisionVariable>();
        this.committed.addAllDecisionVariables(enabled);
        for (int i = 0; i < this.changeSetStack.size(); ++i) {
            ((CSet)this.changeSetStack.get(i)).addAllDecisionVariables(enabled);
        }
        return new SetVariablesFilter(enabled);
    }

    @Override
    @Invisible
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "<change set>";
    }

    @Invisible
    public void clear(boolean resetOriginalValues) {
        this.changeSetStack.clear();
        this.committed.clear();
        if (resetOriginalValues) {
            this.originalValues.clear();
        }
    }

    public IChangeHistoryTracer setTracer(IChangeHistoryTracer tracer) {
        IChangeHistoryTracer old = this.tracer;
        this.tracer = tracer;
        return old;
    }

    public IChangeHistoryTracer getTracer() {
        return this.tracer;
    }

    private class ChangeListener
    implements IConfigurationChangeListener {
        private ChangeListener() {
        }

        @Override
        public void itemChanged(net.ssehub.easy.varModel.confModel.Configuration config, IDecisionVariable changedVariable, Value oldValue) {
            IvmlElement elt = ChangeHistory.this.configuration.get(changedVariable.getDeclaration().getQualifiedName());
            if (elt instanceof AbstractIvmlVariable) {
                ChangeHistory.this.notifyChanged((AbstractIvmlVariable)elt, oldValue);
            }
        }

        @Override
        public void stateChanged(net.ssehub.easy.varModel.confModel.Configuration config, IDecisionVariable changedVariable) {
        }

        @Override
        public void configurationRefreshed(net.ssehub.easy.varModel.confModel.Configuration config) {
        }
    }

    private static class CSet
    extends HashMap<AbstractIvmlVariable, Value> {
        private int directChanges = 0;

        private CSet() {
        }

        private void addAllIvmlElements(Set<AbstractIvmlVariable> result) {
            for (AbstractIvmlVariable var : this.keySet()) {
                result.add(var);
            }
        }

        private void addAllDecisionVariables(Set<IDecisionVariable> result) {
            for (AbstractIvmlVariable var : this.keySet()) {
                IConfigurationElement iter = var.getVariable();
                while (iter instanceof IDecisionVariable) {
                    result.add((IDecisionVariable)iter);
                    iter = iter.getParent();
                }
            }
        }

        private void notifyChanged(AbstractIvmlVariable variable, Value value) {
            this.put(variable, value);
            ++this.directChanges;
        }

        private boolean hasChanges() {
            return this.directChanges > 0;
        }
    }
}

