/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractCollectionWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SetSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AbstractIvmlVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AllFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Attribute;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.ChangeHistory;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.ConfigurationContextResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.FrozenVariablesFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IConfigurationFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IVariableFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.NameRegExFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.NoFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.ProjectFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.ValueFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.VariableCollector;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public class Configuration
extends IvmlElement
implements IStringValueProvider {
    private Script rootScript;
    private Project project;
    private net.ssehub.easy.varModel.confModel.Configuration configuration;
    private DecisionVariable[] variables;
    private Attribute[] attributes;
    private Map<String, IvmlElement> nameMap = new HashMap<String, IvmlElement>();
    private IVariableFilter filter;
    private boolean isValid = true;
    private ChangeHistory changed;

    public Configuration(net.ssehub.easy.varModel.confModel.Configuration configuration) {
        this(configuration, FrozenVariablesFilter.INSTANCE);
    }

    public Configuration(net.ssehub.easy.varModel.confModel.Configuration configuration, IVariableFilter filter) {
        this.configuration = configuration;
        this.project = configuration.getProject();
        this.filter = filter;
        this.changed = new ChangeHistory(this);
    }

    Configuration(net.ssehub.easy.varModel.confModel.Configuration configuration, DecisionVariable[] variables, IVariableFilter filter) {
        this.configuration = configuration;
        this.variables = variables;
        this.project = configuration.getProject();
        this.filter = filter;
        this.changed = new ChangeHistory(this);
        this.index(variables);
    }

    private Configuration(Configuration configuration, java.util.Set<AbstractIvmlVariable> changed) {
        this.isValid = configuration.isValid;
        this.configuration = configuration.configuration;
        this.project = configuration.project;
        this.changed = configuration.changed;
        ConfigurationContextResolver resolver = new ConfigurationContextResolver(this, changed);
        resolver.resolve();
        this.filter = resolver.filter();
        this.variables = resolver.variables();
        this.index(this.variables);
        this.attributes = resolver.attributes();
        this.index(this.attributes);
    }

    private Configuration(Configuration configuration, IConfigurationFilter variablesFilter, IVariableFilter filter) {
        this(configuration, null, variablesFilter, filter);
    }

    private Configuration(Configuration configuration, Project project, IConfigurationFilter variablesFilter, IVariableFilter filter) {
        this.isValid = configuration.isValid;
        this.filter = filter;
        this.configuration = configuration.getConfiguration();
        this.changed = configuration.changed;
        this.project = null == project ? this.configuration.getProject() : project;
        configuration.initializeNested();
        if (null != variablesFilter && variablesFilter != NoFilter.INSTANCE) {
            ArrayList<DecisionVariable> tmp = new ArrayList<DecisionVariable>();
            for (int v = 0; v < configuration.variables.length; ++v) {
                DecisionVariable var = configuration.variables[v];
                if (!variablesFilter.include(var)) continue;
                tmp.add(var);
                if (this.project.getName().equals(var.getDecisionVariable().getDeclaration().getNameSpace())) {
                    this.nameMap.put(var.getName(), var);
                }
                this.nameMap.put(var.getQualifiedName(), var);
            }
            this.variables = new DecisionVariable[tmp.size()];
            tmp.toArray(this.variables);
        }
        configuration.initializeAttributes();
        this.attributes = configuration.attributes;
        this.index(this.attributes);
    }

    private void index(IvmlElement[] elements) {
        if (null != elements) {
            for (int e = 0; e < elements.length; ++e) {
                this.nameMap.put(elements[e].getName(), elements[e]);
                this.nameMap.put(elements[e].getQualifiedName(), elements[e]);
            }
        }
    }

    @Invisible
    public net.ssehub.easy.varModel.confModel.Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void initializeNested() {
        if (null == this.variables) {
            Project project = this.configuration.getProject();
            VariableCollector collector = new VariableCollector(this, this.filter);
            project.accept(collector);
            this.variables = collector.getCollectedVariables();
            this.index(this.variables);
        }
    }

    @Override
    protected void initializeAttributes() {
        if (null == this.attributes) {
            Project project = this.configuration.getProject();
            ArrayList<Attribute> tmp = new ArrayList<Attribute>();
            for (int a = 0; a < project.getAttributesCount(); ++a) {
                IDecisionVariable var = this.configuration.getDecision(project.getAttribute(a));
                if (null == var || !this.filter.isEnabled(var)) continue;
                Attribute attr = new Attribute(this, var, this.filter);
                tmp.add(attr);
                this.nameMap.put(attr.getQualifiedName(), attr);
            }
            this.attributes = new Attribute[tmp.size()];
            tmp.toArray(this.attributes);
        }
    }

    @OperationMeta(returnGenerics={DecisionVariable.class})
    public Sequence<DecisionVariable> variables() {
        this.initializeNested();
        return new ArraySequence<DecisionVariable>(this.variables, DecisionVariable.class);
    }

    public Configuration selectByName(String namePattern) throws VilException {
        this.initializeNested();
        NameRegExFilter regexFilter = new NameRegExFilter(namePattern, NameRegExFilter.DataType.NAME);
        Configuration newConfig = new Configuration(this, regexFilter, this.filter);
        return newConfig;
    }

    public Configuration selectByType(String typePattern) throws VilException {
        this.initializeNested();
        return new Configuration(this, new NameRegExFilter(typePattern, NameRegExFilter.DataType.TYPE), this.filter);
    }

    public Configuration selectByAnnotation(String namePattern) throws VilException {
        this.initializeAttributes();
        return new Configuration(this, new NameRegExFilter(namePattern, NameRegExFilter.DataType.ATTRIBUTE), this.filter);
    }

    public Configuration selectByAttribute(String namePattern) throws VilException {
        return this.selectByAnnotation(namePattern);
    }

    public Configuration selectByProject(String name, boolean considerImports) {
        Project project = ModelQuery.findProject(this.configuration.getProject(), name);
        if (null == project) {
            project = new Project(name);
        }
        return new Configuration(this, project, new ProjectFilter(project, considerImports), this.filter);
    }

    public Configuration selectByProject(String name) {
        return this.selectByProject(name, true);
    }

    public Configuration selectByAnnotation(String name, Object value) throws VilException {
        this.initializeAttributes();
        Configuration result = null == name ? new Configuration(this, AllFilter.INSTANCE, this.filter) : new Configuration(this, new NameRegExFilter(name, NameRegExFilter.DataType.ATTRIBUTE, new ValueFilter(value, Attribute.class)), this.filter);
        return result;
    }

    public Configuration selectByAttribute(String name, Object value) throws VilException {
        return this.selectByAnnotation(name, value);
    }

    public boolean isEmpty() {
        int count = 0;
        if (null != this.variables || null != this.attributes) {
            count += null != this.variables ? this.variables.length : 0;
            count += null != this.attributes ? this.attributes.length : 0;
        } else {
            count = this.configuration.getProject().getElementCount();
        }
        return count == 0;
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "<config>";
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.project.getQualifiedName();
    }

    @Override
    public TypeDescriptor<?> getType() {
        return Configuration.getTypeDescriptor(this.project.getType());
    }

    @Override
    public String getTypeName() {
        return this.project.getType().getName();
    }

    @Override
    public String getQualifiedType() {
        return this.project.getType().getQualifiedName();
    }

    @Override
    Attribute getAttribute(int index) {
        this.initializeAttributes();
        if (null == this.attributes) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[index];
    }

    @Override
    int getAttributeCount() {
        this.initializeAttributes();
        return null == this.attributes ? 0 : this.attributes.length;
    }

    @Override
    @Invisible
    public Object getValue() {
        return null;
    }

    @OperationMeta(returnGenerics={Attribute.class})
    public Sequence<Attribute> attributes() {
        this.initializeAttributes();
        return new ArraySequence<Attribute>(this.attributes, Attribute.class);
    }

    public DecisionVariable getByName(String name) {
        IvmlElement elt = this.getElement(name);
        DecisionVariable result = elt instanceof DecisionVariable ? (DecisionVariable)elt : null;
        return result;
    }

    @Override
    @Invisible
    public IvmlElement getElement(String name) {
        IvmlElement match;
        this.initializeAttributes();
        this.initializeNested();
        String key = name;
        int pos = name.indexOf("::");
        if (pos > 0 && (pos = name.indexOf("::", pos + 2)) > 0) {
            key = name.substring(0, pos);
        }
        if (null != (match = this.nameMap.get(key)) && key.length() < name.length()) {
            match = match.getElement(name);
        }
        if (null == match) {
            match = this.nameMap.get(name);
        }
        if (null == match) {
            Project project = this.configuration.getProject();
            try {
                AbstractVariable var = (AbstractVariable)ModelQuery.findElementByName(project, name, AbstractVariable.class);
                if (null != var) {
                    match = new IvmlDeclaration(var);
                }
            }
            catch (IvmlException var) {
                // empty catch block
            }
            try {
                Value eVal = ModelQuery.enumLiteralAsValue(project, name);
                if (eVal instanceof net.ssehub.easy.varModel.model.values.EnumValue) {
                    match = new EnumValue((net.ssehub.easy.varModel.model.values.EnumValue)eVal);
                }
            }
            catch (IvmlException ivmlException) {
                // empty catch block
            }
        }
        return match;
    }

    @Override
    @Invisible
    public String getStringValue() {
        return null;
    }

    @Override
    @Invisible
    public Integer getIntegerValue() {
        return null;
    }

    @Override
    @Invisible
    public Double getRealValue() {
        return null;
    }

    @Override
    @Invisible
    public Boolean getBooleanValue() {
        return null;
    }

    @Override
    @Invisible
    public EnumValue getEnumValue() {
        return null;
    }

    @Invisible
    public Script getRootScript() {
        return this.rootScript;
    }

    @Invisible
    public void setRootScript(Script rootScript) {
        this.rootScript = rootScript;
    }

    public FileArtifact store(Path path) throws VilException {
        return this.store(path, true);
    }

    public FileArtifact store(Path path, boolean userValuesOnly) throws VilException {
        File target = path.getAbsolutePath();
        OutputStreamWriter out = null;
        try {
            Project project = this.configuration.toProject(true, userValuesOnly);
            out = new FileWriter(target);
            IVMLWriter writer = new IVMLWriter(out);
            project.accept(writer);
            IVMLWriter.releaseInstance(writer);
            out.close();
        }
        catch (ConfigurationException e) {
            throw new VilException(e, 30012);
        }
        catch (IOException e) {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new VilException(e, 50001);
        }
        return ArtifactFactory.createArtifact(FileArtifact.class, target, null);
    }

    public Configuration reason() {
        Configuration result;
        ReasoningResult tmp = ReasonerFrontend.getInstance().propagate(this.configuration, new ReasonerConfiguration(), ProgressObserver.NO_OBSERVER);
        if (tmp.providesInformationOnAffectedVariables()) {
            int aCount = tmp.getAffectedVariablesCount();
            final HashSet<String> affected = new HashSet<String>();
            for (int a = 0; a < aCount; ++a) {
                affected.add(tmp.getAffectedVariable(a).getDeclaration().getQualifiedName());
            }
            IConfigurationFilter reasoningFilter = new IConfigurationFilter(){

                @Override
                public boolean include(IvmlElement element) {
                    return affected.contains(element.getQualifiedName());
                }
            };
            result = new Configuration(this, reasoningFilter, this.filter);
            result.isValid = !tmp.hasConflict();
        } else {
            result = this;
        }
        return result;
    }

    public Configuration selectFrozen() {
        Configuration result;
        if (this.filter == FrozenVariablesFilter.INSTANCE) {
            result = this;
        } else {
            result = new Configuration(this.configuration, FrozenVariablesFilter.INSTANCE);
            result.isValid = this.isValid;
        }
        return result;
    }

    public Configuration selectAll() {
        return this;
    }

    public Configuration copy() {
        Configuration result = new Configuration(new net.ssehub.easy.varModel.confModel.Configuration(this.configuration), this.filter);
        result.isValid = this.isValid;
        return result;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public Configuration selectChanged() {
        return new Configuration(this.configuration, this.changed.changedFilter());
    }

    public Configuration selectChangedWithContext() {
        return new Configuration(this, this.changed.changed());
    }

    @Invisible
    public void notifyValueChanged(AbstractIvmlVariable variable, Value oldValue) {
        this.changed.notifyChanged(variable, oldValue);
    }

    @Invisible
    IvmlElement get(String name) {
        return this.nameMap.get(name);
    }

    public ChangeHistory getChangeHistory() {
        return this.changed;
    }

    @Invisible
    public DecisionVariable findVariable(IDecisionVariable var) {
        DecisionVariable result = this.getByName(net.ssehub.easy.varModel.confModel.Configuration.getInstanceName(var));
        for (int v = 0; null == result && v < this.variables.length; ++v) {
            result = this.findVariable(var, this.variables[v]);
        }
        return result;
    }

    private DecisionVariable findVariable(IDecisionVariable var, DecisionVariable dVar) {
        DecisionVariable result = null;
        if (dVar.isVariable(var)) {
            result = dVar;
        } else {
            Sequence<DecisionVariable> vars = dVar.variables();
            for (int v = 0; null == result && v < vars.size(); ++v) {
                DecisionVariable tmp = vars.get(v);
                if (!tmp.isVariable(var)) continue;
                result = tmp;
            }
        }
        return result;
    }

    public Set<?> allInstances(TypeDescriptor<?> type) {
        IDatatype ivmlType;
        Value val;
        AbstractCollectionWrapper result = null;
        if (type instanceof IvmlTypeDescriptor && (val = this.configuration.getAllInstances(ivmlType = ((IvmlTypeDescriptor)type).getIvmlType())) instanceof ContainerValue) {
            ContainerValue cValue = (ContainerValue)val;
            HashSet<Object> tmp = new HashSet<Object>(cValue.getElementSize());
            for (int v = 0; v < cValue.getElementSize(); ++v) {
                this.resolveAndAddValue(cValue.getElement(v), tmp);
            }
            if (!tmp.isEmpty()) {
                result = new SetSet<Object>(tmp, type);
            }
        }
        if (null == result) {
            result = new ArraySet<Object>(new Object[0], type);
        }
        return result;
    }

    private void resolveAndAddValue(Value value, java.util.Set<Object> result) {
        DecisionVariable dVar;
        IDecisionVariable decVar;
        AbstractVariable var;
        if (value instanceof ReferenceValue && (var = ((ReferenceValue)value).getValue()) != null && null != (decVar = this.configuration.getDecision(var)) && null != (dVar = this.findVariable(decVar))) {
            result.add(dVar);
        }
    }
}

