/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.UnmodifiableSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AbstractIvmlVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Attribute;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IVariableFilter;
import net.ssehub.easy.varModel.confModel.ContainerVariable;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;

public class DecisionVariable
extends AbstractIvmlVariable {
    @DefaultValue
    public static final Value DEFAULT = NullValue.INSTANCE;
    private Attribute[] attributes;

    DecisionVariable(Configuration cfg, IDecisionVariable variable, IVariableFilter filter) {
        super(cfg, variable, filter);
    }

    @Override
    protected void initializeAttributes() {
        if (null == this.attributes && this.origVariable.getAttributesCount() > 0) {
            ArrayList<Attribute> tmp = new ArrayList<Attribute>();
            for (int a = 0; a < this.origVariable.getAttributesCount(); ++a) {
                IDecisionVariable attribute = this.origVariable.getAttribute(a);
                if (!this.filter.isEnabled(attribute)) continue;
                tmp.add(new Attribute(this.getConfiguration(), attribute, this.filter));
            }
            this.attributes = new Attribute[tmp.size()];
            tmp.toArray(this.attributes);
        }
    }

    @Override
    @OperationMeta(returnGenerics={Attribute.class})
    public Set<Attribute> attributes() {
        this.initializeAttributes();
        return new UnmodifiableSet<Attribute>(new ArraySet<Attribute>(this.attributes, Attribute.class));
    }

    @Override
    @OperationMeta(returnGenerics={Attribute.class})
    public Set<Attribute> annotations() {
        return this.attributes();
    }

    @Override
    Attribute getAttribute(int index) {
        this.initializeAttributes();
        if (null == this.attributes) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[index];
    }

    @Override
    int getAttributeCount() {
        this.initializeAttributes();
        return null == this.attributes ? 0 : this.attributes.length;
    }

    @Conversion
    public static double convert2Real(DecisionVariable val) {
        return val.getRealValue();
    }

    @Conversion
    public static int convert2Integer(DecisionVariable val) {
        return val.getIntegerValue();
    }

    @Conversion
    public static boolean convert2Boolean(DecisionVariable val) {
        return val.getBooleanValue();
    }

    @Conversion
    public static String convert2String(DecisionVariable val) {
        return val.getStringValue();
    }

    @Conversion
    public static EnumValue convert2EnumValue(DecisionVariable val) {
        return val.getEnumValue();
    }

    @Conversion
    @OperationMeta(returnGenerics={DecisionVariable.class})
    public static Sequence<DecisionVariable> convert2Sequence(DecisionVariable val) {
        return val.variables();
    }

    @Override
    public String getName() {
        IDecisionVariable var = this.origVariable;
        while (var.getParent() instanceof ContainerVariable) {
            var = (ContainerVariable)var.getParent();
        }
        return var.getDeclaration().getName();
    }

    public boolean isTypeOf(TypeDescriptor<?> type) {
        return type.isSame(this.getType());
    }

    public boolean isKindOf(TypeDescriptor<?> type) {
        return type.isAssignableFrom(this.getType());
    }
}

