/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AbstractIvmlFieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Utils;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.Value;

public class IvmlAccessorFieldDescriptor
extends AbstractIvmlFieldDescriptor {
    public IvmlAccessorFieldDescriptor() {
    }

    IvmlAccessorFieldDescriptor(TypeDescriptor<?> declaringType, DecisionVariableDeclaration var, TypeRegistry registry) throws VilException {
        super(declaringType, var, registry);
    }

    @Override
    public Object getValue(Object owner) throws VilException {
        Object result;
        if (null == owner) {
            result = null;
        } else if (owner instanceof CompoundValue) {
            CompoundValue cValue = (CompoundValue)owner;
            Value val = cValue.getNestedValue(this.getName());
            result = null != val ? val.getValue() : null;
        } else {
            if (Utils.isCompatibleToDecisionVariable(owner) != IMetaOperation.CompatibilityResult.COMPATIBLE) {
                throw new VilException("incompatible arguments", 40002);
            }
            DecisionVariable ownerVar = (DecisionVariable)owner;
            DecisionVariable tmp = ownerVar.getByName(this.getName());
            if (null == tmp) {
                result = null;
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Configuration field " + this.getName() + " not accessible by name (omitted frozen?)");
            } else if (((TypeDescriptor)this.getType()).isCollection()) {
                IDatatype type = tmp.getDecisionVariable().getDeclaration().getType();
                result = Set.TYPE.isAssignableFrom(type = DerivedDatatype.resolveToBasis(type)) ? tmp.variablesSet() : tmp.variables();
            } else {
                result = this.getSpecificBaseValue(tmp);
                if (null == result && tmp.isConfigured()) {
                    result = tmp;
                }
            }
        }
        return result;
    }

    @Override
    public void setValue(Object owner, Object value) throws VilException {
        if (null != owner) {
            if (Utils.isCompatibleToDecisionVariable(owner) != IMetaOperation.CompatibilityResult.COMPATIBLE) {
                throw new VilException("incompatible arguments", 40002);
            }
            DecisionVariable tmp = ((DecisionVariable)owner).getByName(this.getName());
            if (null == tmp) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Configuration field " + this.getName() + " not accessible by name (omitted frozen?)");
            } else {
                tmp.setValue(value);
            }
        }
    }

    @Override
    public Object getMetaValue(Object owner) throws VilException {
        if (Utils.isCompatibleToDecisionVariable(owner) != IMetaOperation.CompatibilityResult.COMPATIBLE) {
            throw new VilException("incompatible arguments", 40002);
        }
        return ((DecisionVariable)owner).getByName(this.getName());
    }
}

