/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AbstractIvmlFieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Utils;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Set;

public class IvmlConfigurationFieldDescriptor
extends AbstractIvmlFieldDescriptor {
    IvmlConfigurationFieldDescriptor() {
    }

    protected IvmlConfigurationFieldDescriptor(TypeDescriptor<?> declaringType, AbstractVariable var, TypeRegistry registry) throws VilException {
        super(declaringType, var, registry);
    }

    @Override
    public Object getValue(Object owner) throws VilException {
        Collection<DecisionVariable> result;
        if (null == owner) {
            result = null;
        } else {
            if (Utils.isCompatible(owner, Configuration.class) != IMetaOperation.CompatibilityResult.COMPATIBLE) {
                throw new VilException("incompatible arguments", 40002);
            }
            Configuration cfg = (Configuration)owner;
            DecisionVariable tmp = cfg.getByName(this.getName());
            if (null == tmp) {
                tmp = cfg.getByName(this.getVariable().getQualifiedName());
            }
            if (null == tmp) {
                result = null;
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Configuration field " + this.getName() + " not accessible via by name (omitted frozen?)");
            } else if (((TypeDescriptor)this.getType()).isCollection()) {
                IDatatype type = tmp.getDecisionVariable().getDeclaration().getType();
                result = Set.TYPE.isAssignableFrom(type = DerivedDatatype.resolveToBasis(type)) ? tmp.variablesSet() : tmp.variables();
            } else {
                result = this.getSpecificBaseValue(tmp);
                if (null == result) {
                    result = tmp;
                }
            }
        }
        return result;
    }

    @Override
    public void setValue(Object owner, Object value) throws VilException {
        if (null != owner) {
            if (Utils.isCompatible(owner, Configuration.class) != IMetaOperation.CompatibilityResult.COMPATIBLE) {
                throw new VilException("incompatible arguments", 40002);
            }
            DecisionVariable tmp = ((Configuration)owner).getByName(this.getName());
            if (null != tmp) {
                tmp.setValue(value);
            } else {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Configuration field " + this.getName() + " not accessible via by name (omitted frozen?)");
            }
        }
    }

    @Override
    public Object getMetaValue(Object owner) throws VilException {
        if (Utils.isCompatible(owner, Configuration.class) != IMetaOperation.CompatibilityResult.COMPATIBLE) {
            throw new VilException("incompatible arguments", 40002);
        }
        Configuration cfg = (Configuration)owner;
        DecisionVariable result = cfg.getByName(this.getName());
        if (null == result) {
            result = cfg.getByName(this.getVariable().getQualifiedName());
        }
        return result;
    }
}

