/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import net.ssehub.easy.instantiation.core.model.common.ExecutionLocal;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.IResolvable;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.FakeTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.VariableValueMapping;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;

public abstract class IvmlElement
implements IVilType,
IResolvable,
IStringValueProvider {
    protected abstract void initializeAttributes();

    protected abstract void initializeNested();

    @Override
    public abstract String getName();

    public abstract String getQualifiedName();

    public abstract TypeDescriptor<?> getType();

    public abstract String getTypeName();

    public abstract String getQualifiedType();

    abstract IvmlElement getAttribute(int var1);

    abstract int getAttributeCount();

    public IvmlElement getAttribute(String name) {
        this.initializeAttributes();
        IvmlElement result = null;
        for (int a = 0; null == result && a < this.getAttributeCount(); ++a) {
            IvmlElement tmp = this.getAttribute(a);
            if (!tmp.getName().equals(name) && !tmp.getQualifiedName().equals(name)) continue;
            result = tmp;
        }
        return result;
    }

    public IvmlElement getAttribute(IvmlElement element) {
        return this.getAttribute(element.getQualifiedName());
    }

    public IvmlElement getAnnotation(String name) {
        return this.getAttribute(name);
    }

    public IvmlElement getAnnotation(IvmlElement element) {
        return this.getAttribute(element.getQualifiedName());
    }

    public boolean isValid() {
        return VariableValueMapping.getInstance().isValid(this);
    }

    public boolean isEnacting() {
        return VariableValueMapping.getInstance().isEnacting(this);
    }

    public boolean isNull() {
        return this.getValue() == TypeRegistry.NULL;
    }

    public abstract Object getValue();

    public abstract String getStringValue();

    public abstract Integer getIntegerValue();

    public abstract Double getRealValue();

    public abstract Boolean getBooleanValue();

    public abstract EnumValue getEnumValue();

    public abstract IvmlElement getElement(String var1);

    protected IvmlElement search(String name, IvmlElement[] elements) {
        IvmlElement result = null;
        if (null != elements) {
            for (int e = 0; null == result && e < elements.length; ++e) {
                result = this.checkElement(name, elements[e]);
            }
        }
        return result;
    }

    protected IvmlElement checkElement(String name, IvmlElement element) {
        IvmlElement result = null;
        if (element.getName().equals(name)) {
            result = element;
        } else if (element.getName().startsWith(name)) {
            result = element.getElement(name);
        }
        return result;
    }

    @OperationMeta(name={"=="}, opType=OperationType.INFIX)
    public static boolean equals(IvmlElement i1, IvmlElement i2) {
        return i1 == null && i2 == null || i1 != null && i1.equals(i2);
    }

    @OperationMeta(name={"=="}, opType=OperationType.INFIX)
    public static boolean equals2(IvmlElement i1, Object i2) {
        boolean result;
        if (i1 != null && i2 == TypeRegistry.NULL) {
            result = i1.isNull();
        } else {
            Object o1 = i1;
            if (null != i1 && !(i2 instanceof IvmlElement)) {
                o1 = i1.getValue();
            }
            result = o1 == null && i2 == null || o1 != null && o1.equals(i2);
        }
        return result;
    }

    @OperationMeta(name={"!=", "<>"}, opType=OperationType.INFIX)
    public static boolean unequals(IvmlElement i1, IvmlElement i2) {
        return i1 == null && i2 == null || i1 != null && !i1.equals(i2);
    }

    @OperationMeta(name={"!=", "<>"}, opType=OperationType.INFIX)
    public static boolean unequals2(IvmlElement i1, Object i2) {
        boolean result = i1 != null && i2 == TypeRegistry.NULL ? !i1.isNull() : i1 == null && i2 == null || i1 != null && !i1.equals(i2);
        return result;
    }

    @Override
    @Invisible
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getQualifiedName();
    }

    @Invisible
    public String getInstanceName() {
        return this.getQualifiedName();
    }

    static TypeDescriptor<?> getTypeDescriptor(IDatatype type) {
        TypeRegistry registry = ExecutionLocal.getCurrentTypeRegistry();
        FakeTypeDescriptor result = registry.getTypeOrFallback(type);
        if (null == result && !registry.hasTypeResolver(IvmlTypeResolver.class)) {
            try {
                TypeDescriptor<?> tmp = registry.getType(Reference.dereference(type));
                result = new FakeTypeDescriptor(registry, type.getName(), tmp);
                registry.registerFallbackType(type, result);
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        return result;
    }
}

