/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlOperationDescriptor;

public class IvmlOrderedEnumComparisonOperationDescriptor
extends IvmlOperationDescriptor {
    private OperationKind operation;

    IvmlOrderedEnumComparisonOperationDescriptor() {
        super(null, null, false);
    }

    IvmlOrderedEnumComparisonOperationDescriptor(TypeDescriptor<?> declaringType, OperationKind operation) {
        super(declaringType, operation.getOperationName(), false);
        this.operation = null == operation ? OperationKind.LESS : operation;
        ArrayList parameters = new ArrayList();
        parameters.add(declaringType);
        parameters.add(declaringType);
        this.setParameters(parameters, false, false);
        this.setReturnType(TypeRegistry.booleanType());
        this.setCharacteristics(OperationType.INFIX, OperationDescriptor.AliasType.NONE, false, operation.getOperationName());
    }

    @Override
    public IMetaOperation.CompatibilityResult isCompatible(Class<?> retType, Object ... params) {
        return IMetaOperation.CompatibilityResult.COMPATIBLE;
    }

    @Override
    public Object invoke(Object ... args) throws VilException {
        Boolean result = null;
        if (null != args && args.length == 2) {
            EnumValue a0 = IvmlOrderedEnumComparisonOperationDescriptor.convertArgument(args[0], EnumValue.class);
            EnumValue a1 = IvmlOrderedEnumComparisonOperationDescriptor.convertArgument(args[1], EnumValue.class);
            if (a0 != null && a1 != null) {
                int o0 = a0.getOrdinal();
                int o1 = a1.getOrdinal();
                switch (this.operation) {
                    case LESS: {
                        result = o0 < o1;
                        break;
                    }
                    case LESS_EQUALS: {
                        result = o0 <= o1;
                        break;
                    }
                    case GREATER: {
                        result = o0 > o1;
                        break;
                    }
                    case GREATER_EQUALS: {
                        result = o0 >= o1;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public static enum OperationKind {
        LESS("<"),
        LESS_EQUALS("<="),
        GREATER(">"),
        GREATER_EQUALS(">=");

        private String opName;

        private OperationKind(String opName) {
            this.opName = opName;
        }

        public String getOperationName() {
            return this.opName;
        }
    }
}

