/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.ExecutionLocal;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualTypeAssignmentProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.AbstractIvmlTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Attribute;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlAccessorFieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlAnnotationFieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlConstructorOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlConversionOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlOrderedEnumComparisonOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlOrderedEnumMinMaxOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlSequenceConversionOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlSetConversionOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlToStringConversionOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Utils;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.Value;

public class IvmlTypeDescriptor
extends AbstractIvmlTypeDescriptor
implements IActualTypeAssignmentProvider {
    private TypeDescriptor<?> baseType;
    private IDatatype type;

    IvmlTypeDescriptor() throws VilException {
    }

    IvmlTypeDescriptor(Project project, IDatatype ivmlType, IvmlTypeResolver resolver) throws VilException {
        super(ivmlType, resolver);
        this.type = ivmlType;
    }

    void resolve(Project project, IDatatype ivmlType, java.util.Set<net.ssehub.easy.varModel.model.Attribute> declaredAttributes) throws VilException {
        TypeRegistry registry = this.getTypeRegistry();
        HashMap<String, OperationDescriptor> operations = new HashMap<String, OperationDescriptor>();
        HashMap<String, FieldDescriptor> fields = new HashMap<String, FieldDescriptor>();
        this.addDecisionVariableOperations(operations);
        this.addComparisonOperations(ivmlType, operations);
        this.addAttributeFields(fields, ivmlType instanceof IModelElement ? (IModelElement)((Object)ivmlType) : project, registry);
        if (null != declaredAttributes) {
            for (net.ssehub.easy.varModel.model.Attribute att : declaredAttributes) {
                Utils.addField(new IvmlAnnotationFieldDescriptor(this, att, registry), fields);
            }
        }
        this.addCompoundOperations(ivmlType, operations, fields);
        this.addEnumOperations(ivmlType, operations);
        if (Compound.TYPE.isAssignableFrom(ivmlType) || Container.TYPE.isAssignableFrom(ivmlType)) {
            Utils.addOperation(new IvmlConstructorOperationDescriptor(this, ivmlType), operations);
        }
        this.setOperations(operations.values());
        this.setFields(fields.values());
        ArrayList<OperationDescriptor> conversions = new ArrayList<OperationDescriptor>();
        conversions.add(new IvmlConversionOperationDescriptor(this));
        conversions.add(new IvmlToStringConversionOperationDescriptor(this));
        this.addDerivedTypeConversions(ivmlType, conversions);
        this.addConversionOperations(ivmlType, conversions);
        this.setConversions(conversions);
    }

    private void addCompoundOperations(IDatatype ivmlType, Map<String, OperationDescriptor> operations, Map<String, FieldDescriptor> fields) throws VilException {
        if (ivmlType instanceof Compound) {
            TypeRegistry registry = this.getTypeRegistry();
            Compound comp = (Compound)ivmlType;
            this.addElements(comp, registry, fields);
            AbstractIvmlTypeDescriptor[] refs = new AbstractIvmlTypeDescriptor[comp.getRefinesCount()];
            for (int r = 0; r < comp.getRefinesCount(); ++r) {
                Compound refines = comp.getRefines(r);
                TypeDescriptor<?> tmp = registry.getType(refines);
                if (!(tmp instanceof IvmlTypeDescriptor)) continue;
                IvmlTypeDescriptor refinesDesc = (IvmlTypeDescriptor)tmp;
                refs[r] = refinesDesc;
                for (int f = 0; f < refinesDesc.getFieldCount(); ++f) {
                    FieldDescriptor fi = refinesDesc.getField(f);
                    if (!(fi instanceof IvmlAccessorFieldDescriptor)) continue;
                    Utils.addField(fi, fields);
                }
            }
            this.setRefines(refs);
        }
    }

    private void addEnumOperations(IDatatype ivmlType, Map<String, OperationDescriptor> operations) {
        if (ivmlType instanceof OrderedEnum) {
            for (IvmlOrderedEnumMinMaxOperationDescriptor.OperationKind operationKind : IvmlOrderedEnumMinMaxOperationDescriptor.OperationKind.values()) {
                Utils.addOperation(new IvmlOrderedEnumMinMaxOperationDescriptor(this, operationKind), operations);
            }
            for (Enum enum_ : IvmlOrderedEnumComparisonOperationDescriptor.OperationKind.values()) {
                Utils.addOperation(new IvmlOrderedEnumComparisonOperationDescriptor(this, (IvmlOrderedEnumComparisonOperationDescriptor.OperationKind)enum_), operations);
            }
        }
    }

    private void addDerivedTypeConversions(IDatatype ivmlType, List<OperationDescriptor> conversions) {
        if (DerivedDatatype.TYPE.isAssignableFrom(ivmlType)) {
            TypeRegistry registry = this.getTypeRegistry();
            IDatatype baseType = DerivedDatatype.resolveToBasis(ivmlType);
            TypeDescriptor<?> vilBaseType = registry.getType(baseType.getName());
            if (net.ssehub.easy.varModel.model.datatypes.Set.TYPE.isAssignableFrom(baseType)) {
                IvmlSetConversionOperationDescriptor desc = new IvmlSetConversionOperationDescriptor(this, vilBaseType);
                conversions.add(desc);
                this.baseType = desc.getReturnType();
            } else if (net.ssehub.easy.varModel.model.datatypes.Sequence.TYPE.isAssignableFrom(baseType)) {
                IvmlSequenceConversionOperationDescriptor desc = new IvmlSequenceConversionOperationDescriptor(this, vilBaseType);
                conversions.add(desc);
                this.baseType = desc.getReturnType();
            }
        }
    }

    private void addElements(IDecisionVariableContainer container, TypeRegistry registry, Map<String, FieldDescriptor> fields) throws VilException {
        for (int e = 0; e < container.getElementCount(); ++e) {
            DecisionVariableDeclaration decl = container.getElement(e);
            Utils.addField(new IvmlAccessorFieldDescriptor(this, decl, registry), fields);
        }
        for (int a = 0; a < container.getAssignmentCount(); ++a) {
            this.addElements(container.getAssignment(a), registry, fields);
        }
    }

    @Override
    public IMetaType getBaseType() {
        return this.baseType;
    }

    @Override
    public boolean isAssignableFrom(TypeDescriptor<?> desc) {
        boolean assignable;
        boolean bl = assignable = desc == this || IvmlTypes.decisionVariableType() == desc;
        if (!assignable && desc instanceof AbstractIvmlTypeDescriptor) {
            assignable = this.isAssignableFrom((AbstractIvmlTypeDescriptor)desc);
        }
        if (!assignable && null != this.baseType) {
            assignable = this.baseType.isAssignableFrom(desc);
        }
        return assignable;
    }

    private boolean isAssignableFrom(AbstractIvmlTypeDescriptor other) {
        boolean assignable = this.isEqual(other, this);
        for (int r = 0; !assignable && r < other.getRefinesCount(); ++r) {
            assignable = this.isAssignableFrom(other.getRefines(r));
        }
        return assignable;
    }

    @Override
    public boolean isSet() {
        return net.ssehub.easy.varModel.model.datatypes.Set.TYPE.isAssignableFrom(this.type);
    }

    @Override
    public boolean isSequence() {
        return net.ssehub.easy.varModel.model.datatypes.Sequence.TYPE.isAssignableFrom(this.type);
    }

    @Override
    protected IDatatype getIvmlType() {
        return this.type;
    }

    @Override
    @Invisible
    public boolean isAssignableFrom(IMetaType type1, IMetaType type2) {
        return IvmlTypes.decisionVariableType() == type1 && type2 instanceof IvmlTypeDescriptor;
    }

    @Override
    public boolean isInstance(Object object) {
        boolean isInstance = false;
        IDatatype objectType = this.getDatatype(object);
        if (null != objectType && !(isInstance = this.type.isAssignableFrom(objectType)) && null != this.baseType) {
            IDatatype bType = DerivedDatatype.resolveToBasis(this.type);
            isInstance = objectType.isAssignableFrom(bType);
        }
        return isInstance;
    }

    private IDatatype getDatatype(Object object) {
        IDatatype objectType = null;
        if (object instanceof DecisionVariable) {
            DecisionVariable var = (DecisionVariable)object;
            Value val = var.getDecisionVariable().getValue();
            objectType = null != val ? val.getType() : var.getDecisionVariable().getDeclaration().getType();
        } else if (object instanceof Attribute) {
            Attribute att = (Attribute)object;
            objectType = att.getDecisionVariable().getDeclaration().getType();
        } else if (object instanceof EnumValue) {
            objectType = ((EnumValue)object).getDatatype();
        } else if (object instanceof Set) {
            objectType = net.ssehub.easy.varModel.model.datatypes.Set.TYPE;
        } else if (object instanceof Sequence) {
            objectType = net.ssehub.easy.varModel.model.datatypes.Sequence.TYPE;
        } else if (object instanceof Integer) {
            objectType = IntegerType.TYPE;
        } else if (object instanceof Double) {
            objectType = RealType.TYPE;
        } else if (object instanceof String) {
            objectType = StringType.TYPE;
        } else if (object instanceof Boolean) {
            objectType = BooleanType.TYPE;
        }
        return objectType;
    }

    @Override
    public boolean isSameType(Object object) {
        boolean isSame = false;
        IDatatype objectType = this.getDatatype(object);
        if (null != objectType && !(isSame = TypeQueries.sameTypes(this.type, objectType)) && null != this.baseType) {
            IDatatype bType = DerivedDatatype.resolveToBasis(this.type);
            isSame = TypeQueries.sameTypes(objectType, bType);
        }
        return isSame;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public OperationDescriptor addPlaceholderOperation(String name, int parameterCount, boolean acceptsNamedParameters) {
        return null;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isInstantiator() {
        return false;
    }

    @Override
    public boolean checkConversion(IMetaType param, IMetaOperation conversion) {
        boolean result = true;
        if (param instanceof IvmlTypeDescriptor) {
            IMetaType type = conversion.getReturnType();
            if (IvmlTypes.decisionVariableType() == type || IvmlTypes.ivmlElement() == type) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public Set<?> allInstances() {
        Set<?> result = null;
        Configuration cfg = ExecutionLocal.getCurrentConfiguration();
        if (null != cfg) {
            result = cfg.allInstances(this);
        }
        return result;
    }
}

