/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IDirectTypeRegistryAccess;
import net.ssehub.easy.instantiation.core.model.vilTypes.ITypeResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.FakeTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlProjectTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeDescriptor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class IvmlTypeResolver
implements ITypeResolver {
    private static final boolean STATIC = true;
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(IvmlTypeResolver.class, "net.ssehub.easy.instantiation.core");
    private IDirectTypeRegistryAccess access;
    private Project project;
    private TypeRegistry typeRegistry;
    private Map<IDatatype, Set<Attribute>> attributes = new HashMap<IDatatype, Set<Attribute>>();
    private Map<IDatatype, TypeDescriptor<?>> ivmlMap = new HashMap();

    public IvmlTypeResolver(Project project, TypeRegistry typeRegistry) {
        this.project = project;
        this.typeRegistry = typeRegistry;
        int eCount = project.getElementCount();
        for (int e = 0; e < eCount; ++e) {
            ContainableModelElement elt = project.getElement(e);
            if (!(elt instanceof DecisionVariableDeclaration)) continue;
            this.cacheVariable((DecisionVariableDeclaration)elt);
        }
    }

    private void cacheVariable(DecisionVariableDeclaration var) {
        IDatatype type = var.getType();
        int aCount = var.getAttributesCount();
        if (aCount > 0) {
            Set<Attribute> aList = this.attributes.get(type);
            if (null == aList) {
                aList = new HashSet<Attribute>();
                this.attributes.put(type, aList);
            }
            for (int a = 0; a < aCount; ++a) {
                aList.add(var.getAttribute(a));
            }
        }
    }

    @Override
    public TypeDescriptor<?> resolveType(String name, boolean addIfMissing) {
        Exception exception = null;
        TypeDescriptor result = this.access.get(name);
        if (null == result) {
            try {
                IDatatype type = ModelQuery.findType(this.project, name, null);
                if (null != type) {
                    result = this.obtainType(type);
                } else {
                    Project tmp = ModelQuery.findProject(this.project, name);
                    if (null != tmp) {
                        result = new IvmlProjectTypeDescriptor(tmp, this);
                        this.ivmlMap.put(tmp.getType(), result);
                    }
                }
            }
            catch (ModelQueryException e) {
                exception = e;
            }
            catch (VilException e) {
                exception = e;
            }
        }
        if (null == result && addIfMissing) {
            try {
                if (null == Advice.getIvmlElement(this.project, name)) {
                    result = new FakeTypeDescriptor(this.typeRegistry, name);
                    this.addType(name, result);
                }
            }
            catch (VilException e) {
                exception = e;
            }
        }
        if (null == result && null != exception) {
            LOGGER.debug(exception.getMessage());
        }
        return result;
    }

    TypeDescriptor<?> obtainType(IDatatype type) throws VilException {
        IvmlTypeDescriptor result = null;
        if (null != type) {
            result = this.access.get(type.getQualifiedName());
            if (null == result && null != (result = this.access.get(type.getName())) && !result.getQualifiedName().equals(type.getQualifiedName())) {
                result = null;
            }
            if (null == result) {
                IvmlTypeDescriptor itd = new IvmlTypeDescriptor(this.project, type, this);
                this.ivmlMap.put(type, itd);
                itd.resolve(this.project, type, this.attributes.get(type));
                result = itd;
            }
        }
        return result;
    }

    void addType(String name, TypeDescriptor<?> type) {
        if (!this.isKnown(name)) {
            this.access.add(name, type);
        }
    }

    @Override
    public TypeDescriptor<? extends IVilType> resolveInstantiator(String name) {
        return null;
    }

    public boolean isKnown(String name) {
        return this.access.contains(name);
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public void setRegistryAccess(IDirectTypeRegistryAccess access) {
        this.access = access;
        int eCount = this.project.getElementCount();
        for (int e = 0; e < eCount; ++e) {
            ContainableModelElement elt = this.project.getElement(e);
            if (!(elt instanceof CustomDatatype)) continue;
            try {
                this.obtainType((CustomDatatype)elt);
                continue;
            }
            catch (VilException ex) {
                LOGGER.exception(ex);
            }
        }
    }

    @Override
    public TypeDescriptor<?> resolveType(IDatatype type) {
        TypeDescriptor<?> result = this.ivmlMap.get(type);
        if (null == result) {
            try {
                result = this.obtainType(type);
            }
            catch (VilException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return result;
    }
}

