/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IConfigurationFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;

class NameRegExFilter
implements IConfigurationFilter {
    private DataType type;
    private IConfigurationFilter further;
    private Pattern pattern;

    public NameRegExFilter(String pattern, DataType type) throws VilException {
        this(pattern, type, null);
    }

    public NameRegExFilter(String pattern, DataType type, IConfigurationFilter further) throws VilException {
        this.type = type;
        this.further = further;
        try {
            this.pattern = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new VilException(e.getMessage(), 30009);
        }
    }

    private boolean match(String string) {
        return this.pattern.matcher(string).matches();
    }

    @Override
    public boolean include(IvmlElement element) {
        return this.include(element, this.type);
    }

    private boolean checkFurther(IvmlElement element, boolean result) {
        if (result && null != this.further) {
            result = this.further.include(element);
        }
        return result;
    }

    private boolean include(IvmlElement element, DataType type) {
        boolean result;
        switch (type) {
            case NAME: {
                result = this.checkFurther(element, this.match(element.getName()) || this.match(element.getQualifiedName()));
                break;
            }
            case TYPE: {
                result = this.checkFurther(element, this.match(element.getTypeName()) || this.match(element.getQualifiedType()));
                break;
            }
            case ATTRIBUTE: {
                result = false;
                int count = element.getAttributeCount();
                for (int a = 0; !result && a < count; ++a) {
                    result = this.include(element.getAttribute(a), DataType.NAME);
                }
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static enum DataType {
        NAME,
        TYPE,
        ATTRIBUTE;

    }
}

