/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IConfigurationFilter;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.varModel.model.Project;

class ProjectFilter
implements IConfigurationFilter {
    private Project project;
    private boolean considerImports;
    private IConfigurationFilter further;

    public ProjectFilter(Project project, boolean considerImports) {
        this(project, considerImports, null);
    }

    public ProjectFilter(Project project, boolean considerImports, IConfigurationFilter further) {
        this.further = further;
        this.project = project;
        this.considerImports = considerImports;
    }

    private boolean include(IvmlElement element, Project project, Set<Project> done) {
        boolean result;
        if (null == project) {
            result = false;
        } else {
            result = project.containsByName(element.getQualifiedName());
            if (!result && this.considerImports && !done.contains(project)) {
                done.add(project);
                for (int i = 0; !result && i < project.getImportsCount(); ++i) {
                    result = this.include(element, (Project)project.getImport(i).getResolved(), done);
                }
            }
        }
        return result;
    }

    @Override
    public boolean include(IvmlElement element) {
        return this.checkFurther(element, this.include(element, this.project, new HashSet<Project>()));
    }

    private boolean checkFurther(IvmlElement element, boolean result) {
        if (result && null != this.further) {
            result = this.further.include(element);
        }
        return result;
    }
}

