/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes.configuration;

import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;

public class Utils {
    private Utils() {
    }

    public static IvmlDeclaration getAttributeDeclaration(Configuration configuration, String name) {
        IvmlDeclaration result = null;
        Project project = configuration.getConfiguration().getProject();
        for (int a = 0; null == result && a < project.getAttributesCount(); ++a) {
            Attribute var = project.getAttribute(a);
            if (!var.getName().equals(name) && !var.getQualifiedName().equals(name)) continue;
            result = new IvmlDeclaration(var);
        }
        return result;
    }

    protected static TypeDescriptor<?> determineReturnType(IDatatype type, TypeRegistry registry, boolean specific) throws VilException {
        TypeDescriptor<Collection<?>> result;
        if (Set.TYPE.isAssignableFrom(type = DerivedDatatype.resolveToBasis(type))) {
            result = TypeRegistry.getSetType(Utils.determineGenerics(type, registry, specific));
        } else if (Sequence.TYPE.isAssignableFrom(type)) {
            result = TypeRegistry.getSequenceType(Utils.determineGenerics(type, registry, specific));
        } else {
            result = null;
            if (specific && null != registry && !ConstraintType.TYPE.isAssignableFrom(type)) {
                result = registry.getType(Reference.dereference(type));
            }
            if (null == result) {
                result = IvmlTypes.decisionVariableType();
            }
        }
        return result;
    }

    protected static TypeDescriptor<?>[] determineGenerics(IDatatype type, TypeRegistry registry, boolean specific) throws VilException {
        TypeDescriptor<?>[] generics = TypeDescriptor.createArray(type.getGenericTypeCount());
        for (int t = 0; t < generics.length; ++t) {
            generics[t] = Utils.determineReturnType(type.getGenericType(t), registry, specific);
        }
        return generics;
    }

    protected static IMetaOperation.CompatibilityResult isCompatibleToDecisionVariable(Object param) {
        return Utils.isCompatible(param, DecisionVariable.class);
    }

    protected static IMetaOperation.CompatibilityResult isCompatibleToDecisionVariable(Object[] params) {
        return Utils.isCompatible(params, DecisionVariable.class);
    }

    protected static IMetaOperation.CompatibilityResult isCompatible(Object[] params, Class<?> paramType) {
        IMetaOperation.CompatibilityResult result = null != params && params.length == 1 ? Utils.isCompatible(params[0], paramType) : IMetaOperation.CompatibilityResult.INCOMPATIBLE;
        return result;
    }

    protected static IMetaOperation.CompatibilityResult isCompatible(Object param, Class<?> paramType) {
        IMetaOperation.CompatibilityResult result = paramType.isInstance(param) ? IMetaOperation.CompatibilityResult.COMPATIBLE : IMetaOperation.CompatibilityResult.INCOMPATIBLE;
        return result;
    }

    protected static void addOperation(OperationDescriptor operation, Map<String, OperationDescriptor> operations) {
        String sig = operation.getSignature();
        if (!operations.containsKey(sig)) {
            operations.put(sig, operation);
        }
    }

    protected static void addField(FieldDescriptor field, Map<String, FieldDescriptor> fields) {
        String sig = field.getName();
        if (!fields.containsKey(sig)) {
            fields.put(sig, field);
        }
    }
}

