/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.artifacts;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class InvocationRemovalVisitor
extends ASTVisitor {
    private static EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(InvocationRemovalVisitor.class, "net.ssehub.easy.instantiation.java");
    private MethodDeclaration methodDeclaration;
    private IMethodBinding methodDeclarationBinding;
    private boolean hasBeenDeleted;
    private Object replacement;

    public InvocationRemovalVisitor(MethodDeclaration methodDeclaration, Object replacement) {
        this.methodDeclaration = methodDeclaration;
        this.methodDeclarationBinding = methodDeclaration.resolveBinding();
        this.replacement = replacement;
        this.hasBeenDeleted = false;
    }

    public boolean visit(MethodInvocation node) {
        IMethodBinding iMethod = node.resolveMethodBinding();
        IMethodBinding methodDeclarationCandidate = iMethod.getMethodDeclaration();
        if (this.check(methodDeclarationCandidate)) {
            if (null != node.getExpression()) {
                node.getParent().delete();
            } else if (null != this.replacement) {
                if (node.getParent().getNodeType() == 59) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)node.getParent();
                    StringLiteral expression = null;
                    Type type = this.methodDeclaration.getReturnType2();
                    int exprType = this.determineType(type);
                    switch (exprType) {
                        case 34: {
                            expression = fragment.getAST().newNumberLiteral(String.valueOf(this.replacement));
                            break;
                        }
                        case 45: {
                            expression = fragment.getAST().newStringLiteral();
                            expression.setLiteralValue(String.valueOf(this.replacement));
                            break;
                        }
                        case 9: {
                            expression = fragment.getAST().newBooleanLiteral(Boolean.valueOf(this.replacement.toString()).booleanValue());
                            break;
                        }
                        case 13: {
                            expression = fragment.getAST().newCharacterLiteral();
                            String string = String.valueOf(this.replacement);
                            if (string.length() != 1) {
                                logger.warn(string + " contains more then one character. Cutting the string of at " + string.charAt(0));
                            }
                            char c = string.charAt(0);
                            ((CharacterLiteral)expression).setCharValue(Character.valueOf(c).charValue());
                            break;
                        }
                        case 33: {
                            expression = fragment.getAST().newNullLiteral();
                            break;
                        }
                        case 57: {
                            expression = fragment.getAST().newTypeLiteral();
                            break;
                        }
                        default: {
                            logger.error("Type '" + type + "' not supported yet...");
                        }
                    }
                    if (expression != null) {
                        fragment.setInitializer((Expression)expression);
                    }
                }
            } else {
                node.delete();
            }
            this.hasBeenDeleted = true;
        }
        return false;
    }

    private int determineType(Type type) {
        int expressionType = -1;
        if (type.isPrimitiveType()) {
            PrimitiveType prim = (PrimitiveType)type;
            PrimitiveType.Code code = prim.getPrimitiveTypeCode();
            if (code.equals(PrimitiveType.INT) | code.equals(PrimitiveType.DOUBLE) | code.equals(PrimitiveType.FLOAT) | code.equals(PrimitiveType.LONG)) {
                expressionType = 34;
            } else if (code.equals(PrimitiveType.BOOLEAN)) {
                expressionType = 9;
            } else if (code.equals(PrimitiveType.CHAR)) {
                expressionType = 13;
            }
        }
        if (type.isSimpleType()) {
            SimpleType simple = (SimpleType)type;
            String simpleTypeName = simple.getName().getFullyQualifiedName();
            expressionType = simpleTypeName.equals("String") ? 45 : (simpleTypeName.equals("Double") | simpleTypeName.equals("Long") | simpleTypeName.equals("Float") ? 34 : (simpleTypeName.equals("Boolean") ? 9 : 33));
        }
        return expressionType;
    }

    private boolean check(IMethodBinding candidate) {
        boolean result = null != candidate;
        result = result && this.methodDeclarationBinding.getName().equals(candidate.getName());
        return result;
    }

    public boolean hasBeenDeleted() {
        return this.hasBeenDeleted;
    }
}

