/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.artifacts;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactVisitor;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Binary;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoString;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.java.artifacts.IJavaParent;
import net.ssehub.easy.instantiation.java.artifacts.JavaFragmentArtifact;

public class JavaAnnotation
extends JavaFragmentArtifact {
    static final String DEFAULT_FIELD = "value";
    private String qualifiedName;
    private String simpleName;
    private Map<String, String> fields = new HashMap<String, String>();

    public JavaAnnotation(String name, Map<String, String> fields, IJavaParent parent) {
        super(parent);
        this.qualifiedName = name;
        this.simpleName = JavaAnnotation.toSimpleName(name);
        this.fields.putAll(fields);
    }

    @Invisible
    static String toSimpleName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos > 0 && pos < name.length() - 1) {
            name = name.substring(pos + 1, name.length());
        }
        return name;
    }

    @Override
    public void delete() throws VilException {
        this.getParent().deleteChild(this);
    }

    @Override
    public String getName() throws VilException {
        return this.simpleName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public void rename(String name) throws VilException {
    }

    @Override
    public Text getText() throws VilException {
        return Text.CONSTANT_EMPTY;
    }

    @Override
    public Binary getBinary() throws VilException {
        return Binary.CONSTANT_EMPTY;
    }

    @Override
    public void accept(IArtifactVisitor visitor) {
        visitor.visitFragmentArtifact(this);
    }

    @OperationMeta(returnGenerics={String.class})
    public Set<String> fields() {
        java.util.Set<String> fields = this.fields.keySet();
        return new ArraySet<String>(fields.toArray(new String[fields.size()]), PseudoString.class);
    }

    public String getAnnotationValue(String field) {
        return this.fields.get(field);
    }

    @Override
    @Invisible
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "annotation '" + this.getNameSafe() + "'";
    }
}

