/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.instantiators;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import net.ssehub.easy.instantiation.core.JavaUtilities;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.defaultInstantiators.AbstractFileInstantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;

@Instantiator(value="javac")
public class Javac
extends AbstractFileInstantiator {
    public static final String JAVA_HOME = "java.home";

    @OperationMeta(returnGenerics={FileArtifact.class})
    public static Set<FileArtifact> javac(Path source, Path target, Map<String, Object> other) throws VilException {
        return Javac.javac(source.selectAll(), target, other);
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public static Set<FileArtifact> javac(Collection<FileArtifact> source, Path target, Map<String, Object> other) throws VilException {
        long timestamp = PathUtils.normalizedTime();
        JavaCompiler compiler = Javac.getJavaCompiler();
        if (null == compiler) {
            throw new VilException("No Java compiler found. Are you running JRE?", 50502);
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        if (source.isEmpty()) {
            throw new VilException("No source files to compile", 30008);
        }
        ArrayList<File> files = new ArrayList<File>();
        for (FileArtifact fa : source) {
            files.add(fa.getPath().getAbsolutePath());
        }
        ArrayList<String> options = new ArrayList<String>();
        File targetPath = Javac.determineTargetPath(target);
        if (null != targetPath) {
            options.add("-d");
            options.add(targetPath.getAbsolutePath());
        }
        for (Map.Entry<String, Object> param : other.entrySet()) {
            options.add("-" + param.getKey());
            String val = Javac.toString(param.getValue());
            options.add(val);
        }
        StringWriter writer = new StringWriter();
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        boolean success = compiler.getTask(writer, fileManager, null, options, null, compilationUnits).call();
        try {
            fileManager.close();
        }
        catch (IOException e) {
            throw new VilException(e.getMessage(), 50001);
        }
        if (!success) {
            throw new VilException(writer.toString(), 30012);
        }
        ArrayList result = new ArrayList();
        FileUtils.ScanResult scanResult = new FileUtils.ScanResult(result);
        FileUtils.scan(targetPath.getAbsoluteFile(), target.getArtifactModel(), timestamp, scanResult, FileArtifact.class);
        scanResult.checkForException();
        return new ListSet<FileArtifact>(result, FileArtifact.class);
    }

    private static synchronized JavaCompiler getJavaCompiler() {
        String homeVariable;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (null == compiler && null != (homeVariable = JavaUtilities.JDK_PATH)) {
            String homeProperty = System.getProperty(JAVA_HOME);
            System.setProperty(JAVA_HOME, homeVariable);
            compiler = ToolProvider.getSystemJavaCompiler();
            System.setProperty(JAVA_HOME, homeProperty);
        }
        return compiler;
    }
}

