/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.mgmt;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.Executor;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.tracing.ConsoleTracerFactory;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public class EasyExecutor {
    private File base;
    private List<File> ivmlFolder = new ArrayList<File>();
    private File vilFolder;
    private File vtlFolder;
    private File vilSource;
    private File vilTarget;
    private String ivmlModelName;
    private String vilModelName;
    private String vilStartRuleName;
    private Map<String, Object> vilArguments;
    private Configuration cfg;
    private ProgressObserver observer = ProgressObserver.NO_OBSERVER;
    private ReasonerConfiguration rCfg;
    private TracerFactory tracerFactory = ConsoleTracerFactory.INSTANCE;
    private Logger logger = new Logger(){
        private EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(EasyExecutor.class, "net.ssehub.easy.producer.core");

        @Override
        public void warn(String text) {
            this.logger.warn(text);
        }

        @Override
        public void error(String text) {
            this.logger.error(text);
        }

        @Override
        public void info(String text) {
            this.logger.info(text);
        }
    };

    public EasyExecutor() {
        this.rCfg = new ReasonerConfiguration();
    }

    public EasyExecutor(File project, File modelFolder, String modelName) {
        this.base = project;
        this.ivmlFolder.add(modelFolder);
        this.ivmlModelName = modelName;
        this.vilFolder = modelFolder;
        this.vilModelName = modelName;
        this.vtlFolder = modelFolder;
        this.vilSource = project;
        this.vilTarget = project;
        this.rCfg = new ReasonerConfiguration();
    }

    public EasyExecutor setProjectBase(File base) {
        this.base = base;
        return this;
    }

    public EasyExecutor setIvmlFolder(File ivmlFolder) {
        if (this.ivmlFolder.size() > 0) {
            this.ivmlFolder.set(0, ivmlFolder);
        } else {
            this.ivmlFolder.add(ivmlFolder);
        }
        return this;
    }

    public EasyExecutor prependIvmlFolder(File ivmlFolder) {
        this.ivmlFolder.add(0, ivmlFolder);
        return this;
    }

    public EasyExecutor addIvmlFolder(File ivmlFolder) {
        this.ivmlFolder.add(ivmlFolder);
        return this;
    }

    public EasyExecutor setVilFolder(File vilFolder) {
        this.vilFolder = vilFolder;
        return this;
    }

    public EasyExecutor setVtlFolder(File vtlFolder) {
        this.vtlFolder = vtlFolder;
        return this;
    }

    public EasyExecutor setVilSource(File vilSource) {
        this.vilSource = vilSource;
        return this;
    }

    public EasyExecutor setVilTarget(File vilTarget) {
        this.vilTarget = vilTarget;
        return this;
    }

    public EasyExecutor setIvmlModelName(String ivmlModelName) {
        this.ivmlModelName = ivmlModelName;
        return this;
    }

    public EasyExecutor setVilModelName(String vilModelName) {
        this.vilModelName = vilModelName;
        return this;
    }

    public EasyExecutor addVilArgument(String name, Object value) {
        if (null == this.vilArguments) {
            this.vilArguments = new HashMap<String, Object>();
        }
        this.vilArguments.put(name, value);
        return this;
    }

    public EasyExecutor setVilStartRuleName(String vilStartRuleName) {
        this.vilStartRuleName = vilStartRuleName;
        return this;
    }

    public EasyExecutor setProgressObserver(ProgressObserver observer) {
        this.observer = observer;
        return this;
    }

    public EasyExecutor setReasonerConfiguration(ReasonerConfiguration rCfg) {
        this.rCfg = rCfg;
        return this;
    }

    public EasyExecutor setTracerFactory(TracerFactory tracerFactory) {
        this.tracerFactory = tracerFactory;
        return this;
    }

    public EasyExecutor setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public void setupLocations() throws ModelManagementException {
        ModelLocations.Location primary = null;
        for (File f : this.ivmlFolder) {
            this.logger.info("Setting IVML location " + f);
            ModelLocations.Location loc = VarModel.INSTANCE.locations().addLocation(f, this.observer);
            if (null == primary) {
                primary = loc;
                continue;
            }
            primary.addDependentLocation(loc);
        }
        this.logger.info("Setting VIL location " + this.vilFolder);
        BuildModel.INSTANCE.locations().addLocation(this.vilFolder, this.observer);
        this.logger.info("Setting VTL location " + this.vtlFolder);
        TemplateModel.INSTANCE.locations().addLocation(this.vtlFolder, this.observer);
    }

    public Configuration loadIvmlModel() throws ModelManagementException {
        this.logger.info("Loading model: " + this.ivmlModelName);
        List models = VarModel.INSTANCE.availableModels().getModelInfo(this.ivmlModelName);
        if (null != models && !models.isEmpty()) {
            ModelInfo prjInfo = models.get(0);
            Project prj = (Project)VarModel.INSTANCE.load(prjInfo);
            this.logger.info("Creating configuration instance: " + this.ivmlModelName);
            this.cfg = new Configuration(prj);
        } else {
            this.logger.error("No model found: " + this.ivmlModelName);
            for (File folder : this.ivmlFolder) {
                IModelLoader<Project> loader = VarModel.INSTANCE.loaders().getDefaultLoader();
                loader.scan(folder, new IModelLoader.IModelInfoHolder<Project>(){

                    @Override
                    public boolean isKnown(URI uri, IModelLoader<Project> loader) {
                        return false;
                    }

                    @Override
                    public void error(String message) {
                        EasyExecutor.this.logger.error(message);
                    }

                    @Override
                    public void addResult(ModelInfo<Project> toAdd) {
                    }
                });
            }
        }
        return this.cfg;
    }

    public ReasoningResult propagateOnIvmlModel() {
        if (null != this.cfg) {
            this.logger.info("Reasoning by propagation on model " + this.ivmlModelName);
            return ReasonerFrontend.getInstance().propagate(this.cfg, this.rCfg, this.observer);
        }
        throw new IllegalStateException("No IVML model loaded / configuration available.");
    }

    public void executeVil() throws ModelManagementException, VilException {
        if (null != this.cfg) {
            this.logger.info("Loading VIL script: " + this.vilModelName);
            List vil = BuildModel.INSTANCE.availableModels().getModelInfo(this.vilModelName);
            if (null != vil && !vil.isEmpty()) {
                ModelInfo vilInfo = vil.get(0);
                Script script = (Script)BuildModel.INSTANCE.load(vilInfo);
                if (null != this.tracerFactory) {
                    TracerFactory.setInstance(this.tracerFactory);
                }
                TracerFactory.registerProgressObserver(this.observer);
                this.logger.info("Executing VIL script: " + this.vilModelName);
                Executor exec = new Executor(script).addBase(this.base).addSource(this.vilSource).addConfiguration(this.cfg).addTarget(this.vilTarget);
                if (null != this.vilArguments) {
                    for (Map.Entry<String, Object> ent : this.vilArguments.entrySet()) {
                        exec.addCustomArgument(ent.getKey(), ent.getValue());
                    }
                }
                if (null != this.vilStartRuleName) {
                    exec.addStartRuleName(this.vilStartRuleName);
                }
                try {
                    exec.execute();
                }
                catch (VilException e) {
                    TracerFactory.unregisterProgressObserver(this.observer);
                }
            } else {
                this.logger.error("No VIL script found: " + this.vilModelName);
            }
        } else {
            throw new IllegalStateException("No IVML model loaded / configuration available.");
        }
    }

    public void discardLocations() throws ModelManagementException {
        this.logger.info("Discarding VTL location " + this.vtlFolder);
        TemplateModel.INSTANCE.locations().removeLocation(this.vtlFolder, this.observer);
        this.logger.info("Discarding VIL location " + this.vilFolder);
        BuildModel.INSTANCE.locations().removeLocation(this.vilFolder, this.observer);
        for (int f = this.ivmlFolder.size() - 1; f >= 0; --f) {
            File folder = this.ivmlFolder.get(f);
            this.logger.info("Discarding IVML location " + folder);
            VarModel.INSTANCE.locations().removeLocation(folder, this.observer);
        }
    }

    public void clearModels() {
        TemplateModel.INSTANCE.clear();
        BuildModel.INSTANCE.clear();
        VarModel.INSTANCE.clear();
    }

    public EasyExecutor execute() throws ModelManagementException, VilException {
        this.setupLocations();
        this.loadIvmlModel();
        this.propagateOnIvmlModel();
        this.executeVil();
        this.discardLocations();
        return this;
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public void setConfiguration(Configuration cfg) {
        this.cfg = cfg;
    }

    public static void printConfiguration(Configuration cfg) {
        EasyExecutor.printConfiguration(System.out, cfg);
    }

    public static void printConfiguration(PrintStream out, Configuration cfg) {
        Configuration.printConfig(out, cfg);
    }

    public void printConfiguration(PrintStream out) {
        EasyExecutor.printConfiguration(out, this.cfg);
    }

    public void printConfiguration() {
        this.printConfiguration(System.out);
    }

    public static void printReasoningMessages(ReasoningResult rRes, PrintStream out) {
        for (int m = 0; m < rRes.getMessageCount(); ++m) {
            Message msg = rRes.getMessage(m);
            out.println(msg.getDescription());
            out.println(msg.getConflictComments());
            out.println(msg.getConflictSuggestions());
        }
    }

    public static void printReasoningMessages(ReasoningResult rRes) {
        EasyExecutor.printReasoningMessages(rRes, System.out);
    }

    public static interface Logger {
        public void warn(String var1);

        public void error(String var1);

        public void info(String var1);
    }
}

