/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.mgmt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModelListener;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.dslCore.TopLevelModelAccessor;
import net.ssehub.easy.instantiation.core.model.IInstantiatorProject;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.producer.core.mgmt.IProductLineProjectListener;
import net.ssehub.easy.producer.core.mgmt.IVilExecutionListener;
import net.ssehub.easy.producer.core.mgmt.MemberController;
import net.ssehub.easy.producer.core.mgmt.MemberIterator;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.mgmt.VilExecutionThread;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.standard.EASyConfigFileImporter;
import net.ssehub.easy.producer.core.persistence.standard.Persistencer;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.producer.core.varMod.container.ScriptContainer;
import net.ssehub.easy.producer.core.varMod.container.SemanticErrorDescription;
import net.ssehub.easy.reasoning.core.frontend.IReasonerListener;
import net.ssehub.easy.reasoning.core.frontend.ReasoningProcess;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningOperation;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public class PLPInfo
implements IInstantiatorProject,
IModelListener<Script> {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(PLPInfo.class, "net.ssehub.easy.producer.core");
    private String uuid;
    private String name;
    private File projectLocation;
    private ProjectContainer varModel;
    private ScriptContainer mainBuildScript;
    private MemberController memberController;
    private List<IProductLineProjectListener> plpListeners;
    private ReasonerConfiguration reasonerConfig;
    private boolean saveDebugInformation;
    private VilExecutionThread vilExecutor;

    public PLPInfo(String uuid, String name, String version, File location) {
        this(uuid, name, version, PersistenceUtils.getLocationFile(location, Configuration.PathKind.IVML), location);
    }

    public PLPInfo(String uuid, String name, String version, File configLocation, File projectLocation) {
        this.uuid = uuid;
        this.name = name;
        this.projectLocation = projectLocation;
        this.plpListeners = new ArrayList<IProductLineProjectListener>();
        this.initModels();
        this.saveDebugInformation = false;
        this.vilExecutor = new VilExecutionThread(this);
    }

    public boolean getSaveDebugInformation() {
        return this.saveDebugInformation;
    }

    public void setSaveDebugInformation(boolean saveDebugInformation) {
        this.saveDebugInformation = saveDebugInformation;
    }

    @Override
    public String getProjectID() {
        return this.uuid;
    }

    @Override
    public String getProjectName() {
        return this.name;
    }

    public String getVersion() {
        String version = null;
        if (this.varModel != null) {
            version = this.varModel.getVersion().getVersion();
        }
        return version;
    }

    public void setMainModel(ModelInfo<Project> newMainModel) {
        this.varModel.setMainModel(newMainModel);
    }

    @Override
    public File getProjectLocation() {
        return this.projectLocation;
    }

    public void refresh() {
    }

    public ReasonerConfiguration getReasonerConfig() {
        return this.reasonerConfig;
    }

    public void setReasonerConfig(ReasonerConfiguration reasonerConfig) {
        this.reasonerConfig = reasonerConfig;
    }

    @Override
    public File getConfigLocation() {
        return PersistenceUtils.getLocationFile(this.getProjectLocation(), Configuration.PathKind.IVML);
    }

    public net.ssehub.easy.producer.core.persistence.Configuration getPathConfiguration() {
        return PersistenceUtils.getConfiguration(this.getProjectLocation());
    }

    public File getScriptLocation() {
        return PersistenceUtils.getLocationFile(this.getProjectLocation(), Configuration.PathKind.VIL);
    }

    public File getTemplateLocation() {
        return PersistenceUtils.getLocationFile(this.getProjectLocation(), Configuration.PathKind.VTL);
    }

    protected void setProject(ProjectContainer project) {
        this.varModel = project;
    }

    public Project getProject() {
        return (Project)this.varModel.getModel();
    }

    @Override
    public Configuration getConfiguration() {
        return this.varModel.getConfiguration();
    }

    private void initModels() {
        this.memberController = new MemberController(this.getProjectID());
        this.reasonerConfig = new ReasonerConfiguration();
    }

    public MemberController getMemberController() {
        return this.memberController;
    }

    @Override
    public List<File> getPredecessorLocations(boolean checkExisting) {
        ArrayList<File> result = new ArrayList<File>();
        for (PLPInfo info : this.getMemberController().getPredecessors()) {
            File loc = info.getProjectLocation();
            if (null == loc || checkExisting && (!checkExisting || !loc.exists())) continue;
            result.add(loc);
        }
        return result;
    }

    @Override
    public List<File> getSuccessorLocations() {
        ArrayList<File> result = new ArrayList<File>();
        for (PLPInfo info : this.getMemberController().getSuccessors()) {
            File loc = info.getProjectLocation();
            if (null == loc) continue;
            result.add(loc);
        }
        return result;
    }

    public Script getBuildScript() {
        return null != this.mainBuildScript ? (Script)this.mainBuildScript.getModel() : null;
    }

    public boolean hasDefaultMainBuildScript() {
        File tmpBuild = new File(PersistenceUtils.vilFileLocation(this.name, this.getVersion(), this.getScriptLocation().getAbsolutePath()));
        return tmpBuild.exists();
    }

    protected void createMainRule() {
        if (null == this.mainBuildScript) {
            Script script = new Script(this.getProjectName(), Script.createDefaultParameter());
            Version version = null;
            try {
                version = new Version(this.getVersion());
            }
            catch (VersionFormatException e) {
                LOGGER.debug(e.getLocalizedMessage());
            }
            if (null != version) {
                script.setVersion(version);
            }
            this.mainBuildScript = new ScriptContainer(script, PersistenceUtils.getConfiguration(this.getProjectLocation()));
        }
        this.mainBuildScript.registerModelListener(this);
    }

    protected void setBuildScript(ScriptContainer mainBuildScript) {
        this.mainBuildScript = mainBuildScript;
        this.mainBuildScript.registerModelListener(this);
    }

    @Deprecated
    public void instantiate() {
        this.vilExecutor.startInstantiation(ProgressObserver.NO_OBSERVER, false);
    }

    public void instantiate(ProgressObserver observer) {
        this.vilExecutor.startInstantiation(observer, false);
    }

    public void instantiate(ProgressObserver observer, boolean waitFor) {
        this.vilExecutor.startInstantiation(observer, waitFor);
    }

    public void abortInstantiation() {
        this.vilExecutor.abortInstantiation();
    }

    public void addVilExecutionListener(IVilExecutionListener newListener) {
        this.vilExecutor.addListener(newListener);
    }

    public void removeVilExecutionListener(IVilExecutionListener oldListener) {
        this.vilExecutor.removeListener(oldListener);
    }

    public void register(IProductLineProjectListener listener) {
        this.plpListeners.add(listener);
    }

    public void unregister(IProductLineProjectListener listener) {
        this.plpListeners.remove(listener);
    }

    protected final void configurationPulled() {
        for (int i = 0; i < this.plpListeners.size(); ++i) {
            this.plpListeners.get(i).configurationPulled();
        }
    }

    public void close() {
        for (int i = 0; i < this.plpListeners.size(); ++i) {
            this.plpListeners.get(i).projectClosed();
        }
        PersistenceUtils.closeProject(this.getProjectLocation());
        ProgressObserver observer = ProgressObserver.NO_OBSERVER;
        try {
            VarModel.INSTANCE.locations().removeLocation(this.getConfigLocation(), observer);
        }
        catch (ModelManagementException e) {
            LOGGER.exception(e);
        }
        try {
            BuildModel.INSTANCE.locations().removeLocation(this.getScriptLocation(), observer);
        }
        catch (ModelManagementException e) {
            LOGGER.exception(e);
        }
        try {
            TemplateModel.INSTANCE.locations().removeLocation(this.getTemplateLocation(), observer);
        }
        catch (ModelManagementException e) {
            LOGGER.exception(e);
        }
        for (TopLevelModelAccessor.IModelAccessor<?> accessor : TopLevelModelAccessor.registered()) {
            Configuration.PathKind kind = Configuration.PathKind.valueOf(accessor.getPathKindHint());
            if (null == kind) {
                kind = Configuration.PathKind.IVML;
            }
            try {
                accessor.removeLocation(PersistenceUtils.getLocationFile(this.getProjectLocation(), kind), observer);
            }
            catch (ModelManagementException e) {
                LOGGER.exception(e);
            }
        }
        try {
            VarModel.INSTANCE.unload(this.getProject(), observer);
        }
        catch (ModelManagementException e) {
            LOGGER.exception(e);
        }
        try {
            BuildModel.INSTANCE.unload(this.getBuildScript(), observer);
        }
        catch (ModelManagementException e) {
            LOGGER.exception(e);
        }
        SPLsManager.INSTANCE.removePLP(this.getProjectID());
    }

    @Override
    public void notifyReplaced(Script oldModel, Script newModel) {
        for (int i = 0; i < this.plpListeners.size(); ++i) {
            this.plpListeners.get(i).buildScriptChanged();
        }
    }

    public void reason(ReasoningOperation desiredOperation, IReasonerListener listener) {
        this.createReasoningProcess(desiredOperation, listener).run();
    }

    protected final ReasoningProcess createReasoningProcess(ReasoningOperation desiredOperation, IReasonerListener listener) {
        ReasoningProcess process = null;
        process = desiredOperation == ReasoningOperation.CONSITENCY_CHECK ? new ReasoningProcess(this.getProject(), this.getReasonerConfig(), listener, ProgressObserver.NO_OBSERVER) : new ReasoningProcess(desiredOperation, this.getConfiguration(), this.getReasonerConfig(), listener, ProgressObserver.NO_OBSERVER);
        return process;
    }

    public String toString() {
        boolean varModelLoaded = null != this.varModel && null != this.varModel.getModel();
        return varModelLoaded ? ((Project)this.varModel.getModel()).getQualifiedName() : this.getProjectName();
    }

    public List<ModelInfo<Project>> listAvailableModels() {
        return this.varModel.listAvailableModels();
    }

    public Version getHighestVersion() {
        return this.varModel.getHighestVersion();
    }

    public boolean isSaveable() {
        return this.varModel.isSaveable();
    }

    public void save() throws PersistenceException {
        PathEnvironment projectsWorkspace = new PathEnvironment(this.getProjectLocation().getParentFile());
        File easyConfigFile = PersistenceUtils.getLocationFile(this.getProjectLocation(), Configuration.PathKind.IVML);
        Persistencer persistencer = new Persistencer(projectsWorkspace, this.getProjectLocation(), easyConfigFile.getAbsolutePath(), ProgressObserver.NO_OBSERVER);
        persistencer.save(this);
    }

    public List<SemanticErrorDescription> getParsingExceptions() {
        ArrayList<SemanticErrorDescription> exceptions = new ArrayList<SemanticErrorDescription>(2);
        if (null != this.varModel.getDescription()) {
            exceptions.add(this.varModel.getDescription());
        }
        if (null != this.mainBuildScript.getDescription()) {
            exceptions.add(this.mainBuildScript.getDescription());
        }
        return exceptions;
    }

    protected final boolean isTransformableVIL() {
        return this.mainBuildScript.isTransformable();
    }

    public void pullConfigFromPredecessors() {
        EASyConfigFileImporter importer = new EASyConfigFileImporter(this);
        MemberIterator predecessors = this.getMemberController().predecessors();
        while (predecessors.hasNext()) {
            PLPInfo predecessorPLP = predecessors.next();
            importer.copyConfigFiles(predecessorPLP, "." + predecessorPLP.getProjectName());
        }
        PersistenceUtils.refreshModels(this);
        this.getConfiguration().refresh();
        this.configurationPulled();
    }

    public void addScriptImport(ModelImport<Script> scriptImport) {
        ((Script)this.mainBuildScript.getModel()).addImport(scriptImport);
        this.mainBuildScript.setEdited(true);
    }

    public void buildScriptWasEdited() {
        this.mainBuildScript.setEdited(true);
    }

    public ProjectContainer getProjectContainer() {
        return this.varModel;
    }

    public ScriptContainer getScriptContainer() {
        return this.mainBuildScript;
    }

    public boolean isPreliminary() {
        return this.getClass() == PLPInfo.class;
    }
}

