/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.mgmt;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.Executor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;
import net.ssehub.easy.producer.core.mgmt.IVilExecutionListener;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.ProjectDescriptor;
import net.ssehub.easy.producer.core.mgmt.VilArgumentProvider;
import net.ssehub.easy.producer.core.persistence.internal.Activator;

public class VilExecutionThread
implements Runnable {
    private Executor executor;
    private PLPInfo plp;
    private ProgressObserver observer;
    private boolean successful;
    private List<IVilExecutionListener> listeners;

    public VilExecutionThread(PLPInfo plp) {
        this.plp = plp;
        this.listeners = new ArrayList<IVilExecutionListener>();
    }

    protected Executor createExecutor() {
        ProjectDescriptor me = new ProjectDescriptor(this.plp);
        Executor executor = new Executor(this.plp.getBuildScript()).addTarget(me).addConfiguration(this.plp.getConfiguration());
        int predCount = this.plp.getMemberController().getPredecessorsCount();
        if (0 == predCount) {
            executor.addSource(me);
        } else {
            IProjectDescriptor[] pred = new IProjectDescriptor[predCount + 1];
            int i = 0;
            pred[i++] = me;
            for (PLPInfo p : this.plp.getMemberController().getPredecessors()) {
                pred[i++] = new ProjectDescriptor(p);
            }
            executor.addSources(pred);
        }
        VilArgumentProvider.provideArguments(this.plp, executor);
        return executor;
    }

    public void addListener(IVilExecutionListener listener) {
        if (null != listener) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IVilExecutionListener listener) {
        if (null != listener) {
            this.listeners.remove(listener);
        }
    }

    public void startInstantiation(ProgressObserver observer, boolean waitFor) {
        if (null == this.executor) {
            this.successful = true;
            this.observer = observer != null ? observer : ProgressObserver.NO_OBSERVER;
            this.executor = this.createExecutor();
            Thread executionThread = new Thread(this);
            executionThread.start();
            if (waitFor) {
                try {
                    executionThread.join();
                }
                catch (InterruptedException e) {
                    Activator.getLogger(VilExecutionThread.class).exception(e);
                }
            }
        }
    }

    public void abortInstantiation() {
        if (null != this.executor) {
            this.successful = false;
            this.executor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean informFinished = false;
        try {
            this.executor.execute(this.observer, true);
            informFinished = true;
        }
        catch (VilException e) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).vilExecutionAborted(this.plp, e);
            }
        }
        finally {
            this.executor = null;
            this.observer = null;
            this.plp.refresh();
        }
        if (informFinished) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).vilExecutionFinished(this.plp, this.successful);
            }
        }
    }
}

