/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence;

import net.ssehub.easy.producer.core.persistence.Configuration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ConfigurationContentHandler
implements ContentHandler {
    static final String XML_ELT_CONFIGURATION = "configuration";
    static final String XML_ELT_PATH = "path";
    static final String XML_ATTR_KIND = "kind";
    static final String XML_ATTR_VALUE = "value";
    private final Configuration configuration;
    private boolean inConfig = false;

    ConfigurationContentHandler(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.inConfig) {
            if (XML_ELT_CONFIGURATION.equals(qName)) {
                this.inConfig = true;
            }
        } else if (XML_ELT_PATH.equals(qName)) {
            this.readPath(atts);
        }
    }

    private void readPath(Attributes atts) {
        Configuration.PathKind k;
        String value;
        String kind = atts.getValue(XML_ATTR_KIND);
        if (null != kind & null != (value = atts.getValue(XML_ATTR_VALUE)) && null != (k = Configuration.PathKind.valueOf(kind))) {
            this.configuration.setPathDirect(k, value);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inConfig && XML_ELT_CONFIGURATION.equals(qName)) {
            this.inConfig = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }
}

