/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public class IVMLFileWriter {
    private Set<Project> done;
    private final File folder;
    private boolean formatInitializer;
    private boolean forceCompoundTypes;

    public IVMLFileWriter(File folder) throws IOException {
        this.folder = folder;
        if (!folder.exists() || !folder.isDirectory()) {
            throw new IOException("The specified location \"" + folder.getAbsolutePath() + "\" is not an existing folder.");
        }
        this.done = new HashSet<Project>();
    }

    public void setFormatInitializer(boolean formatInitializer) {
        this.formatInitializer = formatInitializer;
    }

    public void forceComponundTypes(boolean forceCompoundTypes) {
        this.forceCompoundTypes = forceCompoundTypes;
    }

    public void save(Project mainProject) throws IOException {
        this.done.clear();
        this.write(mainProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Project project) throws IOException {
        if (!this.done.contains(project)) {
            this.done.add(project);
            OutputStreamWriter fWriter = null;
            try {
                File trgFile = new File(this.folder, project.getName() + ".ivml");
                fWriter = new FileWriter(trgFile);
                IVMLWriter iWriter = new IVMLWriter(fWriter);
                iWriter.setFormatInitializer(this.formatInitializer);
                iWriter.forceComponundTypes(this.forceCompoundTypes);
                project.accept(iWriter);
                iWriter.flush();
            }
            finally {
                if (null != fWriter) {
                    fWriter.close();
                }
            }
            int end = project.getImportsCount();
            for (int i = 0; i < end; ++i) {
                Project importedProject = (Project)project.getImport(i).getResolved();
                if (null == importedProject) continue;
                this.write(importedProject);
            }
        }
    }
}

