/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.io.FileUtils;
import net.ssehub.easy.basics.io.JarUtils;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.dslCore.DefaultLib;
import net.ssehub.easy.dslCore.TopLevelModelAccessor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AbstractRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildlangWriter;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ForStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.InstantiateExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Utils;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.datatypes.Entity;
import net.ssehub.easy.producer.core.persistence.datatypes.Model;
import net.ssehub.easy.producer.core.persistence.datatypes.ModelType;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.internal.DataStorage;
import net.ssehub.easy.producer.core.persistence.internal.StorageType;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ExpressionVersionRestriction;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.persistency.IVMLWriter;

public class PersistenceUtils {
    public static final String INSTANTIATOR_CONTROLLER_MULTIPLE = "No file will be instantiated by multiple engines";
    private static final String DEBUG_FILES_EXTENSION = "_debug";
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core");
    private static final Map<String, Configuration> CONFIGURATIONS = new HashMap<String, Configuration>();
    private static boolean defaultModelsLoaded = false;

    public static final Configuration getConfiguration(File projectFolder) {
        Configuration result;
        if (null == projectFolder) {
            result = new Configuration(Configuration.DEFAULT);
        } else {
            try {
                projectFolder = projectFolder.getCanonicalFile();
            }
            catch (IOException e) {
                LOGGER.info("invalid project path - using default configuration: " + projectFolder);
            }
            String key = projectFolder.getPath();
            result = CONFIGURATIONS.get(key);
            if (null == result) {
                result = new Configuration(projectFolder);
                CONFIGURATIONS.put(key, result);
            } else {
                result.checkForModification();
            }
        }
        return result;
    }

    public static final void closeProject(File projectFolder) {
        if (null != projectFolder) {
            try {
                CONFIGURATIONS.remove(projectFolder.getCanonicalFile().getPath());
            }
            catch (IOException e) {
                LOGGER.info("invalid project path - ignoring close request: " + projectFolder);
            }
        }
    }

    public static void updateLocations(Configuration config, Configuration.PathKind kind, ModelLocations<?> locations, ProgressObserver observer) throws ModelManagementException {
        for (int p = 0; p < config.getPathCount(kind); ++p) {
            locations.updateLocation(config.getPathFile(kind, p), observer);
        }
    }

    public static void addLocations(Configuration config, Configuration.PathKind kind, ModelLocations<?> locations, ProgressObserver observer) throws ModelManagementException {
        for (int p = 0; p < config.getPathCount(kind); ++p) {
            locations.addLocation(config.getPathFile(kind, p), observer);
        }
    }

    public static final void addLocation(Configuration config, ProgressObserver observer) throws ModelManagementException {
        ModelManagementException returnExc = null;
        try {
            PersistenceUtils.addLocations(config, Configuration.PathKind.IVML, VarModel.INSTANCE.locations(), observer);
        }
        catch (ModelManagementException exc) {
            returnExc = exc;
        }
        try {
            PersistenceUtils.addLocations(config, Configuration.PathKind.VIL, BuildModel.INSTANCE.locations(), observer);
        }
        catch (ModelManagementException exc) {
            returnExc = exc;
        }
        try {
            PersistenceUtils.addLocations(config, Configuration.PathKind.VTL, TemplateModel.INSTANCE.locations(), observer);
        }
        catch (ModelManagementException exc) {
            returnExc = exc;
        }
        for (TopLevelModelAccessor.IModelAccessor<?> accessor : TopLevelModelAccessor.registered()) {
            Configuration.PathKind kind = Configuration.PathKind.valueOf(accessor.getPathKindHint());
            if (null == kind) {
                kind = Configuration.PathKind.IVML;
            }
            for (int p = 0; p < config.getPathCount(kind); ++p) {
                try {
                    accessor.addLocation(config.getPathFile(kind, p).getAbsoluteFile(), observer);
                    continue;
                }
                catch (ModelManagementException exc) {
                    returnExc = exc;
                }
            }
        }
        if (null != returnExc) {
            throw returnExc;
        }
    }

    public static final File getLocationFile(File projectFolder, Configuration.PathKind kind) {
        return PersistenceUtils.getConfiguration(projectFolder).getPathFile(kind, 0);
    }

    public static final String storageFileLocation(String storagePath) {
        return storagePath + System.getProperty("File.Separator") + ".EASyConfig";
    }

    public static final String ivmlFileLocation(Project project, String storagePath) {
        String projectName = project.getQualifiedName();
        String projectVersion = null;
        Version version = project.getVersion();
        if (null != version) {
            projectVersion = version.getVersion();
        }
        return PersistenceUtils.ivmlFileLocation(projectName, projectVersion, storagePath);
    }

    public static final String vilFileLocation(Script buildScript, String storagePath) {
        String projectName = buildScript.getName();
        String projectVersion = null;
        Version version = buildScript.getVersion();
        if (null != version) {
            projectVersion = version.getVersion();
        }
        return PersistenceUtils.vilFileLocation(projectName, projectVersion, storagePath);
    }

    public static final String ivmlFileLocation(String projectName, String projectVersion, String storagePath) {
        return PersistenceUtils.modelFileLocation(projectName, projectVersion, storagePath, ".ivml");
    }

    public static final String vilFileLocation(String projectName, String projectVersion, String storagePath) {
        return PersistenceUtils.modelFileLocation(projectName, projectVersion, storagePath, ".vil");
    }

    public static final String modelFileLocation(String projectName, String projectVersion, String folder, Configuration.PathKind modelType) {
        String result = "";
        switch (modelType) {
            case IVML: {
                result = PersistenceUtils.ivmlFileLocation(projectName, projectVersion, folder);
                break;
            }
            case VIL: {
                result = PersistenceUtils.vilFileLocation(projectName, projectVersion, folder);
                break;
            }
            case VTL: {
                result = new File(folder, projectName + "vtl").getAbsolutePath();
                break;
            }
        }
        return result;
    }

    public static final String modelFileLocation(String projectName, String projectVersion, String storagePath, String extension) {
        File file = new File(storagePath);
        StringBuffer fileName = new StringBuffer(projectName.replaceAll("::", "_"));
        if (null != projectVersion) {
            fileName.append("_");
            fileName.append(projectVersion.replaceAll("\\.", "-"));
        }
        fileName.append(extension);
        file = new File(file, fileName.toString());
        String location = file.getAbsolutePath();
        LOGGER.debug("Model file to load: " + location);
        return location;
    }

    public static final Model loadModel(PathEnvironment pathEnv, String location, ModelType type) throws PersistenceException {
        DataStorage storage = new DataStorage(StorageType.XML, location, pathEnv);
        Model model = new Model(type);
        storage.loadModels(model);
        return model;
    }

    public static final PLPInfo loadRootPLPInfo(PathEnvironment pathEnv, String modelLocation, File projectLocation) {
        PLPInfo result = null;
        try {
            Model model = PersistenceUtils.loadModel(pathEnv, modelLocation, ModelType.ROOT);
            if (null != model && model.getEntityCount() > 0) {
                Entity entity = model.getEntity(0);
                String uuid = entity.getAttributeValue("id");
                String projectName = entity.getAttributeValue("name");
                String version = entity.getAttributeValue("version");
                if (null == projectLocation) {
                    String tmp = entity.getAttributeFileString("location");
                    projectLocation = pathEnv.makeAbsolute(tmp);
                }
                result = projectLocation.isFile() ? new PLPInfo(uuid, projectName, version, new File(modelLocation), projectLocation) : new PLPInfo(uuid, projectName, version, projectLocation);
            }
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void writeIVMLProject(Project project, String storagePath) throws PersistenceException {
        PersistenceUtils.writeIVMLProject(project, storagePath, false);
    }

    public static void writeIVMLProject(Project project, String storagePath, boolean debug) throws PersistenceException {
        File file = new File(PersistenceUtils.ivmlFileLocation(project, storagePath));
        if (debug) {
            File folder = file.getParentFile();
            String fileName = file.getName();
            int lastDot = fileName.lastIndexOf(46);
            String preName = fileName.substring(0, lastDot);
            String sufName = fileName.substring(lastDot, fileName.length());
            fileName = preName + DEBUG_FILES_EXTENSION + sufName;
            file = new File(folder, fileName);
        }
        URI location = file.toURI();
        List oldProjects = VarModel.INSTANCE.availableModels().getVisibleModelInfo(location);
        ArrayList<Project> allProjects = new ArrayList<Project>();
        boolean projectAdded = false;
        if (null != oldProjects && !oldProjects.isEmpty()) {
            for (int i = 0; i < oldProjects.size(); ++i) {
                ModelInfo info = oldProjects.get(i);
                if (info.getName().equals(project.getName()) && Version.equals(info.getVersion(), project.getVersion())) {
                    allProjects.add(project);
                    projectAdded = true;
                    continue;
                }
                if (!info.isResolved() || !info.getLocation().equals(location) || info.getName().equals(project.getName())) continue;
                allProjects.add((Project)info.getResolved());
            }
        }
        if (!projectAdded) {
            allProjects.add(project);
        }
        if (file.exists()) {
            file.delete();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            IVMLWriter writer = new IVMLWriter(fileWriter);
            ((Project)allProjects.get(0)).accept(writer);
            for (int i = 1; i < allProjects.size(); ++i) {
                fileWriter.append("\r\n");
                ((Project)allProjects.get(i)).accept(writer);
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public static void writeVILScript(Script buildScript, String storagePath) throws PersistenceException {
        File file = new File(PersistenceUtils.vilFileLocation(buildScript, storagePath));
        if (file.exists()) {
            file.delete();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            BuildlangWriter writer = new BuildlangWriter(fileWriter);
            buildScript.accept(writer);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        catch (VilException e) {
            throw new PersistenceException(e);
        }
    }

    public static void createIVMLProject(String projectName, Version version, String storagePath) throws PersistenceException {
        Project project = new Project(projectName);
        if (null != version) {
            project.setVersion(version);
        }
        PersistenceUtils.writeIVMLProject(project, storagePath);
    }

    public static final Version defaultVersion() {
        return new Version(0);
    }

    public static <M extends IModel> M loadModel(ModelManagement<M> modelManagement, File modelFile) throws ModelManagementException {
        modelManagement.locations().updateLocation(modelFile.getParentFile(), ProgressObserver.NO_OBSERVER);
        modelManagement.updateModelInformation(modelFile, ProgressObserver.NO_OBSERVER);
        ModelInfo<M> info = modelManagement.availableModels().getInfo(modelFile.toURI());
        return modelManagement.load(info);
    }

    public static void refreshModels(PLPInfo plp) {
        try {
            VarModel.INSTANCE.updateModelInformation(plp.getConfigLocation(), ProgressObserver.NO_OBSERVER);
            BuildModel.INSTANCE.updateModelInformation(plp.getScriptLocation(), ProgressObserver.NO_OBSERVER);
            TemplateModel.INSTANCE.updateModelInformation(plp.getTemplateLocation(), ProgressObserver.NO_OBSERVER);
            if (null != plp.getProject()) {
                VarModel.INSTANCE.resolveImports(plp.getProject(), plp.getConfigLocation().toURI(), null);
            }
            if (null != plp.getBuildScript()) {
                BuildModel.INSTANCE.resolveImports(plp.getBuildScript(), plp.getScriptLocation().toURI(), null);
            }
        }
        catch (ModelManagementException e) {
            LOGGER.exception(e);
        }
        catch (NullPointerException e) {
            LOGGER.exception(e);
        }
    }

    public static void createInstantiatePredecessorScript(PLPInfo plp, PLPInfo ... parentPLPs) {
        Script mainScript = plp.getBuildScript();
        AbstractRule mainRule = mainScript.getMainRule(true);
        if (null != parentPLPs) {
            int n = parentPLPs.length;
            for (int j = 0; j < n; ++j) {
                ModelImport scriptImport;
                int i;
                Script parentScript = parentPLPs[j].getBuildScript();
                Script resolved = null;
                for (i = 0; i < mainScript.getImportsCount() && resolved == null; ++i) {
                    scriptImport = mainScript.getImport(i);
                    if (!scriptImport.getName().equals(parentScript.getName())) continue;
                    resolved = (Script)scriptImport.getResolved();
                }
                if (null == resolved) {
                    PersistenceUtils.addScriptImportToPLP(plp, parentPLPs[j]);
                    BuildModel.INSTANCE.resolveImports(mainScript, null, null);
                    for (i = 0; i < mainScript.getImportsCount() && resolved == null; ++i) {
                        scriptImport = mainScript.getImport(i);
                        if (!scriptImport.getName().equals(parentScript.getName())) continue;
                        resolved = (Script)scriptImport.getResolved();
                    }
                }
                if (null == resolved || mainRule.getBodyElementCount() != 0) continue;
                try {
                    VariableDeclaration p = new VariableDeclaration("predecessor", IvmlTypes.projectType());
                    VariableExpression sourceVar = new VariableExpression((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)mainRule.getParameter(0));
                    CallExpression predecessorAccess = new CallExpression((Object)mainRule, "predecessors", sourceVar);
                    ((Expression)predecessorAccess).inferType();
                    CallArgument sourceProject = new CallArgument(new VariableExpression(p));
                    CallArgument config = new CallArgument(new VariableExpression((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)mainRule.getParameter(1)));
                    CallArgument targetProject = new CallArgument(new VariableExpression((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)mainRule.getParameter(2)));
                    InstantiateExpression forBody = new InstantiateExpression(p, null, null, sourceProject, config, targetProject);
                    ((Expression)forBody).inferType();
                    ExpressionStatement bodyStatement = new ExpressionStatement(forBody);
                    VariableDeclaration[] mapVariables = new VariableDeclaration[]{p};
                    ForStatement forEachLoop = new ForStatement(mapVariables, predecessorAccess, new IRuleElement[]{bodyStatement}, new TypeDescriptor[]{p.getType()}, true);
                    mainRule.setBody(new IRuleElement[]{forEachLoop});
                    plp.buildScriptWasEdited();
                    continue;
                }
                catch (VilException e) {
                    LOGGER.warn("Rule could not be modified. Reason: " + e.getMessage());
                }
            }
        }
    }

    public static final void addImport(PLPInfo plp, PLPInfo predecessor, boolean considerVIL) {
        String projectName = null != predecessor.getProject() ? predecessor.getProject().getName() : predecessor.getProjectName();
        boolean hasProjectVersion = null != predecessor.getProject() && null != predecessor.getProject().getVersion();
        ProjectImport parentImport = new ProjectImport(projectName, null);
        if (hasProjectVersion) {
            Version clonedVersion = null;
            try {
                clonedVersion = new Version(predecessor.getProject().getVersion().getVersion());
            }
            catch (VersionFormatException e) {
                LOGGER.exception(e);
            }
            try {
                DecisionVariableDeclaration[] vars = ExpressionVersionRestriction.createRestrictionVars(projectName);
                ConstraintSyntaxTree expr = ExpressionVersionRestriction.createSingleRestriction(vars[1], "==", clonedVersion);
                parentImport.setRestrictions(new ExpressionVersionRestriction(expr, vars[0], vars[1]));
            }
            catch (RestrictionEvaluationException e) {
                LOGGER.exception(e);
            }
            catch (CSTSemanticException e) {
                LOGGER.exception(e);
            }
            catch (ValueDoesNotMatchTypeException e) {
                LOGGER.exception(e);
            }
        }
        plp.getProject().addImport(parentImport);
        if (considerVIL) {
            PersistenceUtils.addScriptImportToPLP(plp, predecessor);
        }
    }

    private static void addScriptImportToPLP(PLPInfo plp, PLPInfo predecessor) {
        boolean hasScriptVersion;
        String scriptName = null != predecessor.getBuildScript() ? predecessor.getBuildScript().getName() : predecessor.getProjectName();
        ModelImport<Script> scriptImport = new ModelImport<Script>(scriptName);
        boolean bl = hasScriptVersion = null != predecessor.getBuildScript() && null != predecessor.getBuildScript().getVersion();
        if (hasScriptVersion) {
            Version clonedVersion = null;
            try {
                clonedVersion = new Version(predecessor.getBuildScript().getVersion().getVersion());
            }
            catch (VersionFormatException e) {
                LOGGER.exception(e);
            }
            try {
                scriptImport.setRestrictions(Utils.createSingleRestriction(plp.getBuildScript(), "==", clonedVersion));
            }
            catch (RestrictionEvaluationException e) {
                LOGGER.exception(e);
            }
        }
        plp.addScriptImport(scriptImport);
    }

    public static void loadDefaultModels(ProgressObserver observer) {
        PersistenceUtils.loadDefaultModels(PersistenceUtils.class.getClassLoader(), observer, null);
    }

    public static void loadDefaultModels(ProgressObserver observer, Map<Configuration.PathKind, File> alternativePaths) {
        PersistenceUtils.loadDefaultModels(PersistenceUtils.class.getClassLoader(), observer, alternativePaths);
    }

    public static void loadDefaultModels(ClassLoader loader, ProgressObserver observer, Map<Configuration.PathKind, File> alternativePaths) {
        if (!defaultModelsLoaded) {
            defaultModelsLoaded = true;
            ArrayList<URL> libs = new ArrayList<URL>();
            URL dfltUrl = null;
            try {
                dfltUrl = DefaultLib.findDefaultLibURL(loader, DefaultLib.composePluginPattern("net.ssehub.easy.producer.core"), "de.uni_hildesheim.sse.EASy-Producer.persistence");
            }
            catch (IOException e) {
                EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core").error("While retrieving fallback libary URL: " + e.getMessage());
            }
            DefaultLib.appendQuietly(libs, dfltUrl);
            DefaultLib.appendAll(libs);
            int count = 0;
            for (URL url : libs) {
                EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core").info("Trying to load default IVML/VIL library from '" + url);
                try {
                    File defltLibFolder;
                    ModelLocations.Location defltLibLocation;
                    String urlString = url.toString().replace(" ", "%20");
                    URI uri = new URI(urlString);
                    if (JarUtils.isJarURL(url)) {
                        File file = FileUtils.createTmpDir("easyDefaultLib_" + count);
                        JarUtils.unpackJar(url, file);
                        uri = file.toURI();
                    }
                    if (null == (defltLibLocation = VarModel.INSTANCE.locations().getLocationFor(uri)) && FileUtils.isFileURI(uri) && (defltLibFolder = new File(uri)).exists()) {
                        Configuration cfg = PersistenceUtils.getDefaultModelsConfiguration(defltLibFolder, alternativePaths);
                        PersistenceUtils.addLocation(cfg, observer);
                        EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core").info("Loaded default IVML/VIL library from '" + url);
                    }
                    ++count;
                }
                catch (URISyntaxException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core").error("While loading default library in '" + url + "': " + e.getMessage());
                }
                catch (ModelManagementException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core").error("While loading default library in '" + url + "': " + e.getMessage());
                }
                catch (IOException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core").error("While loading default library in '" + url + "': " + e.getMessage());
                }
            }
        }
    }

    private static Configuration getDefaultModelsConfiguration(File folder, Map<Configuration.PathKind, File> alternativePaths) {
        Configuration result = new Configuration(folder);
        if (null != alternativePaths) {
            for (Map.Entry<Configuration.PathKind, File> entry : alternativePaths.entrySet()) {
                try {
                    result.setPath(entry.getKey(), entry.getValue());
                }
                catch (IOException e) {
                    EASyLoggerFactory.INSTANCE.getLogger(PersistenceUtils.class, "net.ssehub.easy.producer.core").error("While loading default library and using " + (Object)((Object)entry.getKey()) + "= " + entry.getValue() + ": " + e.getMessage() + " - using default");
                }
            }
        }
        return result;
    }
}

