/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.datatypes;

import java.io.File;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.Model;
import net.ssehub.easy.producer.core.persistence.datatypes.ModelType;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.producer.core.varMod.container.ScriptContainer;
import net.ssehub.easy.varModel.model.Project;

public class PersistentProject {
    private Model[] models;
    private ProjectContainer project;
    private ScriptContainer mainBuildScript;
    private File location;
    private String id;
    private String projectName;

    public PersistentProject(File location) {
        this.location = location;
        this.project = null;
        this.createModels();
    }

    public PersistentProject(Project project, File location, File configFolder, Model ... models) {
        this(location);
        this.project = new ProjectContainer(project, PersistenceUtils.getConfiguration(location));
        for (int i = 0; i < models.length; ++i) {
            this.exchangeModel(models[i]);
        }
    }

    private void createModels() {
        this.models = new Model[ModelType.values().length];
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i] = new Model(ModelType.values()[i]);
        }
    }

    public void exchangeModel(Model model) {
        boolean found = false;
        for (int i = 0; !found && i < this.models.length; ++i) {
            if (this.models[i].getModelType() != model.getModelType()) continue;
            this.models[i] = model;
        }
    }

    public ProjectContainer getProject() {
        return this.project;
    }

    public ScriptContainer getMainBuildScript() {
        return this.mainBuildScript;
    }

    public Model getModel(ModelType type) {
        Model model = null;
        for (int i = 0; null == model && i < this.models.length; ++i) {
            if (this.models[i].getModelType() != type) continue;
            model = this.models[i];
        }
        return model;
    }

    public int getModelCount() {
        return this.models.length > 0 ? this.models.length : -1;
    }

    public Model getModel(int index) {
        return this.models[index];
    }

    @Deprecated
    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setName(String projectName) {
        this.projectName = projectName;
    }

    public String getName() {
        return this.projectName;
    }

    public Version getVersion() {
        Version version = null;
        if (null != this.project) {
            version = this.project.getVersion();
        }
        return version;
    }

    public void setProject(Project project, Configuration location) {
        this.project = new ProjectContainer(project, location);
    }

    public void setVarModel(ProjectContainer varModel) {
        this.project = varModel;
    }

    public void setScript(Script mainBuildScript, Configuration location) {
        this.mainBuildScript = new ScriptContainer(mainBuildScript, location);
    }

    public void setScript(ScriptContainer mainBuildScript) {
        this.mainBuildScript = mainBuildScript;
    }

    public File getLocation() {
        return this.location;
    }
}

