/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.internal;

import java.io.File;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.datatypes.Model;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.persistence.internal.StorageConnector;
import net.ssehub.easy.producer.core.persistence.internal.StorageType;
import net.ssehub.easy.producer.core.persistence.internal.xml.XmlConnector;

public class DataStorage
implements StorageConnector {
    private StorageType type;
    private String location;
    private StorageConnector connector;
    private PathEnvironment pathEnv;

    public DataStorage(StorageType type, String location, PathEnvironment pathEnv) {
        this.type = type;
        this.location = location;
        this.pathEnv = pathEnv;
        this.createConnector();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String storageLocation) {
        this.location = storageLocation;
    }

    public void createConnector() {
        switch (this.type) {
            case XML: {
                String config = this.location + File.separator + ".EASyConfig";
                this.connector = new XmlConnector(config, this.pathEnv);
                break;
            }
            default: {
                this.connector = null;
            }
        }
    }

    @Override
    public void loadModels(Model ... models) throws PersistenceException {
        this.connector.loadModels(models);
    }

    @Override
    public void loadModels(PersistentProject project) throws PersistenceException {
        this.connector.loadModels(project);
    }

    @Override
    public void saveModels(PersistentProject project) throws PersistenceException {
        this.connector.saveModels(project);
    }

    @Override
    public String getProjectID() {
        return this.connector.getProjectID();
    }

    @Override
    public PathEnvironment getPathEnvironment() {
        return this.pathEnv;
    }
}

