/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import java.io.File;
import java.io.FileFilter;
import net.ssehub.easy.producer.core.persistence.Configuration;

public class EASyConfigFileFilter
implements FileFilter {
    private boolean copyIVML = false;
    private boolean copyVIL = false;
    private boolean copyVTL = false;

    public EASyConfigFileFilter(Configuration.PathKind ... elementsToCopy) {
        if (null == elementsToCopy || 0 == elementsToCopy.length) {
            this.copyIVML = true;
            this.copyVIL = true;
            this.copyVTL = true;
        } else {
            block5: for (int i = 0; i < elementsToCopy.length; ++i) {
                switch (elementsToCopy[i]) {
                    case IVML: {
                        this.copyIVML = true;
                        continue block5;
                    }
                    case VIL: {
                        this.copyVIL = true;
                        continue block5;
                    }
                    case VTL: {
                        this.copyVTL = true;
                        continue block5;
                    }
                }
            }
        }
    }

    private boolean considerIVMLFiles(String file) {
        return this.copyIVML && (file.endsWith(".ivml") || file.endsWith(".text"));
    }

    private boolean considerVILFiles(String file) {
        return this.copyVIL && file.endsWith(".vil");
    }

    private boolean considerVTLFiles(String file) {
        return this.copyVTL && file.endsWith(".vtl");
    }

    private boolean isEASyConfigFile(String filename) {
        String file = filename.toLowerCase();
        return this.considerIVMLFiles(file) || this.considerVILFiles(file) || this.considerVTLFiles(file);
    }

    @Override
    public boolean accept(File file) {
        return file.isDirectory() ^ this.isEASyConfigFile(file.getName());
    }
}

