/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import de.uni_hildesheim.sse.BuildLangModelUtility;
import de.uni_hildesheim.sse.ModelUtility;
import de.uni_hildesheim.sse.vil.templatelang.TemplateLangModelUtility;
import net.ssehub.easy.basics.Environment;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.dslCore.EclipseResourceInitializer;
import net.ssehub.easy.dslCore.StandaloneInitializer;
import net.ssehub.easy.dslCore.TopLevelModelAccessor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.varModel.management.VarModel;

public abstract class EASyInitializer {
    public static final String IVML_EXTENSION = ModelUtility.INSTANCE.getExtension();
    public static final String VIL_EXTENSION = BuildLangModelUtility.INSTANCE.getExtension();
    public static final String VTL_EXTENSION = TemplateLangModelUtility.INSTANCE.getExtension();
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(EASyInitializer.class, "net.ssehub.easy.producer.core");

    public static void setInitializer() {
        EASyInitializer.setInitializer(Environment.runsInEclipse());
        ProgressObserver observer = ProgressObserver.NO_OBSERVER;
        try {
            VarModel.INSTANCE.loaders().registerLoader(ModelUtility.INSTANCE, observer);
        }
        catch (ModelManagementException e) {
            LOGGER.exception(e);
        }
        try {
            BuildModel.INSTANCE.loaders().registerLoader(BuildLangModelUtility.INSTANCE, observer);
        }
        catch (ModelManagementException e) {
            LOGGER.exception(e);
        }
        try {
            TemplateModel.INSTANCE.loaders().registerLoader(TemplateLangModelUtility.INSTANCE, observer);
        }
        catch (ModelManagementException e) {
            LOGGER.exception(e);
        }
        for (TopLevelModelAccessor.IModelAccessor<?> accessor : TopLevelModelAccessor.registered()) {
            try {
                accessor.registerLoader(observer);
            }
            catch (ModelManagementException e) {
                LOGGER.exception(e);
            }
        }
    }

    public static void setInitializer(boolean runsInEclipse) {
        if (runsInEclipse) {
            ModelUtility.setResourceInitializer(new EclipseResourceInitializer());
        } else {
            ModelUtility.setResourceInitializer(new StandaloneInitializer());
        }
    }
}

