/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import java.io.File;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleDescriptor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.Entity;
import net.ssehub.easy.producer.core.persistence.datatypes.IPersistencer;
import net.ssehub.easy.producer.core.persistence.datatypes.IProjectCreationResult;
import net.ssehub.easy.producer.core.persistence.datatypes.Model;
import net.ssehub.easy.producer.core.persistence.datatypes.ModelType;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.persistence.internal.DataStorage;
import net.ssehub.easy.producer.core.persistence.internal.StorageType;
import net.ssehub.easy.producer.core.persistence.standard.ModelLoader;
import net.ssehub.easy.producer.core.persistence.standard.PLP2ProjectConverter;
import net.ssehub.easy.producer.core.persistence.standard.PersistenceConstants;
import net.ssehub.easy.producer.core.persistence.standard.PersistentProject2PLPConverter;
import net.ssehub.easy.producer.core.persistence.standard.ProjectCreationResult;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.producer.core.varMod.container.ScriptContainer;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public class Persistencer
implements IPersistencer,
PersistenceConstants {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(Persistencer.class, "net.ssehub.easy.producer.core");
    private DataStorage storage;
    private ProgressObserver observer;
    private File projectFolder;

    public Persistencer(PathEnvironment pathEnv, File projectFolder, String storageFile, ProgressObserver observer) {
        this.projectFolder = projectFolder;
        this.storage = new DataStorage(StorageType.XML, storageFile, pathEnv);
        this.observer = observer;
    }

    private void loadDefaultModels() {
        PersistenceUtils.loadDefaultModels(Persistencer.class.getClassLoader(), this.observer, null);
    }

    @Override
    public PersistentProject load() throws PersistenceException {
        this.loadDefaultModels();
        Configuration config = PersistenceUtils.getConfiguration(this.projectFolder);
        PersistentProject project = new PersistentProject(this.projectFolder);
        this.storage.loadModels(project);
        try {
            PersistenceUtils.addLocation(config, this.observer);
        }
        catch (ModelManagementException e) {
            throw new PersistenceException(e);
        }
        Model rootModel = project.getModel(ModelType.ROOT);
        Entity projectInformation = rootModel.getEntity(0);
        String projectName = projectInformation.getAttributeValue("name");
        project.setName(projectName);
        String projectVersion = projectInformation.getAttributeValue("version");
        LOGGER.debug("Loaded Project \"" + projectName + "\" in " + projectVersion + ".");
        ModelLoader projectLoader = new ModelLoader(project, config);
        projectLoader.loadModel(projectName, projectVersion, Configuration.PathKind.IVML);
        ModelLoader scriptLoader = new ModelLoader(project, config);
        scriptLoader.loadModel(projectName, projectVersion, Configuration.PathKind.VIL);
        project.setID(projectInformation.getAttributeValue("id"));
        return project;
    }

    public PLPInfo loadPLP() throws PersistenceException {
        PersistentProject pProject = this.load();
        PersistentProject2PLPConverter converter = new PersistentProject2PLPConverter(this, pProject);
        return converter.persistentProject2PLP();
    }

    @Override
    public IProjectCreationResult createProject(String projectName, File parentFolder, String projectID, boolean lazy) throws PersistenceException {
        boolean projectOk;
        ProjectCreationResult result = null;
        File projectFolder = new File(parentFolder, projectName);
        Configuration config = PersistenceUtils.getConfiguration(projectFolder);
        File configFolder = config.getPathFile(Configuration.PathKind.IVML, 0);
        File scriptFolder = config.getPathFile(Configuration.PathKind.VIL, 0);
        if (lazy) {
            projectOk = true;
            if (!configFolder.exists()) {
                File vtlFolder;
                projectOk = configFolder.mkdirs();
                if (!configFolder.equals(scriptFolder)) {
                    projectOk = scriptFolder.mkdirs();
                }
                if (!scriptFolder.equals(vtlFolder = config.getPathFile(Configuration.PathKind.VTL, 0))) {
                    projectOk = vtlFolder.mkdirs();
                }
            }
        } else {
            projectOk = configFolder.mkdirs();
            if (!configFolder.equals(scriptFolder)) {
                projectOk = scriptFolder.mkdirs();
            }
        }
        if (projectOk) {
            this.loadDefaultModels();
            try {
                PersistenceUtils.addLocation(config, this.observer);
            }
            catch (ModelManagementException e) {
                LOGGER.exception(e);
            }
        } else {
            throw new PersistenceException("System cannot create folders for the new project at the specified location: " + parentFolder);
        }
        Project varModel = new Project(projectName);
        varModel.setVersion(PersistenceUtils.defaultVersion());
        VariableDeclaration[] declarations = Script.createDefaultParameter();
        Script mainBuildScript = new Script(projectName, declarations);
        mainBuildScript.setVersion(PersistenceUtils.defaultVersion());
        Rule main = new Rule("main", false, declarations, new RuleDescriptor(), mainBuildScript);
        mainBuildScript.addRule(main);
        PersistentProject pProject = new PersistentProject(varModel, projectFolder, configFolder, new Model[0]);
        pProject.setScript(new ScriptContainer(mainBuildScript, null, config, true));
        pProject.setID(projectID);
        pProject.setName(projectName);
        this.save(pProject);
        String configPath = configFolder.getAbsolutePath();
        String scriptPath = scriptFolder.getAbsolutePath();
        File configFile = new File(PersistenceUtils.ivmlFileLocation(varModel, configPath));
        VarModel.INSTANCE.updateModel(varModel, configFile.toURI());
        File buildFile = new File(PersistenceUtils.vilFileLocation(mainBuildScript, scriptPath));
        BuildModel.INSTANCE.updateModel(mainBuildScript, buildFile.toURI());
        result = new ProjectCreationResult(projectFolder, projectID, configFile, varModel, mainBuildScript);
        return result;
    }

    @Override
    public void save(PLPInfo plp) throws PersistenceException {
        PLP2ProjectConverter converter = new PLP2ProjectConverter(plp, this);
        PersistentProject project = converter.plp2PersistentProject();
        this.save(project);
        this.writeDebugData(plp);
    }

    private void writeDebugData(PLPInfo plp) throws PersistenceException {
        if (plp.getSaveDebugInformation()) {
            Configuration config = PersistenceUtils.getConfiguration(plp.getProjectLocation());
            String projectPath = config.getPathFile(Configuration.PathKind.IVML, 0).getAbsolutePath();
            try {
                Project debugedConfig = plp.getConfiguration().toProject(true, false);
                PersistenceUtils.writeIVMLProject(debugedConfig, projectPath, true);
            }
            catch (ConfigurationException e) {
                LOGGER.exception(e);
            }
        }
    }

    private void save(PersistentProject project) throws PersistenceException {
        ScriptContainer buildScript;
        Configuration config = PersistenceUtils.getConfiguration(project.getLocation());
        String projectPath = config.getPathFile(Configuration.PathKind.IVML, 0).getAbsolutePath();
        String scriptPath = config.getPathFile(Configuration.PathKind.VIL, 0).getAbsolutePath();
        ProjectContainer ivmlProject = project.getProject();
        if (ivmlProject.isSaveable()) {
            PersistenceUtils.writeIVMLProject((Project)ivmlProject.getModel(), projectPath);
        }
        if ((buildScript = project.getMainBuildScript()).isSaveable()) {
            PersistenceUtils.writeVILScript((Script)buildScript.getModel(), scriptPath);
            buildScript.setEdited(false);
        }
        this.storage.saveModels(project);
    }

    @Override
    public String getProjectID() {
        PathEnvironment pathEnv = this.storage.getPathEnvironment();
        File configFolder = PersistenceUtils.getLocationFile(this.projectFolder, Configuration.PathKind.IVML);
        this.storage = new DataStorage(StorageType.XML, configFolder.getAbsolutePath(), pathEnv);
        return this.storage.getProjectID();
    }

    @Override
    public void update() throws PersistenceException {
        try {
            Configuration config = PersistenceUtils.getConfiguration(this.projectFolder);
            PersistenceUtils.updateLocations(config, Configuration.PathKind.IVML, VarModel.INSTANCE.locations(), this.observer);
            PersistenceUtils.updateLocations(config, Configuration.PathKind.VIL, BuildModel.INSTANCE.locations(), this.observer);
            PersistenceUtils.updateLocations(config, Configuration.PathKind.VTL, TemplateModel.INSTANCE.locations(), this.observer);
        }
        catch (ModelManagementException e) {
            throw new PersistenceException(e.getMessage());
        }
    }

    @Override
    public PathEnvironment getPathEnvironment() {
        return this.storage.getPathEnvironment();
    }
}

