/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import java.io.File;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;

public class StandaloneProjectDescriptor
implements IProjectDescriptor {
    private IProjectDescriptor parent;
    private File base;
    private Script vilScript;

    public StandaloneProjectDescriptor(ModelInfo<Script> vilInfo, File base) throws ModelManagementException {
        this.parent = null;
        this.base = base;
        this.vilScript = BuildModel.INSTANCE.load(vilInfo);
    }

    public StandaloneProjectDescriptor(Script vilScript, File base) throws ModelManagementException {
        this.parent = null;
        this.base = base;
        this.vilScript = vilScript;
    }

    public StandaloneProjectDescriptor(IProjectDescriptor parent, File base) {
        this.parent = parent;
        this.base = base;
        if (!base.exists()) {
            base.mkdirs();
        }
        this.vilScript = parent.getMainVilScript();
    }

    @Override
    public File getBase() {
        return this.base;
    }

    @Override
    public int getPredecessorCount() {
        return null != this.parent ? 1 : 0;
    }

    @Override
    public IProjectDescriptor getPredecessor(int index) {
        if (index < 0 || index >= this.getPredecessorCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.parent;
    }

    @Override
    public Script getMainVilScript() {
        return this.vilScript;
    }

    @Override
    public ProgressObserver createObserver() {
        return ProgressObserver.NO_OBSERVER;
    }

    @Override
    public String getModelFolder(IProjectDescriptor.ModelKind kind) {
        String result;
        switch (kind) {
            case IVML: {
                result = "EASy";
                break;
            }
            case VIL: {
                result = "EASy";
                break;
            }
            case VTL: {
                result = "EASy";
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

