/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.varMod.container;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelData;
import net.ssehub.easy.basics.modelManagement.IModelListener;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.varMod.container.SemanticErrorDescription;

public abstract class ModelContainer<M extends IModel>
implements IModelListener<M>,
IModelData {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ModelContainer.class, "net.ssehub.easy.producer.core");
    private M model;
    private SemanticErrorDescription description;
    private ModelManagement<M> modelManager;
    private Configuration location;
    private IModelListener<M> listener;

    protected ModelContainer(M model, ModelManagement<M> modelManager, Configuration location) {
        this(model, null, modelManager, location);
    }

    protected ModelContainer(M model, SemanticErrorDescription description, ModelManagement<M> modelManager, Configuration location) {
        this.model = model;
        this.description = description;
        this.modelManager = modelManager;
        this.location = location;
        modelManager.events().addModelListener(model, this);
    }

    public M getModel() {
        return this.model;
    }

    @Override
    public Version getVersion() {
        Version version = null;
        if (null != this.model) {
            version = this.model.getVersion();
        }
        return version;
    }

    @Override
    public String getName() {
        return this.model.getName();
    }

    protected final File getLocation(Configuration.PathKind kind) {
        return this.location.getPathFile(kind, 0);
    }

    public abstract File getLocation();

    public SemanticErrorDescription getDescription() {
        return this.description;
    }

    public boolean isSaveable() {
        return null == this.description;
    }

    @Override
    public void notifyReplaced(M oldModel, M newModel) {
        this.model = newModel;
        this.description = null;
        if (null != this.listener) {
            this.listener.notifyReplaced(oldModel, newModel);
        }
    }

    public Version getHighestVersion() {
        Version highest = null;
        for (ModelInfo<M> models : this.listAvailableModels()) {
            if (highest == null) {
                highest = models.getVersion();
                continue;
            }
            if (models.getVersion().compareTo(highest) != 1) continue;
            highest = models.getVersion();
        }
        return highest;
    }

    public List<ModelInfo<M>> listAvailableModels() {
        ArrayList<ModelInfo<M>> availableModels = new ArrayList<ModelInfo<M>>();
        List<ModelInfo<M>> infos = this.modelManager.availableModels().getVisibleModelInfo(this.getLocation().toURI());
        for (int i = 0; i < infos.size(); ++i) {
            if (!infos.get(i).getName().equals(this.model.getName())) continue;
            availableModels.add(infos.get(i));
        }
        return availableModels;
    }

    public void setMainModel(ModelInfo<M> newMainModel) {
        if (this.listAvailableModels().contains(newMainModel) && null == newMainModel.getResolved()) {
            try {
                this.modelManager.load(newMainModel);
            }
            catch (ModelManagementException exc) {
                LOGGER.exception(exc);
            }
        }
    }

    public void registerModelListener(IModelListener<M> listener) {
        this.listener = listener;
    }

    public void unregisterModelListener() {
        this.listener = null;
    }
}

