/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse;

import java.util.ArrayList;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.PathEnvironmentFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaProjectHandler
implements PathEnvironmentFactory.IProjectHandler {
    public static final String CLASSPATH_ID = "classpath";
    public static final PathEnvironmentFactory.IProjectHandler INSTANCE = new JavaProjectHandler();

    private JavaProjectHandler() {
    }

    @Override
    public void addPaths(IProject project, PathEnvironment pathEnv) {
        try {
            IJavaProject jProject = JavaCore.create((IProject)project);
            if (null != project) {
                ArrayList<String> paths = new ArrayList<String>();
                IClasspathEntry[] entries = jProject.getResolvedClasspath(true);
                for (int e = 0; e < entries.length; ++e) {
                    IPath path;
                    IClasspathEntry entry = entries[e];
                    if (1 != entry.getEntryKind() || !(path = entry.getPath()).isAbsolute()) continue;
                    paths.add(path.toString());
                }
                if (!paths.isEmpty()) {
                    String[] tmp = new String[paths.size()];
                    paths.toArray(tmp);
                    pathEnv.addMapping(CLASSPATH_ID, tmp);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }
}

