/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.eclipse.EASyUtils;
import net.ssehub.easy.producer.eclipse.model.ProductLineProject;
import net.ssehub.easy.producer.eclipse.persistency.ResourcesMgmt;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class PLPWorkspaceListener
implements IResourceChangeListener {
    private static final Set<IProject> DISABLED = new HashSet<IProject>();
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(PLPWorkspaceListener.class, "net.ssehub.easy.producer.eclipse");
    private static PLPWorkspaceListener instance;

    private PLPWorkspaceListener() {
    }

    public static void register() {
        if (null == instance) {
            instance = new PLPWorkspaceListener();
            int eventMask = 7;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)instance, eventMask);
        }
    }

    public static void unregister() {
        if (null != instance) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)instance);
            instance = null;
        }
    }

    public static void disableFor(IProject project) {
        DISABLED.add(project);
    }

    public static void reenableFor(IProject project) {
        DISABLED.remove(project);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int eventType = event.getType();
        if (2 == eventType || 4 == eventType) {
            this.handleRemovedResource(event);
        } else if (1 == eventType) {
            this.handleOpenedResource(event);
        }
    }

    private void handleRemovedResource(IResourceChangeEvent preChangeEvent) {
        IProject project;
        IResource deletedResource = preChangeEvent.getResource();
        if (4 == deletedResource.getType() && !DISABLED.contains(project = (IProject)deletedResource)) {
            try {
                if (project.isOpen() && project.hasNature("de.uni_hildesheim.sse.EASy-Producer")) {
                    this.removeProject(project);
                }
            }
            catch (CoreException e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }

    private void removeProject(IProject deletedProject) {
        String projectID = ResourcesMgmt.INSTANCE.getIDfromResource((IResource)deletedProject);
        ProductLineProject deletedPLP = (ProductLineProject)SPLsManager.INSTANCE.getPLP(projectID);
        if (null != deletedPLP) {
            deletedPLP.close();
        }
    }

    private void handleOpenedResource(IResourceChangeEvent postChangeEvent) {
        IResourceDelta openedDelta = postChangeEvent.getDelta();
        if (null != openedDelta) {
            IResourceDelta[] children = openedDelta.getAffectedChildren();
            for (int i = 0; i < children.length; ++i) {
                IProject project;
                if (4 != children[i].getResource().getType() || DISABLED.contains(project = (IProject)children[i].getResource())) continue;
                try {
                    if (!project.exists() || !project.isOpen() || !project.hasNature("de.uni_hildesheim.sse.EASy-Producer")) continue;
                    PLPWorkspaceListener.addProject(project);
                    continue;
                }
                catch (CoreException e) {
                    LOGGER.exception((Exception)((Object)e));
                }
            }
        }
    }

    public static void addProject(IProject project) {
        try {
            EASyUtils.loadProject(project);
        }
        catch (PersistenceException e) {
            LOGGER.exception(e);
        }
    }
}

