/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.contributions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.Configuration;
import org.eclipse.core.resources.IProject;

public abstract class Contributions {
    private static final List<Contributions> REGISTERED = new ArrayList<Contributions>();

    public static synchronized void register(Contributions contribution) {
        if (null == contribution) {
            throw new IllegalArgumentException("null");
        }
        REGISTERED.add(contribution);
    }

    public static synchronized void unregister(Contributions contribution) {
        if (null == contribution) {
            throw new IllegalArgumentException("null");
        }
        REGISTERED.remove(contribution);
    }

    public static final synchronized boolean isEnabled(CoreFunction element) {
        boolean enabled = element.getEnabled();
        for (int c = 0; c < REGISTERED.size(); ++c) {
            enabled = element.combine(enabled, REGISTERED.get(c).isEnabledImpl(element));
        }
        return enabled;
    }

    protected abstract boolean isEnabledImpl(CoreFunction var1);

    public static boolean determineConfigurationPaths(IProject project, Configuration config) {
        boolean result = false;
        for (int c = 0; c < REGISTERED.size(); ++c) {
            result |= REGISTERED.get(c).determineConfigurationPathsImpl(project, config);
        }
        return result;
    }

    protected abstract boolean determineConfigurationPathsImpl(IProject var1, Configuration var2);

    public static void initializePLP(IProject project, PLPInfo plp, List<PLPInfo> plps) throws IOException {
        for (int c = 0; c < REGISTERED.size(); ++c) {
            REGISTERED.get(c).initializePLPImpl(project, plp, plps);
        }
    }

    protected abstract void initializePLPImpl(IProject var1, PLPInfo var2, List<PLPInfo> var3) throws IOException;

    protected abstract String getDefaultCopyMechanismIDImpl();

    public static final synchronized String getDefaultCopyMechanismID() {
        String result = null;
        for (int c = 0; null == result && c < REGISTERED.size(); ++c) {
            result = REGISTERED.get(c).getDefaultCopyMechanismIDImpl();
        }
        return result;
    }

    public static enum CoreFunction {
        PULL_CONFIGURATION(true);

        private boolean enabled;

        private CoreFunction(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        boolean combine(boolean val1, boolean val2) {
            boolean result = this.enabled ? val1 & val2 : val1 | val2;
            return result;
        }
    }
}

