/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.model;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import java.util.Set;
import java.util.UUID;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.core.mgmt.MemberIterator;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.standard.EASyConfigFileImporter;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.producer.core.varMod.container.ScriptContainer;
import net.ssehub.easy.producer.eclipse.internal.ReasoningProgressObserver;
import net.ssehub.easy.producer.eclipse.persistency.EASyPersistencer;
import net.ssehub.easy.producer.eclipse.persistency.ResourcesMgmt;
import net.ssehub.easy.reasoning.core.frontend.IReasonerListener;
import net.ssehub.easy.reasoning.core.frontend.ReasoningProcess;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningOperation;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public class ProductLineProject
extends PLPInfo {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ProductLineProject.class, "net.ssehub.easy.producer.eclipse");

    public ProductLineProject(String projectname, File projectLocation) {
        super(UUID.randomUUID().toString(), projectname, "0", projectLocation);
        Project project = new Project(projectname);
        Version version = null;
        try {
            version = new Version("0");
        }
        catch (VersionFormatException e1) {
            LOGGER.exception(e1);
        }
        project.setVersion(version);
        ProjectContainer varModel = new ProjectContainer(project, PersistenceUtils.getConfiguration(projectLocation));
        this.setProject(varModel);
        this.createMainRule();
        SPLsManager.INSTANCE.addPLP(this);
    }

    public ProductLineProject(String projectID, String projectName, ProjectContainer project, File projectLocation, ScriptContainer mainBuildScript) {
        super(projectID, projectName, Version.toString(project.getVersion()), projectLocation);
        this.setProject(project);
        this.setBuildScript(mainBuildScript);
        SPLsManager.INSTANCE.addPLP(this);
    }

    public boolean setPredecessors(List<String> predecessorIDs) {
        boolean changed = false;
        if (predecessorIDs != null) {
            Iterator<String> iterator = this.getMemberController().getPredecessorIDs().iterator();
            HashSet<String> newPredecessorsAsSet = new HashSet<String>(predecessorIDs);
            while (iterator.hasNext()) {
                String oldPredcessorID = iterator.next();
                if (newPredecessorsAsSet.contains(oldPredcessorID)) continue;
                this.getMemberController().removePredecessor(oldPredcessorID);
                changed = true;
            }
            Set<String> currentPredecessors = this.getMemberController().getPredecessorIDs();
            for (String predecessor : predecessorIDs) {
                if (currentPredecessors.contains(predecessor)) {
                    changed = true;
                }
                this.getMemberController().addPredecessor(predecessor);
            }
        }
        if (changed) {
            this.createMainRule();
        }
        return changed;
    }

    @Override
    public void pullConfigFromPredecessors() {
        EASyConfigFileImporter importer = new EASyConfigFileImporter(this);
        MemberIterator predecessors = this.getMemberController().predecessors();
        while (predecessors.hasNext()) {
            PLPInfo predecessorPLP = predecessors.next();
            importer.copyConfigFiles(predecessorPLP, "." + predecessorPLP.getProjectName());
        }
        EASyPersistencer.refreshModels(this);
        this.getConfiguration().refresh();
        this.configurationPulled();
    }

    @Override
    public void save() {
        EASyPersistencer persistencer = new EASyPersistencer(this.getProjectLocation());
        try {
            persistencer.save(this);
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
    }

    public void registerObserver(Observer observer) {
        this.getMemberController().addObserver(observer);
    }

    public void unRegisterObserver(Observer observer) {
        this.getMemberController().deleteObserver(observer);
    }

    public boolean isTransformable() {
        return this.isTransformableVIL();
    }

    @Override
    public void reason(ReasoningOperation desiredOperation, IReasonerListener listener) {
        if (null != ResourcesMgmt.INSTANCE.getWorkspace()) {
            ReasoningProcess process = this.createReasoningProcess(desiredOperation, listener);
            new ReasoningProgressObserver(process);
        } else {
            super.reason(desiredOperation, listener);
        }
    }

    public void createNewModel(Version version) throws PersistenceException {
        PersistenceUtils.createIVMLProject(this.getProjectName(), version, this.getConfigLocation().getAbsolutePath());
        try {
            VarModel.INSTANCE.updateModelInformation(this.getConfigLocation(), ProgressObserver.NO_OBSERVER);
        }
        catch (ModelManagementException exc) {
            LOGGER.exception(exc);
        }
        this.refreshArtifacts();
    }

    @Override
    public void refresh() {
        super.refresh();
        EASyPersistencer.refreshModels(this);
    }

    public void refreshArtifacts() {
        ResourcesMgmt.INSTANCE.refreshProject(this.getProjectName());
    }
}

