/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.Entity;
import net.ssehub.easy.producer.core.persistence.datatypes.IPersistencer;
import net.ssehub.easy.producer.core.persistence.datatypes.Model;
import net.ssehub.easy.producer.core.persistence.datatypes.ModelType;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.persistence.standard.PersistenceConstants;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.producer.eclipse.model.ProductLineProject;
import net.ssehub.easy.producer.eclipse.persistency.PersistencerFactory;
import net.ssehub.easy.producer.eclipse.persistency.ResourcesMgmt;
import net.ssehub.easy.reasoning.core.reasoner.AttributeException;
import net.ssehub.easy.reasoning.core.reasoner.AttributeValues;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;

public class EASyPersistencer
implements PersistenceConstants {
    private IPersistencer persistencer;

    public EASyPersistencer(File projectFolder) {
        this.persistencer = PersistencerFactory.getPersistencer(projectFolder);
    }

    public PLPInfo load() throws PersistenceException {
        PLPInfo plp = null;
        PersistentProject project = this.persistencer.load();
        plp = this.persistentProject2PLP(project);
        PersistenceUtils.refreshModels(plp);
        return plp;
    }

    public static void refreshModels(PLPInfo plp) {
        ResourcesMgmt.INSTANCE.refreshProject(plp.getProjectName());
        PersistenceUtils.refreshModels(plp);
    }

    public static File projectPath(PLPInfo plp) {
        Configuration config = PersistenceUtils.getConfiguration(plp.getProjectLocation());
        File configFolder = config.getPathFile(Configuration.PathKind.IVML, 0);
        String filename = PersistenceUtils.ivmlFileLocation(plp.getProject(), configFolder.getAbsolutePath());
        return new File(filename);
    }

    private PLPInfo persistentProject2PLP(PersistentProject project) throws PersistenceException {
        PLPInfo plp = null;
        Model model = project.getModel(ModelType.ROOT);
        String projectID = model.getEntity(0).getAttributes().get("id");
        String projectname = project.getName();
        plp = SPLsManager.INSTANCE.getPLP(projectID);
        if (plp == null || plp.isPreliminary()) {
            File location = project.getLocation();
            ProjectContainer varModel = project.getProject();
            plp = new ProductLineProject(projectID, projectname, varModel, location, project.getMainBuildScript());
        }
        block9: for (int i = 0; i < project.getModelCount(); ++i) {
            model = project.getModel(i);
            switch (model.getModelType()) {
                case PREDECESSORS: {
                    plp.getMemberController().setPredecessors(this.model2Relatives(model));
                    continue block9;
                }
                case SUCCESSORS: {
                    plp.getMemberController().setSuccessors(this.model2Relatives(model));
                    continue block9;
                }
                case INSTANTIATORS: {
                    continue block9;
                }
                case REASONERS: {
                    this.createReasonerConfiguration(plp, model);
                    continue block9;
                }
                case SETTINGS: {
                    if (model.getEntityCount() <= 0) continue block9;
                    String debug = model.getEntity(0).getAttributeValue("debug");
                    plp.setSaveDebugInformation(Boolean.valueOf(debug));
                    continue block9;
                }
            }
        }
        if (null != plp.getProject() && null != plp.getReasonerConfig().getAttributeValues()) {
            try {
                plp.getReasonerConfig().getAttributeValues().resolveUsing(plp.getProject(), true);
            }
            catch (AttributeException attributeException) {
                // empty catch block
            }
        }
        return plp;
    }

    private void createReasonerConfiguration(PLPInfo plp, Model model) {
        ReasonerConfiguration reasonerConfig = new ReasonerConfiguration();
        for (int i = 0; i < model.getEntityCount(); ++i) {
            Entity entity = model.getEntity(i);
            if (null != entity.getAttributeValue("timeout")) {
                reasonerConfig.setTimeout(Integer.valueOf(entity.getAttributeValue("timeout")));
            }
            if (null == entity.getAttributeValue("attribute")) continue;
            String attribute = entity.getAttributeValue("attribute");
            String values = entity.getAttributeValue("values");
            if (null == values) continue;
            ArrayList<String> attributeValues = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(values, ";");
            while (tokens.hasMoreTokens()) {
                attributeValues.add(tokens.nextToken());
            }
            AttributeValues attributes = reasonerConfig.getAttributeValues();
            if (null == attributes) {
                attributes = new AttributeValues();
                reasonerConfig.setAttributeValues(attributes);
            }
            attributes.addUnresolved(attribute, attributeValues);
        }
        plp.setReasonerConfig(reasonerConfig);
    }

    private List<PLPInfo> model2Relatives(Model model) {
        LinkedList<PLPInfo> relatives = new LinkedList<PLPInfo>();
        for (int j = 0; j < model.getEntityCount(); ++j) {
            Entity entity = model.getEntity(j);
            String id = entity.getAttributeValue("id");
            String memberName = entity.getAttributeValue("name");
            String version = entity.getAttributeValue("version");
            String tmp = entity.getAttributeFileString("location");
            File location = null != tmp ? this.persistencer.getPathEnvironment().makeAbsolute(tmp) : null;
            PLPInfo info = SPLsManager.INSTANCE.getPLP(id);
            if (null == info) {
                info = new PLPInfo(id, memberName, version, location);
                SPLsManager.INSTANCE.addPLP(info);
            }
            relatives.add(info);
        }
        return relatives;
    }

    public void save(PLPInfo plp) throws PersistenceException {
        this.persistencer.save(plp);
    }

    public String getProjectID() {
        return this.persistencer.getProjectID();
    }
}

