/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency;

import java.io.File;
import net.ssehub.easy.basics.Environment;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.IPersistencer;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.standard.Persistencer;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.EclipsePersistencer;

public class PersistencerFactory {
    public static IPersistencer getPersistencer(File projectFolder) {
        IPersistencer persistencer = null;
        if (Environment.runsInEclipse()) {
            persistencer = new EclipsePersistencer(projectFolder, null);
        } else {
            PathEnvironment projectsWorkspace = new PathEnvironment(projectFolder.getParentFile());
            File easyConfigFile = PersistenceUtils.getLocationFile(projectFolder, Configuration.PathKind.IVML);
            persistencer = new Persistencer(projectsWorkspace, projectFolder, easyConfigFile.getAbsolutePath(), ProgressObserver.NO_OBSERVER);
        }
        return persistencer;
    }
}

