/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.eclipse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.IPersistencer;
import net.ssehub.easy.producer.core.persistence.datatypes.IProjectCreationResult;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.persistence.standard.Persistencer;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.EclipseProjectCreationResult;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.IEclipseProjectCreationResult;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.NatureUtils;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.PathEnvironmentFactory;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.persistency.IVMLWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class EclipsePersistencer
implements IPersistencer {
    public static final File WORKSPACE_FOLDER;
    private Persistencer persistencer;
    private IProgressMonitor monitor;
    private IProject project;
    private File projectFolder;

    public EclipsePersistencer(String projectName, IProgressMonitor monitor) {
        this(new File(WORKSPACE_FOLDER, projectName), monitor);
    }

    public EclipsePersistencer(File projectFolder, IProgressMonitor monitor) {
        this.projectFolder = projectFolder;
        String projectName = projectFolder.getName();
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        PathEnvironment pathEnv = PathEnvironmentFactory.createPathEnvironment(this.project);
        File projectFolder2 = new File(pathEnv.getBaseFolder(), projectName);
        File storageFile = PersistenceUtils.getLocationFile(projectFolder2, Configuration.PathKind.IVML);
        this.persistencer = new Persistencer(pathEnv, projectFolder2, storageFile.getAbsolutePath(), ProgressObserver.NO_OBSERVER);
        this.monitor = null == monitor ? new NullProgressMonitor() : monitor;
    }

    private EclipseProjectCreationResult createEASyEclipseProject(String projectID, boolean lazy, String ... natures) throws PersistenceException, CoreException {
        if (null == projectID) {
            projectID = UUID.randomUUID().toString();
        }
        IPath folder = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (null != this.project.getLocation()) {
            folder = this.project.getLocation().removeLastSegments(1);
        }
        IProjectCreationResult result = this.createProject(this.project.getName(), folder.toFile(), projectID, lazy);
        if (!lazy) {
            this.project.create((IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        }
        this.project.open((IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
        if (!NatureUtils.hasNature(this.project, "org.eclipse.xtext.ui.shared.xtextNature")) {
            NatureUtils.addNature(this.project, "org.eclipse.xtext.ui.shared.xtextNature", this.monitor);
        }
        if (!NatureUtils.hasNature(this.project, "de.uni_hildesheim.sse.EASy-Producer")) {
            NatureUtils.addNature(this.project, "de.uni_hildesheim.sse.EASy-Producer", this.monitor);
        }
        return new EclipseProjectCreationResult(result, this.project);
    }

    public IEclipseProjectCreationResult createEASyProject(String projectID, boolean lazy, String ... natures) throws PersistenceException, CoreException {
        EclipseProjectCreationResult result = this.createEASyEclipseProject(projectID, lazy, natures);
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, this.monitor);
        return result;
    }

    public IEclipseProjectCreationResult createEASyProject(String projectID, Project varModel, String ... natures) throws PersistenceException, CoreException {
        EclipseProjectCreationResult result = this.createEASyEclipseProject(projectID, false, natures);
        Project projectModel = result.getVarModel();
        if (null != projectModel && null != varModel) {
            String modelPath = PersistenceUtils.ivmlFileLocation(varModel, result.getConfigFolder().getAbsolutePath());
            File varModelLocation = new File(modelPath);
            if (varModelLocation.exists()) {
                try {
                    varModelLocation.createNewFile();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            try {
                FileWriter fWriter = new FileWriter(varModelLocation);
                IVMLWriter ivmlWriter = new IVMLWriter(fWriter);
                varModel.accept(ivmlWriter);
                ivmlWriter.flush();
                fWriter.close();
                VarModel.INSTANCE.updateModel(varModel, varModelLocation.toURI());
                ProjectImport pi = new ProjectImport(varModel.getName(), null);
                projectModel.addImport(pi);
                fWriter = new FileWriter(result.getVarModelProjectPath());
                ivmlWriter = new IVMLWriter(fWriter);
                projectModel.accept(ivmlWriter);
                ivmlWriter.flush();
                fWriter.close();
                VarModel.INSTANCE.updateModel(projectModel, result.getVarModelProjectPath().toURI());
                result.setVarModelProjectPath(varModelLocation);
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, this.monitor);
        return result;
    }

    @Override
    public PersistentProject load() throws PersistenceException {
        PersistentProject pProject = this.persistencer.load();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectFolder.getName());
        if (null != project) {
            pProject.setName(project.getName());
        }
        return pProject;
    }

    @Override
    public void save(PLPInfo plp) throws PersistenceException {
        this.persistencer.save(plp);
    }

    @Override
    public IProjectCreationResult createProject(String projectName, File parentFolder, String projectID, boolean lazy) throws PersistenceException {
        return this.persistencer.createProject(projectName, parentFolder, projectID, lazy);
    }

    @Override
    public String getProjectID() {
        return this.persistencer.getProjectID();
    }

    @Override
    public void update() throws PersistenceException {
        this.persistencer.update();
    }

    @Override
    public PathEnvironment getPathEnvironment() {
        return this.persistencer.getPathEnvironment();
    }

    static {
        File wsFolder = null;
        try {
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            wsFolder = ws.getRoot().getLocation().toFile();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        WORKSPACE_FOLDER = wsFolder;
    }
}

