/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.eclipse;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class NatureUtils {
    private NatureUtils() {
    }

    public static boolean hasNature(IProject project, String ... natures) throws CoreException {
        boolean found = false;
        IProjectDescription description = project.getDescription();
        String[] pNatures = description.getNatureIds();
        for (int i = 0; !found && i < pNatures.length; ++i) {
            for (int j = 0; !found && j < natures.length; ++j) {
                found = pNatures[i].equals(natures[j]);
            }
        }
        return found;
    }

    public static void addNature(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = nature;
        description.setNatureIds(newNatures);
        if (project == null || !project.isOpen()) {
            throw new RuntimeException("Project not running");
        }
        project.setDescription(description, monitor);
    }

    public static void removeNature(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        for (int i = 0; i < natures.length; ++i) {
            if (!nature.equals(natures[i])) continue;
            String[] newNatures = new String[natures.length - 1];
            System.arraycopy(natures, 0, newNatures, 0, i);
            System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
            return;
        }
    }
}

