/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.eclipse;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.EclipsePersistencer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class PathEnvironmentFactory {
    private static List<IProjectHandler> handlers = new ArrayList<IProjectHandler>();

    private PathEnvironmentFactory() {
    }

    public static void registerHandler(IProjectHandler handler) {
        if (null != handler && !handlers.contains(handler)) {
            handlers.add(handler);
        }
    }

    public static void unregisterHandler(IProjectHandler handler) {
        if (null != handler) {
            handlers.remove(handler);
        }
    }

    public static PathEnvironment createPathEnvironment(IProject project) {
        IPath projectLocation = project.getLocation();
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        PathEnvironment pathEnv = null;
        pathEnv = null != projectLocation && !workspaceLocation.isPrefixOf(projectLocation) ? new PathEnvironment(projectLocation.removeLastSegments(1).toFile()) : new PathEnvironment(EclipsePersistencer.WORKSPACE_FOLDER);
        PathEnvironmentFactory.updatePathEnvironment(pathEnv, project);
        return pathEnv;
    }

    public static void updatePathEnvironment(PathEnvironment pathEnv, IProject project) {
        pathEnv.clear();
        if (null != project) {
            for (int h = 0; h < handlers.size(); ++h) {
                handlers.get(h).addPaths(project, pathEnv);
            }
        }
    }

    public static interface IProjectHandler {
        public void addPaths(IProject var1, PathEnvironment var2);
    }
}

