/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.eclipse.persistency.project_creation;

import java.util.UUID;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.producer.core.varMod.container.ScriptContainer;
import net.ssehub.easy.producer.eclipse.model.ProductLineProject;
import net.ssehub.easy.producer.eclipse.persistency.EASyPersistencer;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.EclipsePersistencer;
import net.ssehub.easy.producer.eclipse.persistency.eclipse.IEclipseProjectCreationResult;
import net.ssehub.easy.producer.eclipse.persistency.project_creation.IEASyProjectConfigurator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

abstract class AbstractProjectCreator {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(AbstractProjectCreator.class, "net.ssehub.easy.producer.eclipse");
    private ProductLineProject newPLP;
    private String projectName;
    private EclipsePersistencer persistencer;
    private IProject project;
    private boolean lazy;
    private IEASyProjectConfigurator[] configurators;

    protected AbstractProjectCreator(String projectName, boolean lazy, IEASyProjectConfigurator ... configurators) {
        this.projectName = projectName;
        this.lazy = lazy;
        this.configurators = configurators;
        this.persistencer = new EclipsePersistencer(projectName, null);
        this.project = null;
    }

    protected final ProductLineProject getCreatedProject() {
        return this.newPLP;
    }

    protected final boolean isLazyCreation() {
        return this.lazy;
    }

    protected final void createProject() {
        this.createNewEASyProject();
        if (!this.lazy) {
            this.configureProject();
        }
    }

    private void configureProject() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask("Create Java Project", 10);
        try {
            if (!this.project.exists()) {
                IProjectDescription desc = this.project.getWorkspace().newProjectDescription(this.project.getName());
                desc.setLocationURI(null);
                this.project.create(desc, (IProgressMonitor)monitor);
                monitor = null;
            }
            if (!this.project.isOpen()) {
                this.project.open((IProgressMonitor)monitor);
                monitor = null;
            }
        }
        catch (CoreException e) {
            LOGGER.exception((Exception)((Object)e));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        if (null != this.configurators) {
            for (IEASyProjectConfigurator configurator : this.configurators) {
                if (null == configurator) continue;
                this.configureProject(this.project, configurator);
            }
        }
    }

    protected abstract void configureProject(IProject var1, IEASyProjectConfigurator var2);

    private void createNewEASyProject() {
        String projectID = UUID.randomUUID().toString();
        IEclipseProjectCreationResult result = null;
        try {
            result = this.persistencer.createEASyProject(projectID, this.lazy, new String[0]);
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (null != result) {
            this.project = result.getIProject();
            if (null != result.getProjectID()) {
                this.newPLP = (ProductLineProject)SPLsManager.INSTANCE.getPLP(projectID);
            }
            if (null == this.newPLP && null != result.getVarModel()) {
                Script mainBuildScript = new Script(this.projectName, Script.createDefaultParameter());
                Version version = result.getVarModel().getVersion();
                if (null != version) {
                    mainBuildScript.setVersion(version);
                }
                Configuration location = PersistenceUtils.getConfiguration(result.getProjectFolder());
                ProjectContainer varModel = new ProjectContainer(result.getVarModel(), location);
                ScriptContainer instantiationModel = new ScriptContainer(mainBuildScript, location);
                instantiationModel.setEdited(true);
                this.newPLP = new ProductLineProject(projectID, this.projectName, varModel, result.getProjectFolder(), instantiationModel);
            }
        }
    }

    protected final void setPersistenceProperties() {
        QualifiedName qname = new QualifiedName("de.uni-hildesheim.sse.easy_producer.projectuuid", "projectid");
        try {
            this.project.setPersistentProperty(qname, this.newPLP.getProjectID());
            EASyPersistencer.refreshModels(this.newPLP);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    abstract ProductLineProject createEASyProject();
}

